/** @file
 * @brief Custom Lua exception handling.
 */
/* Warning: This file is generated by ./generate-lua-exceptions
 * - do not modify directly!
 *
 * Copyright (C) 2003,2004,2006,2007,2008,2011,2012 Olly Betts
 * Copyright (C) 2007 Lemur Consulting Ltd
 * Copyright (C) 2007 Richard Boulton
 * Copyright (C) 2011 Xiaona Han
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

%ignore Xapian::Error::Error(const Error&);
%include "xapian/error.h"

%{
namespace Xapian {
void handle_exception(lua_State* L) {
    try {
	throw;
    } catch (const Xapian::DatabaseClosedError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseClosedError(e), SWIGTYPE_p_Xapian__DatabaseClosedError, 1);
    } catch (const Xapian::DatabaseNotFoundError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseNotFoundError(e), SWIGTYPE_p_Xapian__DatabaseNotFoundError, 1);
    } catch (const Xapian::WildcardError &e) {
	SWIG_NewPointerObj(L, (void *)new WildcardError(e), SWIGTYPE_p_Xapian__WildcardError, 1);
    } catch (const Xapian::RangeError &e) {
	SWIG_NewPointerObj(L, (void *)new RangeError(e), SWIGTYPE_p_Xapian__RangeError, 1);
    } catch (const Xapian::SerialisationError &e) {
	SWIG_NewPointerObj(L, (void *)new SerialisationError(e), SWIGTYPE_p_Xapian__SerialisationError, 1);
    } catch (const Xapian::QueryParserError &e) {
	SWIG_NewPointerObj(L, (void *)new QueryParserError(e), SWIGTYPE_p_Xapian__QueryParserError, 1);
    } catch (const Xapian::NetworkTimeoutError &e) {
	SWIG_NewPointerObj(L, (void *)new NetworkTimeoutError(e), SWIGTYPE_p_Xapian__NetworkTimeoutError, 1);
    } catch (const Xapian::NetworkError &e) {
	SWIG_NewPointerObj(L, (void *)new NetworkError(e), SWIGTYPE_p_Xapian__NetworkError, 1);
    } catch (const Xapian::InternalError &e) {
	SWIG_NewPointerObj(L, (void *)new InternalError(e), SWIGTYPE_p_Xapian__InternalError, 1);
    } catch (const Xapian::FeatureUnavailableError &e) {
	SWIG_NewPointerObj(L, (void *)new FeatureUnavailableError(e), SWIGTYPE_p_Xapian__FeatureUnavailableError, 1);
    } catch (const Xapian::DocNotFoundError &e) {
	SWIG_NewPointerObj(L, (void *)new DocNotFoundError(e), SWIGTYPE_p_Xapian__DocNotFoundError, 1);
    } catch (const Xapian::DatabaseVersionError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseVersionError(e), SWIGTYPE_p_Xapian__DatabaseVersionError, 1);
    } catch (const Xapian::DatabaseOpeningError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseOpeningError(e), SWIGTYPE_p_Xapian__DatabaseOpeningError, 1);
    } catch (const Xapian::DatabaseModifiedError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseModifiedError(e), SWIGTYPE_p_Xapian__DatabaseModifiedError, 1);
    } catch (const Xapian::DatabaseLockError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseLockError(e), SWIGTYPE_p_Xapian__DatabaseLockError, 1);
    } catch (const Xapian::DatabaseCreateError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseCreateError(e), SWIGTYPE_p_Xapian__DatabaseCreateError, 1);
    } catch (const Xapian::DatabaseCorruptError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseCorruptError(e), SWIGTYPE_p_Xapian__DatabaseCorruptError, 1);
    } catch (const Xapian::DatabaseError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseError(e), SWIGTYPE_p_Xapian__DatabaseError, 1);
    } catch (const Xapian::UnimplementedError &e) {
	SWIG_NewPointerObj(L, (void *)new UnimplementedError(e), SWIGTYPE_p_Xapian__UnimplementedError, 1);
    } catch (const Xapian::InvalidOperationError &e) {
	SWIG_NewPointerObj(L, (void *)new InvalidOperationError(e), SWIGTYPE_p_Xapian__InvalidOperationError, 1);
    } catch (const Xapian::InvalidArgumentError &e) {
	SWIG_NewPointerObj(L, (void *)new InvalidArgumentError(e), SWIGTYPE_p_Xapian__InvalidArgumentError, 1);
    } catch (const Xapian::AssertionError &e) {
	SWIG_NewPointerObj(L, (void *)new AssertionError(e), SWIGTYPE_p_Xapian__AssertionError, 1);
    } catch (const Xapian::RuntimeError &e) {
	SWIG_NewPointerObj(L, (void *)new RuntimeError(e), SWIGTYPE_p_Xapian__RuntimeError, 1);
    } catch (const Xapian::LogicError &e) {
	SWIG_NewPointerObj(L, (void *)new LogicError(e), SWIGTYPE_p_Xapian__LogicError, 1);
    } catch (const std::exception& e) {
	lua_pushfstring(L, "std::exception: %s", e.what());
    } catch (...) {
	lua_pushstring(L, "Unknown exception");
    }
}
}
%}

/* Functions and methods which are marked as "nothrow": */
%exception Xapian::StemStopper::~StemStopper;
%exception Xapian::DocumentSet::~DocumentSet;
%exception Xapian::FreqSource::~FreqSource;
%exception Xapian::TermListGroup::~TermListGroup;
%exception Xapian::PointType::~PointType;
%exception Xapian::PointType::termlist_end() const;
%exception Xapian::Point::~Point;
%exception Xapian::Centroid::~Centroid;
%exception Xapian::Cluster::~Cluster;
%exception Xapian::ClusterSet::~ClusterSet;
%exception Xapian::Similarity::~Similarity;
%exception Xapian::CosineDistance::~CosineDistance;
%exception Xapian::Clusterer::~Clusterer;
%exception Xapian::KMeans::~KMeans;
%exception Xapian::LCDClusterer::~LCDClusterer;
%exception Xapian::Compactor::~Compactor;
%exception Xapian::get_constinfo_();
%exception Xapian::Database::~Database;
%exception Xapian::Database::postlist_end(std::string_view) const;
%exception Xapian::Database::termlist_end(Xapian::docid) const;
%exception Xapian::Database::positionlist_end(Xapian::docid, std::string_view) const;
%exception Xapian::Database::allterms_end(std::string_view = {}) const;
%exception Xapian::Database::valuestream_end(Xapian::valueno) const;
%exception Xapian::Database::spellings_end() const;
%exception Xapian::Database::synonyms_end(std::string_view) const;
%exception Xapian::Database::synonym_keys_end(std::string_view = {}) const;
%exception Xapian::Database::metadata_keys_end(std::string_view = {}) const;
%exception Xapian::WritableDatabase::~WritableDatabase;
%exception Xapian::Document::~Document;
%exception Xapian::Document::termlist_end() const;
%exception Xapian::Document::values_end() const;
%exception Xapian::Enquire::~Enquire;
%exception Xapian::Enquire::get_matching_terms_end(docid) const;
%exception Xapian::Enquire::get_matching_terms_end(const MSetIterator&) const;
%exception Xapian::Error::~Error;
%exception Xapian::Error::get_type() const;
%exception Xapian::Error::get_msg() const;
%exception Xapian::Error::get_context() const;
%exception Xapian::LogicError::~LogicError;
%exception Xapian::RuntimeError::~RuntimeError;
%exception Xapian::AssertionError::~AssertionError;
%exception Xapian::InvalidArgumentError::~InvalidArgumentError;
%exception Xapian::InvalidOperationError::~InvalidOperationError;
%exception Xapian::UnimplementedError::~UnimplementedError;
%exception Xapian::DatabaseError::~DatabaseError;
%exception Xapian::DatabaseCorruptError::~DatabaseCorruptError;
%exception Xapian::DatabaseCreateError::~DatabaseCreateError;
%exception Xapian::DatabaseLockError::~DatabaseLockError;
%exception Xapian::DatabaseModifiedError::~DatabaseModifiedError;
%exception Xapian::DatabaseOpeningError::~DatabaseOpeningError;
%exception Xapian::DatabaseVersionError::~DatabaseVersionError;
%exception Xapian::DocNotFoundError::~DocNotFoundError;
%exception Xapian::FeatureUnavailableError::~FeatureUnavailableError;
%exception Xapian::InternalError::~InternalError;
%exception Xapian::NetworkError::~NetworkError;
%exception Xapian::NetworkTimeoutError::~NetworkTimeoutError;
%exception Xapian::QueryParserError::~QueryParserError;
%exception Xapian::SerialisationError::~SerialisationError;
%exception Xapian::RangeError::~RangeError;
%exception Xapian::WildcardError::~WildcardError;
%exception Xapian::DatabaseNotFoundError::~DatabaseNotFoundError;
%exception Xapian::DatabaseClosedError::~DatabaseClosedError;
%exception Xapian::ESet::~ESet;
%exception Xapian::ESetIterator::~ESetIterator;
%exception Xapian::ESetIterator::operator==(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ESetIterator::operator!=(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ESetIterator::operator<(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ESetIterator::operator>(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ESetIterator::operator>=(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ESetIterator::operator<=(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ExpandDecider::~ExpandDecider;
%exception Xapian::ExpandDeciderAnd::~ExpandDeciderAnd;
%exception Xapian::ExpandDeciderFilterTerms::~ExpandDeciderFilterTerms;
%exception Xapian::ExpandDeciderFilterPrefix::~ExpandDeciderFilterPrefix;
%exception Xapian::miles_to_metres(double miles);
%exception Xapian::miles_to_metres(double miles);
%exception Xapian::metres_to_miles(double metres);
%exception Xapian::metres_to_miles(double metres);
%exception Xapian::LatLongCoord::~LatLongCoord;
%exception Xapian::LatLongCoord::LatLongCoord();
%exception Xapian::LatLongCoord::operator<(const LatLongCoord& other) const;
%exception Xapian::LatLongCoordsIterator::~LatLongCoordsIterator;
%exception Xapian::LatLongCoords::~LatLongCoords;
%exception Xapian::LatLongMetric::~LatLongMetric;
%exception Xapian::GreatCircleMetric::~GreatCircleMetric;
%exception Xapian::LatLongDistancePostingSource::~LatLongDistancePostingSource;
%exception Xapian::LatLongDistanceKeyMaker::~LatLongDistanceKeyMaker;
%exception Xapian::opt_intrusive_base::~opt_intrusive_base;
%exception Xapian::KeyMaker::~KeyMaker;
%exception Xapian::MultiValueKeyMaker::~MultiValueKeyMaker;
%exception Xapian::MatchDecider::~MatchDecider;
%exception Xapian::MatchDecider::MatchDecider();
%exception Xapian::MatchSpy::~MatchSpy;
%exception Xapian::MatchSpy::MatchSpy();
%exception Xapian::ValueCountMatchSpy::~ValueCountMatchSpy;
%exception Xapian::ValueCountMatchSpy::get_total() const;
%exception Xapian::ValueCountMatchSpy::values_end() const;
%exception Xapian::ValueCountMatchSpy::top_values_end(size_t) const;
%exception Xapian::MSet::~MSet;
%exception Xapian::MSetIterator::~MSetIterator;
%exception Xapian::MSetIterator::operator==(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::MSetIterator::operator!=(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::MSetIterator::operator<(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::MSetIterator::operator>(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::MSetIterator::operator>=(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::MSetIterator::operator<=(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::PositionIterator::~PositionIterator;
%exception Xapian::PositionIterator::PositionIterator();
%exception Xapian::PositionIterator::operator==(const PositionIterator& a, const PositionIterator& b);
%exception Xapian::PositionIterator::operator!=(const PositionIterator& a, const PositionIterator& b);
%exception Xapian::PostingIterator::~PostingIterator;
%exception Xapian::PostingIterator::PostingIterator();
%exception Xapian::PostingIterator::positionlist_end() const;
%exception Xapian::PostingIterator::operator==(const PostingIterator& a, const PostingIterator& b);
%exception Xapian::PostingIterator::operator!=(const PostingIterator& a, const PostingIterator& b);
%exception Xapian::PostingSource::~PostingSource;
%exception Xapian::PostingSource::PostingSource();
%exception Xapian::PostingSource::get_maxweight() const;
%exception Xapian::ValuePostingSource::~ValuePostingSource;
%exception Xapian::ValuePostingSource::ValuePostingSource(Xapian::valueno slot_);
%exception Xapian::ValueWeightPostingSource::~ValueWeightPostingSource;
%exception Xapian::DecreasingValueWeightPostingSource::~DecreasingValueWeightPostingSource;
%exception Xapian::ValueMapPostingSource::~ValueMapPostingSource;
%exception Xapian::FixedWeightPostingSource::~FixedWeightPostingSource;
%exception Xapian::Query::~Query;
%exception Xapian::Query::Query();
%exception Xapian::Query::get_terms_end() const;
%exception Xapian::Query::get_unique_terms_end() const;
%exception Xapian::Query::get_length() const;
%exception Xapian::Query::empty() const;
%exception Xapian::Query::get_type() const;
%exception Xapian::Query::get_num_subqueries() const;
%exception Xapian::Query::Internal();
%exception Xapian::Query::get_length() const;
%exception Xapian::Query::get_type() const;
%exception Xapian::Query::get_num_subqueries() const;
%exception Xapian::Stopper::~Stopper;
%exception Xapian::SimpleStopper::~SimpleStopper;
%exception Xapian::RangeProcessor::~RangeProcessor;
%exception Xapian::DateRangeProcessor::~DateRangeProcessor;
%exception Xapian::NumberRangeProcessor::~NumberRangeProcessor;
%exception Xapian::UnitRangeProcessor::~UnitRangeProcessor;
%exception Xapian::FieldProcessor::~FieldProcessor;
%exception Xapian::QueryParser::~QueryParser;
%exception Xapian::QueryParser::stoplist_end() const;
%exception Xapian::QueryParser::unstem_end(std::string_view) const;
%exception Xapian::QueryParser::sortable_serialise_(double value, char* buf);
%exception Xapian::QueryParser::sortable_unserialise(std::string_view serialised);
%exception Xapian::Registry::~Registry;
%exception Xapian::RSet::~RSet;
%exception Xapian::StemImplementation::~StemImplementation;
%exception Xapian::Stem::~Stem;
%exception Xapian::TermGenerator::~TermGenerator;
%exception Xapian::TermIterator::~TermIterator;
%exception Xapian::TermIterator::TermIterator();
%exception Xapian::TermIterator::positionlist_end() const;
%exception Xapian::TermIterator::operator==(const TermIterator& a, const TermIterator& b);
%exception Xapian::TermIterator::operator!=(const TermIterator& a, const TermIterator& b);
%exception Xapian::Utf8Iterator::~Utf8Iterator;
%exception Xapian::Utf8Iterator::calculate_sequence_length() const;
%exception Xapian::Utf8Iterator::Utf8Iterator();
%exception Xapian::Utf8Iterator::operator*() const;
%exception Xapian::Utf8Iterator::strict_deref() const;
%exception Xapian::Utf8Iterator::operator==(const Utf8Iterator& other) const;
%exception Xapian::Utf8Iterator::operator!=(const Utf8Iterator& other) const;
%exception Xapian::Utf8Iterator::get_character_info(unsigned ch);
%exception Xapian::ValueIterator::~ValueIterator;
%exception Xapian::ValueIterator::ValueIterator();
%exception Xapian::ValueIterator::operator==(const ValueIterator& a, const ValueIterator& b);
%exception Xapian::ValueIterator::operator!=(const ValueIterator& a, const ValueIterator& b);
%exception Xapian::ValueSetMatchDecider::~ValueSetMatchDecider;
%exception Xapian::Weight::~Weight;
%exception Xapian::BoolWeight::~BoolWeight;
%exception Xapian::TfIdfWeight::~TfIdfWeight;
%exception Xapian::BM25Weight::~BM25Weight;
%exception Xapian::BM25PlusWeight::~BM25PlusWeight;
%exception Xapian::InL2Weight::~InL2Weight;
%exception Xapian::IfB2Weight::~IfB2Weight;
%exception Xapian::IneB2Weight::~IneB2Weight;
%exception Xapian::BB2Weight::~BB2Weight;
%exception Xapian::DLHWeight::~DLHWeight;
%exception Xapian::PL2Weight::~PL2Weight;
%exception Xapian::PL2PlusWeight::~PL2PlusWeight;
%exception Xapian::DPHWeight::~DPHWeight;
%exception Xapian::LMJMWeight::~LMJMWeight;
%exception Xapian::LMDirichletWeight::~LMDirichletWeight;
%exception Xapian::LMAbsDiscountWeight::~LMAbsDiscountWeight;
%exception Xapian::LM2StageWeight::~LM2StageWeight;
%exception Xapian::CoordWeight::~CoordWeight;
%exception Xapian::DiceCoeffWeight::~DiceCoeffWeight;

%exception {
    try {
	$action
    } catch (...) {
	Xapian::handle_exception(L);
	SWIG_fail;
    }
}
