/** @file
 * @brief Custom Perl exception handling.
 */
/* Warning: This file is generated by ./generate-perl-exceptions
 * - do not modify directly!
 *
 * Copyright (C) 2003,2004,2006,2007,2008,2011,2012,2013 Olly Betts
 * Copyright (C) 2007 Lemur Consulting Ltd
 * Copyright (C) 2007 Richard Boulton
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

namespace Xapian {

%exceptionclass Error;
%exceptionclass LogicError;
%exceptionclass RuntimeError;
%exceptionclass AssertionError;
%exceptionclass InvalidArgumentError;
%exceptionclass InvalidOperationError;
%exceptionclass UnimplementedError;
%exceptionclass DatabaseError;
%exceptionclass DatabaseCorruptError;
%exceptionclass DatabaseCreateError;
%exceptionclass DatabaseLockError;
%exceptionclass DatabaseModifiedError;
%exceptionclass DatabaseOpeningError;
%exceptionclass DatabaseVersionError;
%exceptionclass DocNotFoundError;
%exceptionclass FeatureUnavailableError;
%exceptionclass InternalError;
%exceptionclass NetworkError;
%exceptionclass NetworkTimeoutError;
%exceptionclass QueryParserError;
%exceptionclass SerialisationError;
%exceptionclass RangeError;
%exceptionclass WildcardError;
%exceptionclass DatabaseNotFoundError;
%exceptionclass DatabaseClosedError;
}
%ignore Xapian::Error::Error(const Error&);
%include "xapian/error.h"

%{
namespace Xapian {
void handle_exception() {
    try {
	throw;
    } catch (const Xapian::DatabaseClosedError &e) {
	void * p = (void *) new Xapian::DatabaseClosedError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseClosedError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseClosedError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseClosedError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseNotFoundError &e) {
	void * p = (void *) new Xapian::DatabaseNotFoundError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseNotFoundError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseNotFoundError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseNotFoundError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::WildcardError &e) {
	void * p = (void *) new Xapian::WildcardError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::WildcardError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::WildcardError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::WildcardError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::RangeError &e) {
	void * p = (void *) new Xapian::RangeError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::RangeError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::RangeError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::RangeError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::SerialisationError &e) {
	void * p = (void *) new Xapian::SerialisationError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::SerialisationError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::SerialisationError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::SerialisationError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::QueryParserError &e) {
	void * p = (void *) new Xapian::QueryParserError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::QueryParserError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::QueryParserError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::QueryParserError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::NetworkTimeoutError &e) {
	void * p = (void *) new Xapian::NetworkTimeoutError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::NetworkTimeoutError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::NetworkTimeoutError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::NetworkTimeoutError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::NetworkError &e) {
	void * p = (void *) new Xapian::NetworkError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::NetworkError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::NetworkError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::NetworkError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::InternalError &e) {
	void * p = (void *) new Xapian::InternalError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::InternalError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::InternalError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::InternalError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::FeatureUnavailableError &e) {
	void * p = (void *) new Xapian::FeatureUnavailableError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::FeatureUnavailableError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::FeatureUnavailableError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::FeatureUnavailableError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DocNotFoundError &e) {
	void * p = (void *) new Xapian::DocNotFoundError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DocNotFoundError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DocNotFoundError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DocNotFoundError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseVersionError &e) {
	void * p = (void *) new Xapian::DatabaseVersionError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseVersionError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseVersionError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseVersionError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseOpeningError &e) {
	void * p = (void *) new Xapian::DatabaseOpeningError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseOpeningError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseOpeningError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseOpeningError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseModifiedError &e) {
	void * p = (void *) new Xapian::DatabaseModifiedError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseModifiedError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseModifiedError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseModifiedError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseLockError &e) {
	void * p = (void *) new Xapian::DatabaseLockError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseLockError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseLockError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseLockError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseCreateError &e) {
	void * p = (void *) new Xapian::DatabaseCreateError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseCreateError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseCreateError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseCreateError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseCorruptError &e) {
	void * p = (void *) new Xapian::DatabaseCorruptError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseCorruptError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseCorruptError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseCorruptError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::DatabaseError &e) {
	void * p = (void *) new Xapian::DatabaseError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::DatabaseError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::DatabaseError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::DatabaseError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::UnimplementedError &e) {
	void * p = (void *) new Xapian::UnimplementedError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::UnimplementedError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::UnimplementedError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::UnimplementedError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::InvalidOperationError &e) {
	void * p = (void *) new Xapian::InvalidOperationError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::InvalidOperationError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::InvalidOperationError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::InvalidOperationError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::InvalidArgumentError &e) {
	void * p = (void *) new Xapian::InvalidArgumentError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::InvalidArgumentError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::InvalidArgumentError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::InvalidArgumentError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::AssertionError &e) {
	void * p = (void *) new Xapian::AssertionError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::AssertionError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::AssertionError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::AssertionError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::RuntimeError &e) {
	void * p = (void *) new Xapian::RuntimeError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::RuntimeError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::RuntimeError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::RuntimeError", p);
	croak(Nullch);
#endif
    } catch (const Xapian::LogicError &e) {
	void * p = (void *) new Xapian::LogicError(e);
#ifdef croak_sv
	SV * sv = sv_newmortal();
	sv_setref_pv(sv, "Xapian::LogicError", p);
	croak_sv(sv);
#elif defined ERRSV
	sv_setref_pv(ERRSV, "Xapian::LogicError", p);
	croak(Nullch);
#else
	sv_setref_pv(get_sv("@", TRUE), "Xapian::LogicError", p);
	croak(Nullch);
#endif
    } catch (const std::exception& e) {
	croak("std::exception: %s", e.what());
    } catch (...) {
	croak("something terrible happened");
    }
}
}
%}

/* Functions and methods which are marked as "nothrow": */
%exception Xapian::StemStopper::~StemStopper;
%exception Xapian::DocumentSet::~DocumentSet;
%exception Xapian::FreqSource::~FreqSource;
%exception Xapian::TermListGroup::~TermListGroup;
%exception Xapian::PointType::~PointType;
%exception Xapian::PointType::termlist_end() const;
%exception Xapian::Point::~Point;
%exception Xapian::Centroid::~Centroid;
%exception Xapian::Cluster::~Cluster;
%exception Xapian::ClusterSet::~ClusterSet;
%exception Xapian::Similarity::~Similarity;
%exception Xapian::CosineDistance::~CosineDistance;
%exception Xapian::Clusterer::~Clusterer;
%exception Xapian::KMeans::~KMeans;
%exception Xapian::LCDClusterer::~LCDClusterer;
%exception Xapian::Compactor::~Compactor;
%exception Xapian::get_constinfo_();
%exception Xapian::Database::~Database;
%exception Xapian::Database::postlist_end(std::string_view) const;
%exception Xapian::Database::termlist_end(Xapian::docid) const;
%exception Xapian::Database::positionlist_end(Xapian::docid, std::string_view) const;
%exception Xapian::Database::allterms_end(std::string_view = {}) const;
%exception Xapian::Database::valuestream_end(Xapian::valueno) const;
%exception Xapian::Database::spellings_end() const;
%exception Xapian::Database::synonyms_end(std::string_view) const;
%exception Xapian::Database::synonym_keys_end(std::string_view = {}) const;
%exception Xapian::Database::metadata_keys_end(std::string_view = {}) const;
%exception Xapian::WritableDatabase::~WritableDatabase;
%exception Xapian::Document::~Document;
%exception Xapian::Document::termlist_end() const;
%exception Xapian::Document::values_end() const;
%exception Xapian::Enquire::~Enquire;
%exception Xapian::Enquire::get_matching_terms_end(docid) const;
%exception Xapian::Enquire::get_matching_terms_end(const MSetIterator&) const;
%exception Xapian::Error::~Error;
%exception Xapian::Error::get_type() const;
%exception Xapian::Error::get_msg() const;
%exception Xapian::Error::get_context() const;
%exception Xapian::LogicError::~LogicError;
%exception Xapian::RuntimeError::~RuntimeError;
%exception Xapian::AssertionError::~AssertionError;
%exception Xapian::InvalidArgumentError::~InvalidArgumentError;
%exception Xapian::InvalidOperationError::~InvalidOperationError;
%exception Xapian::UnimplementedError::~UnimplementedError;
%exception Xapian::DatabaseError::~DatabaseError;
%exception Xapian::DatabaseCorruptError::~DatabaseCorruptError;
%exception Xapian::DatabaseCreateError::~DatabaseCreateError;
%exception Xapian::DatabaseLockError::~DatabaseLockError;
%exception Xapian::DatabaseModifiedError::~DatabaseModifiedError;
%exception Xapian::DatabaseOpeningError::~DatabaseOpeningError;
%exception Xapian::DatabaseVersionError::~DatabaseVersionError;
%exception Xapian::DocNotFoundError::~DocNotFoundError;
%exception Xapian::FeatureUnavailableError::~FeatureUnavailableError;
%exception Xapian::InternalError::~InternalError;
%exception Xapian::NetworkError::~NetworkError;
%exception Xapian::NetworkTimeoutError::~NetworkTimeoutError;
%exception Xapian::QueryParserError::~QueryParserError;
%exception Xapian::SerialisationError::~SerialisationError;
%exception Xapian::RangeError::~RangeError;
%exception Xapian::WildcardError::~WildcardError;
%exception Xapian::DatabaseNotFoundError::~DatabaseNotFoundError;
%exception Xapian::DatabaseClosedError::~DatabaseClosedError;
%exception Xapian::ESet::~ESet;
%exception Xapian::ESetIterator::~ESetIterator;
%exception Xapian::ESetIterator::operator==(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ESetIterator::operator!=(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ESetIterator::operator<(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ESetIterator::operator>(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ESetIterator::operator>=(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ESetIterator::operator<=(const ESetIterator& a, const ESetIterator& b);
%exception Xapian::ExpandDecider::~ExpandDecider;
%exception Xapian::ExpandDeciderAnd::~ExpandDeciderAnd;
%exception Xapian::ExpandDeciderFilterTerms::~ExpandDeciderFilterTerms;
%exception Xapian::ExpandDeciderFilterPrefix::~ExpandDeciderFilterPrefix;
%exception Xapian::miles_to_metres(double miles);
%exception Xapian::miles_to_metres(double miles);
%exception Xapian::metres_to_miles(double metres);
%exception Xapian::metres_to_miles(double metres);
%exception Xapian::LatLongCoord::~LatLongCoord;
%exception Xapian::LatLongCoord::LatLongCoord();
%exception Xapian::LatLongCoord::operator<(const LatLongCoord& other) const;
%exception Xapian::LatLongCoordsIterator::~LatLongCoordsIterator;
%exception Xapian::LatLongCoords::~LatLongCoords;
%exception Xapian::LatLongMetric::~LatLongMetric;
%exception Xapian::GreatCircleMetric::~GreatCircleMetric;
%exception Xapian::LatLongDistancePostingSource::~LatLongDistancePostingSource;
%exception Xapian::LatLongDistanceKeyMaker::~LatLongDistanceKeyMaker;
%exception Xapian::opt_intrusive_base::~opt_intrusive_base;
%exception Xapian::KeyMaker::~KeyMaker;
%exception Xapian::MultiValueKeyMaker::~MultiValueKeyMaker;
%exception Xapian::MatchDecider::~MatchDecider;
%exception Xapian::MatchDecider::MatchDecider();
%exception Xapian::MatchSpy::~MatchSpy;
%exception Xapian::MatchSpy::MatchSpy();
%exception Xapian::ValueCountMatchSpy::~ValueCountMatchSpy;
%exception Xapian::ValueCountMatchSpy::get_total() const;
%exception Xapian::ValueCountMatchSpy::values_end() const;
%exception Xapian::ValueCountMatchSpy::top_values_end(size_t) const;
%exception Xapian::MSet::~MSet;
%exception Xapian::MSetIterator::~MSetIterator;
%exception Xapian::MSetIterator::operator==(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::MSetIterator::operator!=(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::MSetIterator::operator<(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::MSetIterator::operator>(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::MSetIterator::operator>=(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::MSetIterator::operator<=(const MSetIterator& a, const MSetIterator& b);
%exception Xapian::PositionIterator::~PositionIterator;
%exception Xapian::PositionIterator::PositionIterator();
%exception Xapian::PositionIterator::operator==(const PositionIterator& a, const PositionIterator& b);
%exception Xapian::PositionIterator::operator!=(const PositionIterator& a, const PositionIterator& b);
%exception Xapian::PostingIterator::~PostingIterator;
%exception Xapian::PostingIterator::PostingIterator();
%exception Xapian::PostingIterator::positionlist_end() const;
%exception Xapian::PostingIterator::operator==(const PostingIterator& a, const PostingIterator& b);
%exception Xapian::PostingIterator::operator!=(const PostingIterator& a, const PostingIterator& b);
%exception Xapian::PostingSource::~PostingSource;
%exception Xapian::PostingSource::PostingSource();
%exception Xapian::PostingSource::get_maxweight() const;
%exception Xapian::ValuePostingSource::~ValuePostingSource;
%exception Xapian::ValuePostingSource::ValuePostingSource(Xapian::valueno slot_);
%exception Xapian::ValueWeightPostingSource::~ValueWeightPostingSource;
%exception Xapian::DecreasingValueWeightPostingSource::~DecreasingValueWeightPostingSource;
%exception Xapian::ValueMapPostingSource::~ValueMapPostingSource;
%exception Xapian::FixedWeightPostingSource::~FixedWeightPostingSource;
%exception Xapian::Query::~Query;
%exception Xapian::Query::Query();
%exception Xapian::Query::get_terms_end() const;
%exception Xapian::Query::get_unique_terms_end() const;
%exception Xapian::Query::get_length() const;
%exception Xapian::Query::empty() const;
%exception Xapian::Query::get_type() const;
%exception Xapian::Query::get_num_subqueries() const;
%exception Xapian::Query::Internal();
%exception Xapian::Query::get_length() const;
%exception Xapian::Query::get_type() const;
%exception Xapian::Query::get_num_subqueries() const;
%exception Xapian::Stopper::~Stopper;
%exception Xapian::SimpleStopper::~SimpleStopper;
%exception Xapian::RangeProcessor::~RangeProcessor;
%exception Xapian::DateRangeProcessor::~DateRangeProcessor;
%exception Xapian::NumberRangeProcessor::~NumberRangeProcessor;
%exception Xapian::UnitRangeProcessor::~UnitRangeProcessor;
%exception Xapian::FieldProcessor::~FieldProcessor;
%exception Xapian::QueryParser::~QueryParser;
%exception Xapian::QueryParser::stoplist_end() const;
%exception Xapian::QueryParser::unstem_end(std::string_view) const;
%exception Xapian::QueryParser::sortable_serialise_(double value, char* buf);
%exception Xapian::QueryParser::sortable_unserialise(std::string_view serialised);
%exception Xapian::Registry::~Registry;
%exception Xapian::RSet::~RSet;
%exception Xapian::StemImplementation::~StemImplementation;
%exception Xapian::Stem::~Stem;
%exception Xapian::TermGenerator::~TermGenerator;
%exception Xapian::TermIterator::~TermIterator;
%exception Xapian::TermIterator::TermIterator();
%exception Xapian::TermIterator::positionlist_end() const;
%exception Xapian::TermIterator::operator==(const TermIterator& a, const TermIterator& b);
%exception Xapian::TermIterator::operator!=(const TermIterator& a, const TermIterator& b);
%exception Xapian::Utf8Iterator::~Utf8Iterator;
%exception Xapian::Utf8Iterator::calculate_sequence_length() const;
%exception Xapian::Utf8Iterator::Utf8Iterator();
%exception Xapian::Utf8Iterator::operator*() const;
%exception Xapian::Utf8Iterator::strict_deref() const;
%exception Xapian::Utf8Iterator::operator==(const Utf8Iterator& other) const;
%exception Xapian::Utf8Iterator::operator!=(const Utf8Iterator& other) const;
%exception Xapian::Utf8Iterator::get_character_info(unsigned ch);
%exception Xapian::ValueIterator::~ValueIterator;
%exception Xapian::ValueIterator::ValueIterator();
%exception Xapian::ValueIterator::operator==(const ValueIterator& a, const ValueIterator& b);
%exception Xapian::ValueIterator::operator!=(const ValueIterator& a, const ValueIterator& b);
%exception Xapian::ValueSetMatchDecider::~ValueSetMatchDecider;
%exception Xapian::Weight::~Weight;
%exception Xapian::BoolWeight::~BoolWeight;
%exception Xapian::TfIdfWeight::~TfIdfWeight;
%exception Xapian::BM25Weight::~BM25Weight;
%exception Xapian::BM25PlusWeight::~BM25PlusWeight;
%exception Xapian::InL2Weight::~InL2Weight;
%exception Xapian::IfB2Weight::~IfB2Weight;
%exception Xapian::IneB2Weight::~IneB2Weight;
%exception Xapian::BB2Weight::~BB2Weight;
%exception Xapian::DLHWeight::~DLHWeight;
%exception Xapian::PL2Weight::~PL2Weight;
%exception Xapian::PL2PlusWeight::~PL2PlusWeight;
%exception Xapian::DPHWeight::~DPHWeight;
%exception Xapian::LMJMWeight::~LMJMWeight;
%exception Xapian::LMDirichletWeight::~LMDirichletWeight;
%exception Xapian::LMAbsDiscountWeight::~LMAbsDiscountWeight;
%exception Xapian::LM2StageWeight::~LM2StageWeight;
%exception Xapian::CoordWeight::~CoordWeight;
%exception Xapian::DiceCoeffWeight::~DiceCoeffWeight;

%exception {
    try {
	$action
    } catch (...) {
	Xapian::handle_exception();
	SWIG_fail;
    }
}
