/** @file
 *  @brief Map string to language code
 */
/* Warning: This file is generated by ./languages/collate-sbl - do not modify directly! */
/* Copyright (C) 2007,2012,2013,2015,2025 Olly Betts
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef XAPIAN_INCLUDED_SBL_DISPATCH_H
#define XAPIAN_INCLUDED_SBL_DISPATCH_H

enum sbl_code {
    NONE = 0,
    ARABIC = 1,
    ARMENIAN = 2,
    BASQUE = 3,
    CATALAN = 4,
    DANISH = 5,
    DUTCH = 6,
    DUTCH_PORTER = 7,
    EARLYENGLISH = 8,
    ENGLISH = 9,
    ESPERANTO = 10,
    ESTONIAN = 11,
    FINNISH = 12,
    FRENCH = 13,
    GERMAN = 14,
    GREEK = 15,
    HINDI = 16,
    HUNGARIAN = 17,
    INDONESIAN = 18,
    IRISH = 19,
    ITALIAN = 20,
    LITHUANIAN = 21,
    LOVINS = 22,
    NEPALI = 23,
    NORWEGIAN = 24,
    POLISH = 25,
    PORTER = 26,
    PORTUGUESE = 27,
    ROMANIAN = 28,
    RUSSIAN = 29,
    SERBIAN = 30,
    SPANISH = 31,
    SWEDISH = 32,
    TAMIL = 33,
    TURKISH = 34,
    YIDDISH = 35
};

static const unsigned char tab[] = {
    15,

    1,0, (327&255),(327>>8), 1,0, (0&255),(0>>8), (78&255),(78>>8), (174&255),(174>>8), (238&255),(238>>8), (50&255),(50>>8),
    (109&255),(109>>8), (140&255),(140>>8), 1,0, (23&255),(23>>8), 1,0, 1,0, (6&255),(6>>8),

    (1 - 1),
    NONE, 'n','o','n','e',

    (1 - 1),
    DUTCH, 'k','r','a','a','i','j','_','p','o','h','l','m','a','n','n',

    (2 - 1),
    DUTCH_PORTER, 'd','u','t','c','h','_','p','o','r','t','e','r',
    EARLYENGLISH, 'e','a','r','l','y','e','n','g','l','i','s','h',

    (3 - 1),
    ARMENIAN, 'a','r','m','e','n','i','a','n',
    ESTONIAN, 'e','s','t','o','n','i','a','n',
    ROMANIAN, 'r','o','m','a','n','i','a','n',

    (5 - 1),
    DUTCH, 'd','u','t','c','h',
    GREEK, 'g','r','e','e','k',
    HINDI, 'h','i','n','d','i',
    IRISH, 'i','r','i','s','h',
    TAMIL, 't','a','m','i','l',

    (3 - 1),
    ESPERANTO, 'e','s','p','e','r','a','n','t','o',
    HUNGARIAN, 'h','u','n','g','a','r','i','a','n',
    NORWEGIAN, 'n','o','r','w','e','g','i','a','n',

    (3 - 1),
    INDONESIAN, 'i','n','d','o','n','e','s','i','a','n',
    LITHUANIAN, 'l','i','t','h','u','a','n','i','a','n',
    PORTUGUESE, 'p','o','r','t','u','g','u','e','s','e',

    (9 - 1),
    ARABIC, 'a','r','a','b','i','c',
    BASQUE, 'b','a','s','q','u','e',
    DANISH, 'd','a','n','i','s','h',
    FRENCH, 'f','r','e','n','c','h',
    GERMAN, 'g','e','r','m','a','n',
    LOVINS, 'l','o','v','i','n','s',
    NEPALI, 'n','e','p','a','l','i',
    POLISH, 'p','o','l','i','s','h',
    PORTER, 'p','o','r','t','e','r',

    (11 - 1),
    CATALAN, 'c','a','t','a','l','a','n',
    ENGLISH, 'e','n','g','l','i','s','h',
    FINNISH, 'f','i','n','n','i','s','h',
    GERMAN, 'g','e','r','m','a','n','2',
    ITALIAN, 'i','t','a','l','i','a','n',
    RUSSIAN, 'r','u','s','s','i','a','n',
    SERBIAN, 's','e','r','b','i','a','n',
    SPANISH, 's','p','a','n','i','s','h',
    SWEDISH, 's','w','e','d','i','s','h',
    TURKISH, 't','u','r','k','i','s','h',
    YIDDISH, 'y','i','d','d','i','s','h',

    (33 - 1),
    ARABIC, 'a','r',
    CATALAN, 'c','a',
    DANISH, 'd','a',
    GERMAN, 'd','e',
    GREEK, 'e','l',
    ENGLISH, 'e','n',
    ESPERANTO, 'e','o',
    SPANISH, 'e','s',
    ESTONIAN, 'e','t',
    BASQUE, 'e','u',
    FINNISH, 'f','i',
    FRENCH, 'f','r',
    IRISH, 'g','a',
    HINDI, 'h','i',
    HUNGARIAN, 'h','u',
    ARMENIAN, 'h','y',
    INDONESIAN, 'i','d',
    ITALIAN, 'i','t',
    LITHUANIAN, 'l','t',
    NORWEGIAN, 'n','b',
    NEPALI, 'n','e',
    DUTCH, 'n','l',
    NORWEGIAN, 'n','n',
    NORWEGIAN, 'n','o',
    POLISH, 'p','l',
    PORTUGUESE, 'p','t',
    ROMANIAN, 'r','o',
    RUSSIAN, 'r','u',
    SERBIAN, 's','r',
    SWEDISH, 's','v',
    TAMIL, 't','a',
    TURKISH, 't','r',
    YIDDISH, 'y','i'
};

#define SNOWBALL_DISPATCH \
    case ARABIC: internal = new Xapian::Internal::Snowball::Arabic; return; \
    case ARMENIAN: internal = new Xapian::Internal::Snowball::Armenian; return; \
    case BASQUE: internal = new Xapian::Internal::Snowball::Basque; return; \
    case CATALAN: internal = new Xapian::Internal::Snowball::Catalan; return; \
    case DANISH: internal = new Xapian::Internal::Snowball::Danish; return; \
    case DUTCH: internal = new Xapian::Internal::Snowball::Dutch; return; \
    case DUTCH_PORTER: internal = new Xapian::Internal::Snowball::DutchPorter; return; \
    case EARLYENGLISH: internal = new Xapian::Internal::Snowball::Earlyenglish; return; \
    case ENGLISH: internal = new Xapian::Internal::Snowball::English; return; \
    case ESPERANTO: internal = new Xapian::Internal::Snowball::Esperanto; return; \
    case ESTONIAN: internal = new Xapian::Internal::Snowball::Estonian; return; \
    case FINNISH: internal = new Xapian::Internal::Snowball::Finnish; return; \
    case FRENCH: internal = new Xapian::Internal::Snowball::French; return; \
    case GERMAN: internal = new Xapian::Internal::Snowball::German; return; \
    case GREEK: internal = new Xapian::Internal::Snowball::Greek; return; \
    case HINDI: internal = new Xapian::Internal::Snowball::Hindi; return; \
    case HUNGARIAN: internal = new Xapian::Internal::Snowball::Hungarian; return; \
    case INDONESIAN: internal = new Xapian::Internal::Snowball::Indonesian; return; \
    case IRISH: internal = new Xapian::Internal::Snowball::Irish; return; \
    case ITALIAN: internal = new Xapian::Internal::Snowball::Italian; return; \
    case LITHUANIAN: internal = new Xapian::Internal::Snowball::Lithuanian; return; \
    case LOVINS: internal = new Xapian::Internal::Snowball::Lovins; return; \
    case NEPALI: internal = new Xapian::Internal::Snowball::Nepali; return; \
    case NORWEGIAN: internal = new Xapian::Internal::Snowball::Norwegian; return; \
    case POLISH: internal = new Xapian::Internal::Snowball::Polish; return; \
    case PORTER: internal = new Xapian::Internal::Snowball::Porter; return; \
    case PORTUGUESE: internal = new Xapian::Internal::Snowball::Portuguese; return; \
    case ROMANIAN: internal = new Xapian::Internal::Snowball::Romanian; return; \
    case RUSSIAN: internal = new Xapian::Internal::Snowball::Russian; return; \
    case SERBIAN: internal = new Xapian::Internal::Snowball::Serbian; return; \
    case SPANISH: internal = new Xapian::Internal::Snowball::Spanish; return; \
    case SWEDISH: internal = new Xapian::Internal::Snowball::Swedish; return; \
    case TAMIL: internal = new Xapian::Internal::Snowball::Tamil; return; \
    case TURKISH: internal = new Xapian::Internal::Snowball::Turkish; return; \
    case YIDDISH: internal = new Xapian::Internal::Snowball::Yiddish; return; \
    case NONE: return;

#define LANGSTRING "arabic armenian basque catalan danish dutch dutch_porter earlyenglish english esperanto estonian finnish french german greek hindi hungarian indonesian irish italian lithuanian lovins nepali norwegian polish porter portuguese romanian russian serbian spanish swedish tamil turkish yiddish"

#endif
