
// File: index.xml

// File: classXapian_1_1AssertionError.xml
%feature("docstring") Xapian::AssertionError "

AssertionError is thrown if a logical assertion inside Xapian fails.

In a debug build of Xapian, a failed assertion in the core library
code will cause AssertionError to be thrown.

This represents a bug in Xapian (either an invariant, precondition,
etc has been violated, or the assertion is incorrect!) ";

%feature("docstring")  Xapian::AssertionError::AssertionError "

General purpose constructor.

Xapian::AssertionError::AssertionError(std::string_view msg_,
std::string_view context_={}, int errno_=0)
Xapian::AssertionError::AssertionError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")  Xapian::AssertionError::AssertionError "

Construct from message and errno value.

Xapian::AssertionError::AssertionError(std::string_view msg_, int
errno_) Xapian::AssertionError::AssertionError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1BB2Weight.xml
%feature("docstring") Xapian::BB2Weight "

This class implements the BB2 weighting scheme.

BB2 is a representative scheme of the Divergence from Randomness
Framework by Gianni Amati.

It uses the Bose-Einstein probabilistic distribution (B) along with
Stirling's power approximation, the Bernoulli method to find the
aftereffect of sampling (B) and the second wdf normalization proposed
by Amati to normalize the wdf in the document to the length of the
document (H2).

For more information about the DFR Framework and the BB2 scheme,
please refer to : Gianni Amati and Cornelis Joost Van Rijsbergen
Probabilistic models of information retrieval based on measuring the
divergence from randomness ACM Transactions on Information Systems
(TOIS) 20, (4), 2002, pp. 357-389. ";

%feature("docstring")  Xapian::BB2Weight::BB2Weight "

Construct a BB2Weight.

Xapian::BB2Weight::BB2Weight(double c) Xapian::BB2Weight::BB2Weight

Parameters:
-----------

c:  A strictly positive parameter controlling the extent of the
normalization of the wdf to the document length. A default value of 1
is suitable for longer queries but it may need to be changed for
shorter queries. For more information, please refer to Gianni Amati's
PHD thesis titled Probabilistic Models for Information Retrieval based
on Divergence from Randomness. ";

%feature("docstring")  Xapian::BB2Weight::BB2Weight "Xapian::BB2Weight::BB2Weight() Xapian::BB2Weight::BB2Weight";

%feature("docstring")  Xapian::BB2Weight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::BB2Weight::name() const Xapian::BB2Weight::name
\"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::BB2Weight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::BB2Weight::serialise() const
Xapian::BB2Weight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::BB2Weight::unserialise "

Unserialise parameters.

BB2Weight * Xapian::BB2Weight::unserialise(const std::string
&serialised) const Xapian::BB2Weight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::BB2Weight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::BB2Weight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterms,
Xapian::termcount wdfdocmax) const Xapian::BB2Weight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::BB2Weight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::BB2Weight::get_maxpart() const
Xapian::BB2Weight::get_maxpart This information is used by the matcher
to perform various optimisations, so strive to make the bound as tight
as possible. ";

%feature("docstring")  Xapian::BB2Weight::create_from_parameters "

Create from a human-readable parameter string.

BB2Weight * Xapian::BB2Weight::create_from_parameters(const char
*params) const Xapian::BB2Weight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1BM25PlusWeight.xml
%feature("docstring") Xapian::BM25PlusWeight "

Xapian::Weight subclass implementing the BM25+ probabilistic formula.
";

%feature("docstring")  Xapian::BM25PlusWeight::BM25PlusWeight "

Construct a BM25PlusWeight.

Xapian::BM25PlusWeight::BM25PlusWeight(double k1, double k2, double
k3, double b, double min_normlen, double delta)
Xapian::BM25PlusWeight::BM25PlusWeight

Parameters:
-----------

k1:  A non-negative parameter controlling how influential within-
document- frequency (wdf) is. k1=0 means that wdf doesn't affect the
weights. The larger k1 is, the more wdf influences the weights.
(default 1)

k2:  A non-negative parameter which controls the strength of a
correction factor which depends upon query length and normalised
document length. k2=0 disable this factor; larger k2 makes it
stronger. The paper which describes BM25+ ignores BM25's document-
independent component (so implicitly k2=0), but we support non-zero k2
too. (default 0)

k3:  A non-negative parameter controlling how influential within-
query- frequency (wqf) is. k3=0 means that wqf doesn't affect the
weights. The larger k3 is, the more wqf influences the weights.
(default 1)

b:  A parameter between 0 and 1, controlling how strong the document
length normalisation of wdf is. 0 means no normalisation; 1 means full
normalisation. (default 0.5)

min_normlen:  A parameter specifying a minimum value for normalised
document length. Normalised document length values less than this will
be clamped to this value, helping to prevent very short documents
getting large weights. (default 0.5)

delta:  A parameter for pseudo tf value to control the scale of the tf
lower bound. Delta(δ) can be tuned for example from 0.0 to 1.5 but
BM25+ can still work effectively across collections with a fixed δ =
1.0. (default 1.0) ";

%feature("docstring")  Xapian::BM25PlusWeight::BM25PlusWeight "Xapian::BM25PlusWeight::BM25PlusWeight()
Xapian::BM25PlusWeight::BM25PlusWeight";

%feature("docstring")  Xapian::BM25PlusWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::BM25PlusWeight::name() const
Xapian::BM25PlusWeight::name \"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::BM25PlusWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::BM25PlusWeight::serialise() const
Xapian::BM25PlusWeight::serialise If you don't want to support the
remote backend, you can use the default implementation which simply
throws Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::BM25PlusWeight::unserialise "

Unserialise parameters.

BM25PlusWeight * Xapian::BM25PlusWeight::unserialise(const std::string
&serialised) const Xapian::BM25PlusWeight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::BM25PlusWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::BM25PlusWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterms,
Xapian::termcount wdfdocmax) const Xapian::BM25PlusWeight::get_sumpart
The parameters give information about the document which may be used
in the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::BM25PlusWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::BM25PlusWeight::get_maxpart() const
Xapian::BM25PlusWeight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::BM25PlusWeight::get_sumextra "

Calculate the term-independent weight component for a document.

double Xapian::BM25PlusWeight::get_sumextra(Xapian::termcount doclen,
Xapian::termcount uniqterms, Xapian::termcount wdfdocmax) const
Xapian::BM25PlusWeight::get_sumextra The default implementation always
returns 0 (in Xapian < 2.0.0 this was a pure virtual method).

The parameter gives information about the document which may be used
in the calculations:

Parameters:
-----------

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::BM25PlusWeight::get_maxextra "

Return an upper bound on what get_sumextra() can return for any
document.

double Xapian::BM25PlusWeight::get_maxextra() const
Xapian::BM25PlusWeight::get_maxextra The default implementation always
returns 0 (in Xapian < 2.0.0 this was a pure virtual method).

This information is used by the matcher to perform various
optimisations, so strive to make the bound as tight as possible. ";

%feature("docstring")  Xapian::BM25PlusWeight::create_from_parameters
"

Create from a human-readable parameter string.

BM25PlusWeight * Xapian::BM25PlusWeight::create_from_parameters(const
char *params) const Xapian::BM25PlusWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1BM25Weight.xml
%feature("docstring") Xapian::BM25Weight "

Xapian::Weight subclass implementing the BM25 probabilistic formula.
";

%feature("docstring")  Xapian::BM25Weight::BM25Weight "

Construct a BM25Weight.

Xapian::BM25Weight::BM25Weight(double k1, double k2, double k3, double
b, double min_normlen) Xapian::BM25Weight::BM25Weight

Parameters:
-----------

k1:  A non-negative parameter controlling how influential within-
document- frequency (wdf) is. k1=0 means that wdf doesn't affect the
weights. The larger k1 is, the more wdf influences the weights.
(default 1)

k2:  A non-negative parameter which controls the strength of a
correction factor which depends upon query length and normalised
document length. k2=0 disable this factor; larger k2 makes it
stronger. (default 0)

k3:  A non-negative parameter controlling how influential within-
query- frequency (wqf) is. k3=0 means that wqf doesn't affect the
weights. The larger k3 is, the more wqf influences the weights.
(default 1)

b:  A parameter between 0 and 1, controlling how strong the document
length normalisation of wdf is. 0 means no normalisation; 1 means full
normalisation. (default 0.5)

min_normlen:  A parameter specifying a minimum value for normalised
document length. Normalised document length values less than this will
be clamped to this value, helping to prevent very short documents
getting large weights. (default 0.5) ";

%feature("docstring")  Xapian::BM25Weight::BM25Weight "Xapian::BM25Weight::BM25Weight() Xapian::BM25Weight::BM25Weight";

%feature("docstring")  Xapian::BM25Weight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::BM25Weight::name() const Xapian::BM25Weight::name
\"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::BM25Weight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::BM25Weight::serialise() const
Xapian::BM25Weight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::BM25Weight::unserialise "

Unserialise parameters.

BM25Weight * Xapian::BM25Weight::unserialise(const std::string
&serialised) const Xapian::BM25Weight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::BM25Weight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::BM25Weight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterm,
Xapian::termcount wdfdocmax) const Xapian::BM25Weight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::BM25Weight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::BM25Weight::get_maxpart() const
Xapian::BM25Weight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::BM25Weight::get_sumextra "

Calculate the term-independent weight component for a document.

double Xapian::BM25Weight::get_sumextra(Xapian::termcount doclen,
Xapian::termcount uniqterms, Xapian::termcount wdfdocmax) const
Xapian::BM25Weight::get_sumextra The default implementation always
returns 0 (in Xapian < 2.0.0 this was a pure virtual method).

The parameter gives information about the document which may be used
in the calculations:

Parameters:
-----------

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::BM25Weight::get_maxextra "

Return an upper bound on what get_sumextra() can return for any
document.

double Xapian::BM25Weight::get_maxextra() const
Xapian::BM25Weight::get_maxextra The default implementation always
returns 0 (in Xapian < 2.0.0 this was a pure virtual method).

This information is used by the matcher to perform various
optimisations, so strive to make the bound as tight as possible. ";

%feature("docstring")  Xapian::BM25Weight::create_from_parameters "

Create from a human-readable parameter string.

BM25Weight * Xapian::BM25Weight::create_from_parameters(const char
*params) const Xapian::BM25Weight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1BoolWeight.xml
%feature("docstring") Xapian::BoolWeight "

Class implementing a \"boolean\" weighting scheme.

This weighting scheme gives all documents zero weight. ";

%feature("docstring")  Xapian::BoolWeight::BoolWeight "

Construct a BoolWeight.

Xapian::BoolWeight::BoolWeight() Xapian::BoolWeight::BoolWeight";

%feature("docstring")  Xapian::BoolWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::BoolWeight::name() const Xapian::BoolWeight::name
\"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::BoolWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::BoolWeight::serialise() const
Xapian::BoolWeight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::BoolWeight::unserialise "

Unserialise parameters.

BoolWeight * Xapian::BoolWeight::unserialise(const std::string
&serialised) const Xapian::BoolWeight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::BoolWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::BoolWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterms,
Xapian::termcount wdfdocmax) const Xapian::BoolWeight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::BoolWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::BoolWeight::get_maxpart() const
Xapian::BoolWeight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::BoolWeight::create_from_parameters "

Create from a human-readable parameter string.

BoolWeight * Xapian::BoolWeight::create_from_parameters(const char
*params) const Xapian::BoolWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1Centroid.xml
%feature("docstring") Xapian::Centroid "

Class to represent cluster centroids in the vector space. ";

%feature("docstring")  Xapian::Centroid::Centroid "

Default constructor.

Xapian::Centroid::Centroid() Xapian::Centroid::Centroid";

%feature("docstring")  Xapian::Centroid::Centroid "

Constructor with Point argument.

Xapian::Centroid::Centroid(const Point &point)
Xapian::Centroid::Centroid

Parameters:
-----------

point:   Point object to which Centroid object is initialised. The
document vector and the magnitude are made equal ";

%feature("docstring")  Xapian::Centroid::divide "

Divide the weight of terms in the centroid by 'size' and recalculate
the magnitude.

void Xapian::Centroid::divide(double cluster_size)
Xapian::Centroid::divide

Parameters:
-----------

cluster_size:  Value by which Centroid document vector is divided ";

%feature("docstring")  Xapian::Centroid::clear "

Clear the terms and corresponding values of the centroid.

void Xapian::Centroid::clear() Xapian::Centroid::clear";


// File: classXapian_1_1Cluster.xml
%feature("docstring") Xapian::Cluster "

Class to represents a Cluster which contains Points and Centroid of
the Cluster. ";

%feature("docstring")  Xapian::Cluster::Cluster "

Copying is allowed.

Xapian::Cluster::Cluster(const Cluster &other)
Xapian::Cluster::Cluster The internals are reference counted, so
copying is cheap.

Parameters:
-----------

other:  The object to copy. ";

%feature("docstring")  Xapian::Cluster::Cluster "

Move constructor.

Xapian::Cluster::Cluster(Cluster &&other) Xapian::Cluster::Cluster

Parameters:
-----------

other:  The object to move. ";

%feature("docstring")  Xapian::Cluster::Cluster "

Constructor.

Xapian::Cluster::Cluster(const Centroid &centroid)
Xapian::Cluster::Cluster

Parameters:
-----------

centroid:  The centroid of the cluster object is assigned to
'centroid' ";

%feature("docstring")  Xapian::Cluster::Cluster "

Default constructor.

Xapian::Cluster::Cluster() Xapian::Cluster::Cluster";

%feature("docstring")  Xapian::Cluster::~Cluster "

Destructor.

Xapian::Cluster::~Cluster() Xapian::Cluster::~Cluster";

%feature("docstring")  Xapian::Cluster::size "

Return size of the cluster.

Xapian::doccount Xapian::Cluster::size() const Xapian::Cluster::size";

%feature("docstring")  Xapian::Cluster::add_point "

Add a document to the Cluster.

void Xapian::Cluster::add_point(const Point &point)
Xapian::Cluster::add_point

Parameters:
-----------

point:  The Point object representing the document which needs to be
added to the cluster ";

%feature("docstring")  Xapian::Cluster::clear "

Clear the cluster weights.

void Xapian::Cluster::clear() Xapian::Cluster::clear";

%feature("docstring")  Xapian::Cluster::get_documents "

Return the documents that are contained within the cluster.

DocumentSet Xapian::Cluster::get_documents() const
Xapian::Cluster::get_documents";

%feature("docstring")  Xapian::Cluster::get_centroid "

Return the current centroid of the cluster.

const Centroid & Xapian::Cluster::get_centroid() const
Xapian::Cluster::get_centroid";

%feature("docstring")  Xapian::Cluster::set_centroid "

Set the centroid of the Cluster to 'centroid'.

void Xapian::Cluster::set_centroid(const Centroid &centroid)
Xapian::Cluster::set_centroid

Parameters:
-----------

centroid:   Centroid object for the Cluster ";

%feature("docstring")  Xapian::Cluster::recalculate "

Recalculate the centroid of the Cluster after each iteration of the
KMeans algorithm by taking the mean of all document vectors (Points)
that belong to the Cluster.

void Xapian::Cluster::recalculate() Xapian::Cluster::recalculate";


// File: classXapian_1_1Clusterer.xml
%feature("docstring") Xapian::Clusterer "

Class representing an abstract class for a clusterer to be
implemented. ";

%feature("docstring")  Xapian::Clusterer::~Clusterer "

Destructor.

virtual Xapian::Clusterer::~Clusterer()
Xapian::Clusterer::~Clusterer";

%feature("docstring")  Xapian::Clusterer::cluster "

Implement the required clustering algorithm in the subclass and and
return clustered output as ClusterSet.

virtual ClusterSet Xapian::Clusterer::cluster(const MSet &mset)=0
Xapian::Clusterer::cluster

Parameters:
-----------

mset:  The MSet object which contains the documents to be clustered ";

%feature("docstring")  Xapian::Clusterer::get_description "

Returns a string describing the clusterer being used.

virtual std::string Xapian::Clusterer::get_description() const =0
Xapian::Clusterer::get_description";

%feature("docstring")  Xapian::Clusterer::release "

Start reference counting this object.

Clusterer * Xapian::Clusterer::release() Xapian::Clusterer::release
You can transfer ownership of a dynamically allocated Clusterer object
to Xapian by calling release() and then passing the object to a Xapian
method. Xapian will arrange to delete the object once it is no longer
required. ";

%feature("docstring")  Xapian::Clusterer::release "

Start reference counting this object.

const Clusterer * Xapian::Clusterer::release() const
Xapian::Clusterer::release You can transfer ownership of a dynamically
allocated Clusterer object to Xapian by calling release() and then
passing the object to a Xapian method. Xapian will arrange to delete
the object once it is no longer required. ";


// File: classXapian_1_1ClusterSet.xml
%feature("docstring") Xapian::ClusterSet "

Class for storing the results returned by the Clusterer. ";

%feature("docstring")  Xapian::ClusterSet::ClusterSet "

Copying is allowed.

Xapian::ClusterSet::ClusterSet(const ClusterSet &other)
Xapian::ClusterSet::ClusterSet The internals are reference counted, so
copying is cheap.

Parameters:
-----------

other:  The object to copy. ";

%feature("docstring")  Xapian::ClusterSet::ClusterSet "

Move constructor.

Xapian::ClusterSet::ClusterSet(ClusterSet &&other)
Xapian::ClusterSet::ClusterSet

Parameters:
-----------

other:  The object to move. ";

%feature("docstring")  Xapian::ClusterSet::ClusterSet "

Default constructor.

Xapian::ClusterSet::ClusterSet() Xapian::ClusterSet::ClusterSet";

%feature("docstring")  Xapian::ClusterSet::~ClusterSet "

Destructor.

Xapian::ClusterSet::~ClusterSet() Xapian::ClusterSet::~ClusterSet";

%feature("docstring")  Xapian::ClusterSet::add_cluster "

Add a cluster to the ClusterSet.

void Xapian::ClusterSet::add_cluster(const Cluster &cluster)
Xapian::ClusterSet::add_cluster

Parameters:
-----------

cluster:   Cluster object which is to be added to the ClusterSet ";

%feature("docstring")  Xapian::ClusterSet::add_to_cluster "

Add the point to the cluster at position 'index'.

void Xapian::ClusterSet::add_to_cluster(const Point &point, unsigned
int index) Xapian::ClusterSet::add_to_cluster

Parameters:
-----------

point:   Point object which needs to be added to a Cluster within the
ClusterSet

index:  Index of the Cluster within the ClusterSet to which the Point
is to be added ";

%feature("docstring")  Xapian::ClusterSet::size "

Return the number of clusters.

Xapian::doccount Xapian::ClusterSet::size() const
Xapian::ClusterSet::size";

%feature("docstring")  Xapian::ClusterSet::clear_clusters "

Clear all the clusters in the ClusterSet.

void Xapian::ClusterSet::clear_clusters()
Xapian::ClusterSet::clear_clusters";

%feature("docstring")  Xapian::ClusterSet::recalculate_centroids "

Recalculate the centroid for all the clusters in the ClusterSet.

void Xapian::ClusterSet::recalculate_centroids()
Xapian::ClusterSet::recalculate_centroids";


// File: classXapian_1_1Compactor.xml
%feature("docstring") Xapian::Compactor "

Compact a database, or merge and compact several. ";

%feature("docstring")  Xapian::Compactor::Compactor "Xapian::Compactor::Compactor() Xapian::Compactor::Compactor";

%feature("docstring")  Xapian::Compactor::~Compactor "virtual
Xapian::Compactor::~Compactor() Xapian::Compactor::~Compactor";

%feature("docstring")  Xapian::Compactor::set_status "

Update progress.

virtual void Xapian::Compactor::set_status(const std::string &table,
const std::string &status) Xapian::Compactor::set_status Subclass this
method if you want to get progress updates during compaction. This is
called for each table first with empty status, And then one or more
times with non-empty status.

The default implementation does nothing.

Parameters:
-----------

table:  The table currently being compacted.

status:  A status message. ";

%feature("docstring")  Xapian::Compactor::resolve_duplicate_metadata "

Resolve multiple user metadata entries with the same key.

virtual std::string
Xapian::Compactor::resolve_duplicate_metadata(const std::string &key,
size_t num_tags, const std::string tags[])
Xapian::Compactor::resolve_duplicate_metadata When merging, if the
same user metadata key is set in more than one input, then this method
is called to allow this to be resolving in an appropriate way.

The default implementation just returns tags[0].

For multipass this will currently get called multiple times for the
same key if there are duplicates to resolve in each pass, but this may
change in the future.

Since 1.4.6, an implementation of this method can return an empty
string to indicate that the appropriate result is to not set a value
for this user metadata key in the output database. In older versions,
you should not return an empty string.

Parameters:
-----------

key:  The metadata key with duplicate entries.

num_tags:  How many tags there are.

tags:  An array of num_tags strings containing the tags to merge. ";


// File: structXapian_1_1Internal_1_1constinfo.xml


// File: classXapian_1_1CoordWeight.xml
%feature("docstring") Xapian::CoordWeight "

Xapian::Weight subclass implementing Coordinate Matching.

Each matching term scores one point. See Managing Gigabytes, Second
Edition p181. ";

%feature("docstring")  Xapian::CoordWeight::clone "

Clone this object.

CoordWeight * Xapian::CoordWeight::clone() const
Xapian::CoordWeight::clone This method allocates and returns a copy of
the object it is called on.

If your subclass is called FooWeight and has parameters a and b, then
you would implement FooWeight::clone() like so:

FooWeight * FooWeight::clone() const { return new FooWeight(a, b); }

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1 ";

%feature("docstring")  Xapian::CoordWeight::init "

Allow the subclass to perform any initialisation it needs to.

void Xapian::CoordWeight::init(double factor_)
Xapian::CoordWeight::init

Parameters:
-----------

factor:  Any scaling factor (e.g. from OP_SCALE_WEIGHT). If the Weight
object is for the term-independent weight supplied by
get_sumextra()/get_maxextra(), then init(0.0) is called (starting from
Xapian 1.2.11 and 1.3.1 - earlier versions failed to call init() for
such Weight objects). ";

%feature("docstring")  Xapian::CoordWeight::CoordWeight "

Construct a CoordWeight.

Xapian::CoordWeight::CoordWeight() Xapian::CoordWeight::CoordWeight";

%feature("docstring")  Xapian::CoordWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::CoordWeight::name() const
Xapian::CoordWeight::name \"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::CoordWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::CoordWeight::serialise() const
Xapian::CoordWeight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::CoordWeight::unserialise "

Unserialise parameters.

CoordWeight * Xapian::CoordWeight::unserialise(const std::string
&serialised) const Xapian::CoordWeight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::CoordWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::CoordWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterms,
Xapian::termcount wdfdocmax) const Xapian::CoordWeight::get_sumpart
The parameters give information about the document which may be used
in the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::CoordWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::CoordWeight::get_maxpart() const
Xapian::CoordWeight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::CoordWeight::create_from_parameters "

Create from a human-readable parameter string.

CoordWeight * Xapian::CoordWeight::create_from_parameters(const char
*params) const Xapian::CoordWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1CosineDistance.xml
%feature("docstring") Xapian::CosineDistance "

Class for calculating the cosine distance between two documents. ";

%feature("docstring")  Xapian::CosineDistance::similarity "

Calculates and returns the cosine similarity using the formula
cos(theta) = a.b/(|a|*|b|).

double Xapian::CosineDistance::similarity(const PointType &a, const
PointType &b) const override Xapian::CosineDistance::similarity";

%feature("docstring")  Xapian::CosineDistance::get_description "

Return a string describing this object.

std::string Xapian::CosineDistance::get_description() const override
Xapian::CosineDistance::get_description";


// File: classXapian_1_1Database.xml
%feature("docstring") Xapian::Database "

An indexed database of documents.

A Database object contains zero or more shards, and operations are
performed across these shards.

To perform a search on a Database, you need to use an Enquire object.

2.0.0 This class is a reference counted handle like many other Xapian
API classes. In earlier versions, it worked like a typedef to
std::vector<database_shard>. The key difference is that previously
copying or assigning a Xapian::Database made a deep copy, whereas now
it makes a shallow copy.  Most methods can throw:

Parameters:
-----------

Xapian::DatabaseCorruptError:  if database corruption is detected

Xapian::DatabaseError:  in various situation (for example, if there's
an I/O error).

Xapian::DatabaseModifiedError:  if the revision being read has been
discarded

Xapian::DatabaseClosedError:  may be thrown by some methods after
after  close() has been called

Xapian::NetworkError:  when remote databases are in use ";

%feature("docstring")  Xapian::Database::add_database "

Add shards from another Database.

void Xapian::Database::add_database(const Database &other)
Xapian::Database::add_database Any shards in other are appended to the
list of shards in this object. The shards are reference counted and
also remain in other.

Parameters:
-----------

other:  Another Database to add shards from

Parameters:
-----------

Xapian::InvalidArgumentError:  if other is the same object as this. ";

%feature("docstring")  Xapian::Database::size "

Return number of shards in this Database object.

size_t Xapian::Database::size() const Xapian::Database::size If you
want the number of documents, see @ get_doccount().

Xapian 1.4.12 ";

%feature("docstring")  Xapian::Database::Database "

Construct a Database containing no shards.

Xapian::Database::Database() Xapian::Database::Database You can then
add shards by calling add_database(). A Database containing no shards
can also be useful in situations where you need an empty database. ";

%feature("docstring")  Xapian::Database::Database "

Open a Database.

Xapian::Database::Database(std::string_view path, int flags=0)
Xapian::Database::Database

Parameters:
-----------

path:  Filing system path to open database from

flags:  Bitwise-or of Xapian::DB_* constants

The path can be a file (for a stub database or a single-file glass
database) or a directory (for a standard glass database). If flags
includes DB_BACKEND_INMEMORY then path is ignored.

Parameters:
-----------

Xapian::DatabaseOpeningError:  if the specified database cannot be
opened

Xapian::DatabaseVersionError:  if the specified database has a format
too old or too new to be supported. ";

%feature("docstring")  Xapian::Database::Database "

Open a single-file Database.

Xapian::Database::Database(int fd, int flags=0)
Xapian::Database::Database This method opens a single-file Database
given a file descriptor open on it. Xapian looks starting at the
current file offset, allowing a single file database to be easily
embedded within another file.

Parameters:
-----------

fd:  File descriptor for the file. Xapian takes ownership of this and
will close it when the database is closed.

flags:  Bitwise-or of Xapian::DB_* constants.

Parameters:
-----------

Xapian::DatabaseOpeningError:  if the specified database cannot be
opened

Xapian::DatabaseVersionError:  if the specified database has a format
too old or too new to be supported. ";

%feature("docstring")  Xapian::Database::~Database "

Destructor.

virtual Xapian::Database::~Database() Xapian::Database::~Database";

%feature("docstring")  Xapian::Database::Database "

Copy constructor.

Xapian::Database::Database(const Database &o)
Xapian::Database::Database The internals are reference counted, so
copying is cheap. ";

%feature("docstring")  Xapian::Database::Database "

Move constructor.

Xapian::Database::Database(Database &&o) Xapian::Database::Database";

%feature("docstring")  Xapian::Database::reopen "

Reopen the database at the latest available revision.

bool Xapian::Database::reopen() Xapian::Database::reopen  Xapian
databases (at least with most backends) support versioning such that a
Database object uses a snapshot of the database. However, write
operations may cause this snapshot to be discarded, which can cause
Xapian::DatabaseModifiedError to be thrown. You can recover from this
situation by calling reopen() and restarting the search operation.

All shards are updated to the latest available revision. This should
be a cheap operation if they're already at the latest revision, so if
you're using the same Database object for many searches it's
reasonable to call reopen() before each search.

true if one or more shards have moved to a newer revision (if false is
returned then it's definitely the case that no shards were reopened,
which applications may find useful when caching results, etc). In
Xapian < 1.3.0, this method did not return a value.

Parameters:
-----------

Xapian::DatabaseError:  is thrown if close() has been called on any of
the shards. ";

%feature("docstring")  Xapian::Database::close "

Close the database.

void Xapian::Database::close() Xapian::Database::close This closes the
database and closes all its file handles.

For a WritableDatabase, if a transaction is active it will be aborted,
while if no transaction is active commit() will be implicitly called.
Also the write lock is released.

Calling close() on an object cannot be undone - in particular, a
subsequent call to reopen() on the same object will not reopen it, but
will instead throw a Xapian::DatabaseClosedError exception.

Calling close() again on an object which has already been closed has
no effect (and doesn't raise an exception).

After close() has been called, calls to other methods of the database,
and to methods of other objects associated with the database, will
either:

behave exactly as they would have done if the database had not been
closed (this can only happen if all the required data is cached)

raise a Xapian::DatabaseClosedError exception.

The reason for this behaviour is that otherwise we'd have to check
that the database is still open on every method call on every object
associated with a Database, when in many cases they are working on
data which has already been loaded and so they are able to just behave
correctly.

This method was added in Xapian 1.1.0. ";

%feature("docstring")  Xapian::Database::get_description "

Return a string describing this object.

virtual std::string Xapian::Database::get_description() const
Xapian::Database::get_description";

%feature("docstring")  Xapian::Database::postlist_begin "

Start iterating the postings of a term.

PostingIterator Xapian::Database::postlist_begin(std::string_view
term) const Xapian::Database::postlist_begin

Parameters:
-----------

term:  The term to iterate the postings of. An empty string acts as a
special pseudo-term which indexes all the documents in the database
with a wdf of 1. ";

%feature("docstring")  Xapian::Database::postlist_end "

End iterator corresponding to postlist_begin().

PostingIterator Xapian::Database::postlist_end(std::string_view) const
noexcept Xapian::Database::postlist_end";

%feature("docstring")  Xapian::Database::termlist_begin "

Start iterating the terms in a document.

TermIterator Xapian::Database::termlist_begin(Xapian::docid did) const
Xapian::Database::termlist_begin

Parameters:
-----------

did:  The document id to iterate terms from

The terms are returned in ascending string order (by byte value). ";

%feature("docstring")  Xapian::Database::termlist_end "

End iterator corresponding to termlist_begin().

TermIterator Xapian::Database::termlist_end(Xapian::docid) const
noexcept Xapian::Database::termlist_end";

%feature("docstring")  Xapian::Database::has_positions "

Does this database have any positional information?

bool Xapian::Database::has_positions() const
Xapian::Database::has_positions";

%feature("docstring")  Xapian::Database::positionlist_begin "

Start iterating positions for a term in a document.

PositionIterator Xapian::Database::positionlist_begin(Xapian::docid
did, std::string_view term) const Xapian::Database::positionlist_begin

Parameters:
-----------

did:  The document id of the document

term:  The term

1.1.0 If the specified document doesn't exist or the specified term
doesn't exist in the specified document, then a valid iterator is
still returned, but it will be equal to positionlist_end(). ";

%feature("docstring")  Xapian::Database::positionlist_end "

End iterator corresponding to positionlist_begin().

PositionIterator Xapian::Database::positionlist_end(Xapian::docid,
std::string_view) const noexcept Xapian::Database::positionlist_end";

%feature("docstring")  Xapian::Database::allterms_begin "

Start iterating all terms in the database with a given prefix.

TermIterator Xapian::Database::allterms_begin(std::string_view
prefix={}) const Xapian::Database::allterms_begin The terms are
returned in ascending string order (by byte value).

Parameters:
-----------

prefix:  The prefix to restrict the returned terms to (default:
iterate all terms) ";

%feature("docstring")  Xapian::Database::allterms_end "

End iterator corresponding to allterms_begin(prefix).

TermIterator Xapian::Database::allterms_end(std::string_view={}) const
noexcept Xapian::Database::allterms_end";

%feature("docstring")  Xapian::Database::get_doccount "

Get the number of documents in the database.

Xapian::doccount Xapian::Database::get_doccount() const
Xapian::Database::get_doccount";

%feature("docstring")  Xapian::Database::get_lastdocid "

Get the highest document id which has been used in the database.

Xapian::docid Xapian::Database::get_lastdocid() const
Xapian::Database::get_lastdocid";

%feature("docstring")  Xapian::Database::get_average_length "

Get the mean document length in the database.

double Xapian::Database::get_average_length() const
Xapian::Database::get_average_length";

%feature("docstring")  Xapian::Database::get_avlength "

Old name for get_average_length() for backward compatibility.

double Xapian::Database::get_avlength() const
Xapian::Database::get_avlength";

%feature("docstring")  Xapian::Database::get_total_length "

Get the total length of all the documents in the database.

Xapian::totallength Xapian::Database::get_total_length() const
Xapian::Database::get_total_length

Added in Xapian 1.4.5. ";

%feature("docstring")  Xapian::Database::get_termfreq "

Get the number of documents indexed by a specified term.

Xapian::doccount Xapian::Database::get_termfreq(std::string_view term)
const Xapian::Database::get_termfreq

Parameters:
-----------

term:  The term to get the frequency of. An empty string acts as a
special pseudo-term which indexes all the documents in the database,
so returns get_doccount(). If the term isn't present in the database,
0 is returned. ";

%feature("docstring")  Xapian::Database::term_exists "

Test is a particular term is present in any document.

bool Xapian::Database::term_exists(std::string_view term) const
Xapian::Database::term_exists

Parameters:
-----------

term:  The term to test for. An empty string acts as a special pseudo-
term which indexes all the documents in the database, so returns true
if the database contains any documents.

db.term_exists(t) gives the same answer as db.get_termfreq(t) != 0,
but is typically more efficient. ";

%feature("docstring")  Xapian::Database::get_collection_freq "

Get the total number of occurrences of a specified term.

Xapian::termcount
Xapian::Database::get_collection_freq(std::string_view term) const
Xapian::Database::get_collection_freq The collection frequency of a
term is defined as the total number of times it occurs in the
database, which is the sum of its wdf in all the documents it indexes.

Parameters:
-----------

term:  The term to get the collection frequency of. An empty string
acts as a special pseudo-term which indexes all the documents in the
database, so returns get_doccount(). If the term isn't present in the
database, 0 is returned. ";

%feature("docstring")  Xapian::Database::get_value_freq "

Return the frequency of a given value slot.

Xapian::doccount Xapian::Database::get_value_freq(Xapian::valueno
slot) const Xapian::Database::get_value_freq This is the number of
documents which have a (non-empty) value stored in the slot.

Parameters:
-----------

slot:  The value slot to examine. ";

%feature("docstring")  Xapian::Database::get_value_lower_bound "

Get a lower bound on the values stored in the given value slot.

std::string Xapian::Database::get_value_lower_bound(Xapian::valueno
slot) const Xapian::Database::get_value_lower_bound If there are no
values stored in the given value slot, this will return an empty
string.

Parameters:
-----------

slot:  The value slot to examine. ";

%feature("docstring")  Xapian::Database::get_value_upper_bound "

Get an upper bound on the values stored in the given value slot.

std::string Xapian::Database::get_value_upper_bound(Xapian::valueno
slot) const Xapian::Database::get_value_upper_bound If there are no
values stored in the given value slot, this will return an empty
string.

Parameters:
-----------

slot:  The value slot to examine. ";

%feature("docstring")  Xapian::Database::get_doclength_lower_bound "

Get a lower bound on the length of a document in this DB.

Xapian::termcount Xapian::Database::get_doclength_lower_bound() const
Xapian::Database::get_doclength_lower_bound This bound does not
include any zero-length documents. ";

%feature("docstring")  Xapian::Database::get_doclength_upper_bound "

Get an upper bound on the length of a document in this DB.

Xapian::termcount Xapian::Database::get_doclength_upper_bound() const
Xapian::Database::get_doclength_upper_bound";

%feature("docstring")  Xapian::Database::get_wdf_upper_bound "

Get an upper bound on the wdf of term term.

Xapian::termcount
Xapian::Database::get_wdf_upper_bound(std::string_view term) const
Xapian::Database::get_wdf_upper_bound";

%feature("docstring")  Xapian::Database::get_unique_terms_lower_bound
"

Get a lower bound on the unique terms size of a document in this DB.

Xapian::termcount Xapian::Database::get_unique_terms_lower_bound()
const Xapian::Database::get_unique_terms_lower_bound

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Database::get_unique_terms_upper_bound
"

Get an upper bound on the unique terms size of a document in this DB.

Xapian::termcount Xapian::Database::get_unique_terms_upper_bound()
const Xapian::Database::get_unique_terms_upper_bound

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Database::valuestream_begin "

Return an iterator over the value in slot slot for each document.

ValueIterator Xapian::Database::valuestream_begin(Xapian::valueno
slot) const Xapian::Database::valuestream_begin";

%feature("docstring")  Xapian::Database::valuestream_end "

Return end iterator corresponding to valuestream_begin().

ValueIterator Xapian::Database::valuestream_end(Xapian::valueno) const
noexcept Xapian::Database::valuestream_end";

%feature("docstring")  Xapian::Database::get_doclength "

Get the length of a specified document.

Xapian::termcount Xapian::Database::get_doclength(Xapian::docid did)
const Xapian::Database::get_doclength

Parameters:
-----------

did:  The document id of the document

Xapian defines a document's length as the sum of the wdf of all the
terms which index it. ";

%feature("docstring")  Xapian::Database::get_unique_terms "

Get the number of unique terms in a specified document.

Xapian::termcount Xapian::Database::get_unique_terms(Xapian::docid
did) const Xapian::Database::get_unique_terms

Parameters:
-----------

did:  The document id of the document

This is the number of different terms which index the given document.
";

%feature("docstring")  Xapian::Database::get_wdfdocmax "

Get the maximum wdf value in a specified document.

Xapian::termcount Xapian::Database::get_wdfdocmax(Xapian::docid did)
const Xapian::Database::get_wdfdocmax

Parameters:
-----------

did:  The document id of the document

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Database::keep_alive "

Send a keep-alive message.

void Xapian::Database::keep_alive() Xapian::Database::keep_alive For
remote databases, this method sends a message to the server to reset
the timeout timer. As well as preventing timeouts at the Xapian remote
protocol level, this message will also avoid timeouts at lower levels.

For local databases, this method does nothing. ";

%feature("docstring")  Xapian::Database::get_document "

Get a document from the database.

Xapian::Document Xapian::Database::get_document(Xapian::docid did,
unsigned flags=0) const Xapian::Database::get_document The returned
object acts as a handle which lazily fetches information about the
specified document from the database.

Parameters:
-----------

did:  The document ID of the document to be get

flags:  Zero or more flags bitwise-or-ed together (currently only
Xapian::DOC_ASSUME_VALID is supported). (default: 0)

The flags parameter was added in Xapian 2.0.0.

Parameters:
-----------

Xapian::InvalidArgumentError:  is thrown if did is 0.

Xapian::DocNotFoundError:  is thrown if the specified docid is not
present in this database. ";

%feature("docstring")  Xapian::Database::get_spelling_suggestion "

Suggest a spelling correction.

std::string Xapian::Database::get_spelling_suggestion(std::string_view
word, unsigned max_edit_distance=2) const
Xapian::Database::get_spelling_suggestion

Parameters:
-----------

word:  The potentially misspelled word.

max_edit_distance:  Only consider words which are at most
max_edit_distance edits from word. An edit is a character insertion,
deletion, or the transposition of two adjacent characters (default is
2). ";

%feature("docstring")  Xapian::Database::spellings_begin "

An iterator which returns all the spelling correction targets.

Xapian::TermIterator Xapian::Database::spellings_begin() const
Xapian::Database::spellings_begin This returns all the words which are
considered as targets for the spelling correction algorithm. The
frequency of each word is available as the term frequency of each
entry in the returned iterator. ";

%feature("docstring")  Xapian::Database::spellings_end "

End iterator corresponding to spellings_begin().

Xapian::TermIterator Xapian::Database::spellings_end() const noexcept
Xapian::Database::spellings_end";

%feature("docstring")  Xapian::Database::synonyms_begin "

An iterator which returns all the synonyms for a given term.

Xapian::TermIterator Xapian::Database::synonyms_begin(std::string_view
term) const Xapian::Database::synonyms_begin

Parameters:
-----------

term:  The term to return synonyms for. ";

%feature("docstring")  Xapian::Database::synonyms_end "

End iterator corresponding to synonyms_begin(term).

Xapian::TermIterator Xapian::Database::synonyms_end(std::string_view)
const noexcept Xapian::Database::synonyms_end";

%feature("docstring")  Xapian::Database::synonym_keys_begin "

An iterator which returns all terms which have synonyms.

Xapian::TermIterator
Xapian::Database::synonym_keys_begin(std::string_view prefix={}) const
Xapian::Database::synonym_keys_begin

Parameters:
-----------

prefix:  If non-empty, only terms with this prefix are returned. ";

%feature("docstring")  Xapian::Database::synonym_keys_end "

End iterator corresponding to synonym_keys_begin(prefix).

Xapian::TermIterator
Xapian::Database::synonym_keys_end(std::string_view={}) const noexcept
Xapian::Database::synonym_keys_end";

%feature("docstring")  Xapian::Database::get_metadata "

Get the user-specified metadata associated with a given key.

std::string Xapian::Database::get_metadata(std::string_view key) const
Xapian::Database::get_metadata User-specified metadata allows you to
store arbitrary information in the form of (key, value) pairs. See
WritableDatabase::set_metadata() for more information.

When invoked on a Xapian::Database object representing multiple
databases, currently only the metadata for the first is considered but
this behaviour may change in the future.

If there is no piece of metadata associated with the specified key, an
empty string is returned (this applies even for backends which don't
support metadata).

Empty keys are not valid, and specifying one will cause an exception.

Parameters:
-----------

key:  The key of the metadata item to access.

The retrieved metadata item's value.

Parameters:
-----------

Xapian::InvalidArgumentError:  will be thrown if the key supplied is
empty. ";

%feature("docstring")  Xapian::Database::metadata_keys_begin "

An iterator which returns all user-specified metadata keys.

Xapian::TermIterator
Xapian::Database::metadata_keys_begin(std::string_view prefix={})
const Xapian::Database::metadata_keys_begin When invoked on a
Xapian::Database object representing multiple databases, currently
only the metadata for the first is considered but this behaviour may
change in the future.

If the backend doesn't support metadata, then this method returns an
iterator which compares equal to that returned by metadata_keys_end().

Parameters:
-----------

prefix:  If non-empty, only keys with this prefix are returned.

Parameters:
-----------

Xapian::UnimplementedError:  will be thrown if the backend implements
user-specified metadata, but doesn't implement iterating its keys
(currently this happens for the InMemory backend). ";

%feature("docstring")  Xapian::Database::metadata_keys_end "

End iterator corresponding to metadata_keys_begin().

Xapian::TermIterator
Xapian::Database::metadata_keys_end(std::string_view={}) const
noexcept Xapian::Database::metadata_keys_end";

%feature("docstring")  Xapian::Database::get_uuid "

Get the UUID for the database.

std::string Xapian::Database::get_uuid() const
Xapian::Database::get_uuid The UUID will persist for the lifetime of
the database.

Replicas (eg, made with the replication protocol, or by copying all
the database files) will have the same UUID. However, copies (made
with copydatabase, or xapian-compact) will have different UUIDs.

If the backend does not support UUIDs or this database has no
subdatabases, the UUID will be empty.

If this database has multiple sub-databases, the UUID string will
contain the UUIDs of all the sub-databases separated by colons. ";

%feature("docstring")  Xapian::Database::locked "

Test if this database is currently locked for writing.

bool Xapian::Database::locked() const Xapian::Database::locked If the
underlying object is actually a WritableDatabase, always returns true
unless close() has been called.

Otherwise tests if there's a writer holding the lock (or if we can't
test for a lock without taking it on the current platform, throw
Xapian::UnimplementedError). If there's an error while trying to test
the lock, throws Xapian::DatabaseLockError.

For multi-databases, this tests each sub-database and returns true if
any of them are locked. ";

%feature("docstring")  Xapian::Database::lock "

Lock a read-only database for writing.

Xapian::WritableDatabase Xapian::Database::lock(int flags=0)
Xapian::Database::lock If the database is actually already writable
(i.e. a WritableDatabase via a Database reference) then the same
database is returned (with its flags updated, so this provides an
efficient way to modify flags on an open WritableDatabase).

Unlike unlock(), the object this is called on remains open.

Parameters:
-----------

flags:  The flags to use for the writable database. Flags which
specify how to open the database are ignored (e.g.
DB_CREATE_OR_OVERWRITE doesn't result in the database being wiped),
and flags which specify the backend are also ignored as they are only
relevant when creating a new database.

A WritableDatabase object open on the same database.

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Database::unlock "

Release a database write lock.

Xapian::Database Xapian::Database::unlock() Xapian::Database::unlock
If called on a read-only database then the same database is returned.

If called on a writable database, the object this method was called on
is closed.

A Database object open on the same database.

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Database::get_revision "

Get the revision of the database.

Xapian::rev Xapian::Database::get_revision() const
Xapian::Database::get_revision The revision is an unsigned integer
which increases with each commit.

Parameters:
-----------

Xapian::InvalidOperationError:  If the database consists of more than
one shard.

Xapian::UnimplementedError:  Currently this is only implemented for
glass.

In:   Xapian < 1.4.13, if the database consists of no shards; In
Xapian >= 1.4.13 this method returns 0 if there are no shards.

Experimental - seehttps://xapian.org/docs/deprecation#experimental-
features ";

%feature("docstring")  Xapian::Database::compact "

Produce a compact version of this database.

void Xapian::Database::compact(std::string_view output, unsigned
flags=0, int block_size=0) Xapian::Database::compact

Parameters:
-----------

output:  Path to write the compact version to. This can be the same as
an input if that input is a stub database (in which case the
database(s) listed in the stub will be compacted to a new database and
then the stub will be atomically updated to point to this new
database).

flags:  Any of the following combined using bitwise-or (| in C++):
Xapian::DBCOMPACT_NO_RENUMBER By default the document ids will be
renumbered the output - currently by applying the same offset to all
the document ids in a particular source database. If this flag is
specified, then this renumbering doesn't happen, but all the document
ids must be unique over all source databases. Currently the ranges of
document ids in each source must not overlap either, though this
restriction may be removed in the future.

Xapian::DBCOMPACT_MULTIPASS If merging more than 3 databases, merge
the postlists in multiple passes, which is generally faster but
requires more disk space for temporary files.

Xapian::DBCOMPACT_SINGLE_FILE Produce a single-file database (only
supported for glass currently).

At most one of:  Xapian::Compactor::STANDARD - Don't split items
unnecessarily.

Xapian::Compactor::FULL - Split items whenever it saves space (the
default).

Xapian::Compactor::FULLER - Allow oversize items to save more space
(not recommended if you ever plan to update the compacted database).

1.4.31 Has the same effect as FULL.

At most one of the following to specify the output format (currently
only glass to honey conversion is supported, and all shards of the
input must have the same format):  Xapian::DB_BACKEND_HONEY

Parameters:
-----------

block_size:  This specifies the block size (in bytes) for to use for
the output. For glass, the block size must be a power of 2 between
2048 and 65536 (inclusive), and the default (also used if an invalid
value is passed) is 8192 bytes.

1.3.4 This method was added to replace various methods of the
Compactor class. ";

%feature("docstring")  Xapian::Database::compact "

Produce a compact version of this database.

void Xapian::Database::compact(int fd, unsigned flags=0, int
block_size=0) Xapian::Database::compact This variant writes a single-
file database to the specified file descriptor. Only the glass backend
supports such databases, so this form is only supported for this
backend.

Parameters:
-----------

fd:  File descriptor to write the compact version to. The descriptor
needs to be readable and writable (open with O_RDWR) and seekable. The
current file offset is used, allowing compacting to a single file
database embedded within another file. Xapian takes ownership of the
file descriptor and will close it before returning.

flags:  Any of the following combined using bitwise-or (| in C++):
Xapian::DBCOMPACT_NO_RENUMBER By default the document ids will be
renumbered the output - currently by applying the same offset to all
the document ids in a particular source database. If this flag is
specified, then this renumbering doesn't happen, but all the document
ids must be unique over all source databases. Currently the ranges of
document ids in each source must not overlap either, though this
restriction may be removed in the future.

Xapian::DBCOMPACT_MULTIPASS If merging more than 3 databases, merge
the postlists in multiple passes, which is generally faster but
requires more disk space for temporary files.

Xapian::DBCOMPACT_SINGLE_FILE Produce a single-file database (only
supported for glass currently).

At most one of:  Xapian::Compactor::STANDARD - Don't split items
unnecessarily.

Xapian::Compactor::FULL - Split items whenever it saves space (the
default).

Xapian::Compactor::FULLER - Allow oversize items to save more space
(not recommended if you ever plan to update the compacted database).

1.4.31 Has the same effect as FULL.

Parameters:
-----------

block_size:  This specifies the block size (in bytes) for to use for
the output. For glass, the block size must be a power of 2 between
2048 and 65536 (inclusive), and the default (also used if an invalid
value is passed) is 8192 bytes.

1.3.4 This method was added to replace various methods of the
Compactor class. ";

%feature("docstring")  Xapian::Database::compact "

Produce a compact version of this database.

void Xapian::Database::compact(std::string_view output, unsigned
flags, int block_size, Xapian::Compactor &compactor)
Xapian::Database::compact The compactor functor allows handling
progress output and specifying how user metadata is merged.

Parameters:
-----------

output:  Path to write the compact version to. This can be the same as
an input if that input is a stub database (in which case the
database(s) listed in the stub will be compacted to a new database and
then the stub will be atomically updated to point to this new
database).

flags:  Any of the following combined using bitwise-or (| in C++):
Xapian::DBCOMPACT_NO_RENUMBER By default the document ids will be
renumbered the output - currently by applying the same offset to all
the document ids in a particular source database. If this flag is
specified, then this renumbering doesn't happen, but all the document
ids must be unique over all source databases. Currently the ranges of
document ids in each source must not overlap either, though this
restriction may be removed in the future.

Xapian::DBCOMPACT_MULTIPASS If merging more than 3 databases, merge
the postlists in multiple passes, which is generally faster but
requires more disk space for temporary files.

Xapian::DBCOMPACT_SINGLE_FILE Produce a single-file database (only
supported for glass currently).

At most one of:  Xapian::Compactor::STANDARD - Don't split items
unnecessarily.

Xapian::Compactor::FULL - Split items whenever it saves space (the
default).

Xapian::Compactor::FULLER - Allow oversize items to save more space
(not recommended if you ever plan to update the compacted database).

1.4.31 Has the same effect as FULL.

Parameters:
-----------

block_size:  This specifies the block size (in bytes) for to use for
the output. For glass, the block size must be a power of 2 between
2048 and 65536 (inclusive), and the default (also used if an invalid
value is passed) is 8192 bytes.

compactor:  Functor

1.3.4 This method was added to replace various methods of the
Compactor class. ";

%feature("docstring")  Xapian::Database::compact "

Produce a compact version of this database.

void Xapian::Database::compact(int fd, unsigned flags, int block_size,
Xapian::Compactor &compactor) Xapian::Database::compact The compactor
functor allows handling progress output and specifying how user
metadata is merged.

This variant writes a single-file database to the specified file
descriptor. Only the glass backend supports such databases, so this
form is only supported for this backend.

Parameters:
-----------

fd:  File descriptor to write the compact version to. The descriptor
needs to be readable and writable (open with O_RDWR) and seekable. The
current file offset is used, allowing compacting to a single file
database embedded within another file. Xapian takes ownership of the
file descriptor and will close it before returning.

flags:  Any of the following combined using bitwise-or (| in C++):
Xapian::DBCOMPACT_NO_RENUMBER By default the document ids will be
renumbered the output - currently by applying the same offset to all
the document ids in a particular source database. If this flag is
specified, then this renumbering doesn't happen, but all the document
ids must be unique over all source databases. Currently the ranges of
document ids in each source must not overlap either, though this
restriction may be removed in the future.

Xapian::DBCOMPACT_MULTIPASS If merging more than 3 databases, merge
the postlists in multiple passes, which is generally faster but
requires more disk space for temporary files.

Xapian::DBCOMPACT_SINGLE_FILE Produce a single-file database (only
supported for glass currently).

At most one of:  Xapian::Compactor::STANDARD - Don't split items
unnecessarily.

Xapian::Compactor::FULL - Split items whenever it saves space (the
default).

Xapian::Compactor::FULLER - Allow oversize items to save more space
(not recommended if you ever plan to update the compacted database).

1.4.31 Has the same effect as FULL.

Parameters:
-----------

block_size:  This specifies the block size (in bytes) for to use for
the output. For glass, the block size must be a power of 2 between
2048 and 65536 (inclusive), and the default (also used if an invalid
value is passed) is 8192 bytes.

compactor:  Functor

1.3.4 This method was added to replace various methods of the
Compactor class. ";

%feature("docstring")  Xapian::Database::reconstruct_text "

Reconstruct document text.

std::string Xapian::Database::reconstruct_text(Xapian::docid did,
size_t length=0, std::string_view prefix={}, Xapian::termpos
start_pos=0, Xapian::termpos end_pos=0) const
Xapian::Database::reconstruct_text This uses term positional
information to reconstruct the document text which was indexed.
Reading the required positional information is potentially quite I/O
intensive.

The reconstructed text will be missing punctuation and most
capitalisation.

Parameters:
-----------

did:  The document id of the document to reconstruct

length:  Number of bytes of text to aim for - note that slightly more
may be returned (default: 0 meaning unlimited)

prefix:  Term prefix to reconstruct (default: none)

start_pos:  First position to reconstruct (default: 0)

end_pos:  Last position to reconstruct (default: 0 meaning all)

Added in Xapian 2.0.0. ";


// File: classXapian_1_1DatabaseClosedError.xml
%feature("docstring") Xapian::DatabaseClosedError "

Indicates an attempt to access a closed database. ";

%feature("docstring")
Xapian::DatabaseClosedError::DatabaseClosedError "

General purpose constructor.

Xapian::DatabaseClosedError::DatabaseClosedError(std::string_view
msg_, std::string_view context_={}, int errno_=0)
Xapian::DatabaseClosedError::DatabaseClosedError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")
Xapian::DatabaseClosedError::DatabaseClosedError "

Construct from message and errno value.

Xapian::DatabaseClosedError::DatabaseClosedError(std::string_view
msg_, int errno_) Xapian::DatabaseClosedError::DatabaseClosedError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1DatabaseCorruptError.xml
%feature("docstring") Xapian::DatabaseCorruptError "

DatabaseCorruptError indicates database corruption was detected. ";

%feature("docstring")
Xapian::DatabaseCorruptError::DatabaseCorruptError "

General purpose constructor.

Xapian::DatabaseCorruptError::DatabaseCorruptError(std::string_view
msg_, std::string_view context_={}, int errno_=0)
Xapian::DatabaseCorruptError::DatabaseCorruptError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")
Xapian::DatabaseCorruptError::DatabaseCorruptError "

Construct from message and errno value.

Xapian::DatabaseCorruptError::DatabaseCorruptError(std::string_view
msg_, int errno_) Xapian::DatabaseCorruptError::DatabaseCorruptError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1DatabaseCreateError.xml
%feature("docstring") Xapian::DatabaseCreateError "

DatabaseCreateError indicates a failure to create a database. ";

%feature("docstring")
Xapian::DatabaseCreateError::DatabaseCreateError "

General purpose constructor.

Xapian::DatabaseCreateError::DatabaseCreateError(std::string_view
msg_, std::string_view context_={}, int errno_=0)
Xapian::DatabaseCreateError::DatabaseCreateError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")
Xapian::DatabaseCreateError::DatabaseCreateError "

Construct from message and errno value.

Xapian::DatabaseCreateError::DatabaseCreateError(std::string_view
msg_, int errno_) Xapian::DatabaseCreateError::DatabaseCreateError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1DatabaseError.xml
%feature("docstring") Xapian::DatabaseError "

DatabaseError indicates some sort of database related error. ";

%feature("docstring")  Xapian::DatabaseError::DatabaseError "

General purpose constructor.

Xapian::DatabaseError::DatabaseError(std::string_view msg_,
std::string_view context_={}, int errno_=0)
Xapian::DatabaseError::DatabaseError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")  Xapian::DatabaseError::DatabaseError "

Construct from message and errno value.

Xapian::DatabaseError::DatabaseError(std::string_view msg_, int
errno_) Xapian::DatabaseError::DatabaseError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1DatabaseLockError.xml
%feature("docstring") Xapian::DatabaseLockError "

DatabaseLockError indicates failure to lock a database. ";

%feature("docstring")  Xapian::DatabaseLockError::DatabaseLockError "

General purpose constructor.

Xapian::DatabaseLockError::DatabaseLockError(std::string_view msg_,
std::string_view context_={}, int errno_=0)
Xapian::DatabaseLockError::DatabaseLockError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")  Xapian::DatabaseLockError::DatabaseLockError "

Construct from message and errno value.

Xapian::DatabaseLockError::DatabaseLockError(std::string_view msg_,
int errno_) Xapian::DatabaseLockError::DatabaseLockError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1DatabaseModifiedError.xml
%feature("docstring") Xapian::DatabaseModifiedError "

DatabaseModifiedError indicates a database was modified.

To recover after catching this error, you need to call
Xapian::Database::reopen() on the Database and repeat the operation
which failed. ";

%feature("docstring")
Xapian::DatabaseModifiedError::DatabaseModifiedError "

General purpose constructor.

Xapian::DatabaseModifiedError::DatabaseModifiedError(std::string_view
msg_, std::string_view context_={}, int errno_=0)
Xapian::DatabaseModifiedError::DatabaseModifiedError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")
Xapian::DatabaseModifiedError::DatabaseModifiedError "

Construct from message and errno value.

Xapian::DatabaseModifiedError::DatabaseModifiedError(std::string_view
msg_, int errno_) Xapian::DatabaseModifiedError::DatabaseModifiedError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1DatabaseNotFoundError.xml
%feature("docstring") Xapian::DatabaseNotFoundError "

Indicates an attempt to access a database not present. ";

%feature("docstring")
Xapian::DatabaseNotFoundError::DatabaseNotFoundError "

General purpose constructor.

Xapian::DatabaseNotFoundError::DatabaseNotFoundError(std::string_view
msg_, std::string_view context_={}, int errno_=0)
Xapian::DatabaseNotFoundError::DatabaseNotFoundError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")
Xapian::DatabaseNotFoundError::DatabaseNotFoundError "

Construct from message and errno value.

Xapian::DatabaseNotFoundError::DatabaseNotFoundError(std::string_view
msg_, int errno_) Xapian::DatabaseNotFoundError::DatabaseNotFoundError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1DatabaseOpeningError.xml
%feature("docstring") Xapian::DatabaseOpeningError "

DatabaseOpeningError indicates failure to open a database. ";

%feature("docstring")
Xapian::DatabaseOpeningError::DatabaseOpeningError "

General purpose constructor.

Xapian::DatabaseOpeningError::DatabaseOpeningError(std::string_view
msg_, std::string_view context_={}, int errno_=0)
Xapian::DatabaseOpeningError::DatabaseOpeningError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")
Xapian::DatabaseOpeningError::DatabaseOpeningError "

Construct from message and errno value.

Xapian::DatabaseOpeningError::DatabaseOpeningError(std::string_view
msg_, int errno_) Xapian::DatabaseOpeningError::DatabaseOpeningError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1DatabaseVersionError.xml
%feature("docstring") Xapian::DatabaseVersionError "

DatabaseVersionError indicates that a database is in an unsupported
format.

From time to time, new versions of Xapian will require the database
format to be changed, to allow new information to be stored or new
optimisations to be performed. Backwards compatibility will sometimes
be maintained, so that new versions of Xapian can open old databases,
but in some cases Xapian will be unable to open a database because it
is in too old (or new) a format. This can be resolved either be
upgrading or downgrading the version of Xapian in use, or by
rebuilding the database from scratch with the current version of
Xapian. ";

%feature("docstring")
Xapian::DatabaseVersionError::DatabaseVersionError "

General purpose constructor.

Xapian::DatabaseVersionError::DatabaseVersionError(std::string_view
msg_, std::string_view context_={}, int errno_=0)
Xapian::DatabaseVersionError::DatabaseVersionError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")
Xapian::DatabaseVersionError::DatabaseVersionError "

Construct from message and errno value.

Xapian::DatabaseVersionError::DatabaseVersionError(std::string_view
msg_, int errno_) Xapian::DatabaseVersionError::DatabaseVersionError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1DateRangeProcessor.xml
%feature("docstring") Xapian::DateRangeProcessor "

Handle a date range.

Begin and end must be dates in a recognised format. ";

%feature("docstring")  Xapian::DateRangeProcessor::DateRangeProcessor
"

Constructor.

Xapian::DateRangeProcessor::DateRangeProcessor(Xapian::valueno slot_,
unsigned flags_=0, int epoch_year_=1970)
Xapian::DateRangeProcessor::DateRangeProcessor

Parameters:
-----------

slot_:  The value number to return from operator().

flags_:  Zero or more of the following flags, combined with bitwise-
or: Xapian::RP_DATE_PREFER_MDY - interpret ambiguous dates as
month/day/year rather than day/month/year.

epoch_year_:  Year to use as the epoch for dates with 2 digit years
(default: 1970, so 1/1/69 is 2069 while 1/1/70 is 1970). ";

%feature("docstring")  Xapian::DateRangeProcessor::DateRangeProcessor
"

Constructor.

Xapian::DateRangeProcessor::DateRangeProcessor(Xapian::valueno slot_,
std::string_view str_, unsigned flags_=0, int epoch_year_=1970)
Xapian::DateRangeProcessor::DateRangeProcessor

Parameters:
-----------

slot_:  The value slot number to query.

str_:  A prefix or suffix string to look for to recognise values as
belonging to this date range ( flags_ determines whether this is a
prefix or suffix).

flags_:  Zero or more of the following flags, combined with bitwise-
or: Xapian::RP_SUFFIX - require str_ as a suffix instead of a prefix.

Xapian::RP_REPEATED - optionally allow str_ on both ends of the range
- e.g. $1..$10 or 5m..50m. By default a prefix is only checked for on
the start (e.g. date:1/1/1980..31/12/1989), and a suffix only on the
end (e.g. 2..12kg).

Xapian::RP_DATE_PREFER_MDY - interpret ambiguous dates as
month/day/year rather than day/month/year.

epoch_year_:  Year to use as the epoch for dates with 2 digit years
(default: 1970, so 1/1/69 is 2069 while 1/1/70 is 1970).

The string supplied in str_ is used by operator() to decide whether
the pair of strings supplied to it constitute a valid range. If
prefix_ is true, the first value in a range must begin with str_ (and
the second value may optionally begin with str_); if prefix_ is false,
the second value in a range must end with str_ (and the first value
may optionally end with str_).

If str_ is empty then no prefix or suffix is checked for (and
Xapian::RP_SUFFIX and Xapian::RP_REPEATED are irrelevant) - anything
which looks like a date range will be processed. ";


// File: classXapian_1_1DecreasingValueWeightPostingSource.xml
%feature("docstring") Xapian::DecreasingValueWeightPostingSource "

Read weights from a value which is known to decrease as docid
increases.

This posting source can be used, like ValueWeightPostingSource, to add
a weight contribution to a query based on the values stored in a slot.
The values in the slot must be serialised as by  sortable_serialise().

However, this posting source is additionally given an inclusive range
of document IDs within which the weight is known to be decreasing, so
if documents in this range have IDs A and B and B > A then weight of B
<= weight of A. This can allow the posting source to skip to the end
of the range quickly if insufficient weight is left in the posting
source for a particular query to match.

By default, the range is assumed to cover all document IDs.

The ordering property would typically be arranged at index time by
controlling the order that documents are indexed in. ";

%feature("docstring")
Xapian::DecreasingValueWeightPostingSource::DecreasingValueWeightPostingSource
"

Construct a DecreasingValueWeightPostingSource.

Xapian::DecreasingValueWeightPostingSource::DecreasingValueWeightPostingSource(Xapian::valueno
slot_, Xapian::docid range_start_=0, Xapian::docid range_end_=0)
Xapian::DecreasingValueWeightPostingSource::DecreasingValueWeightPosti
ngSource

Parameters:
-----------

slot_:  The value slot to read values from.

range_start_:  Start of range of docids for which weights are known to
be decreasing (default: first docid)

range_end_:  End of range of docids for which weights are known to be
decreasing (default: last docid) ";

%feature("docstring")
Xapian::DecreasingValueWeightPostingSource::get_weight "

Return the weight contribution for the current document.

double Xapian::DecreasingValueWeightPostingSource::get_weight() const
override Xapian::DecreasingValueWeightPostingSource::get_weight This
default implementation always returns 0, for convenience when
implementing \"weight-less\" PostingSource subclasses.

This method may assume that it will only be called when there is a
\"current document\". In detail: Xapian will always call reset() on a
PostingSource before calling this for the first time. It will also
only call this if the PostingSource reports that it is pointing to a
valid document (ie, it will not call it before calling at least one of
next(), skip_to() or check(), and will ensure that the PostingSource
is not at the end by calling at_end()). ";

%feature("docstring")
Xapian::DecreasingValueWeightPostingSource::clone "

Clone the posting source.

DecreasingValueWeightPostingSource *
Xapian::DecreasingValueWeightPostingSource::clone() const override
Xapian::DecreasingValueWeightPostingSource::clone The clone should
inherit the configuration of the parent, but need not inherit the
state. ie, the clone does not need to be in the same iteration
position as the original: the matcher will always call reset() on the
clone before attempting to move the iterator, or read the information
about the current position of the iterator.

This may return NULL to indicate that cloning is not supported. In
this case, the PostingSource may only be used with a single-database
search.

The default implementation returns NULL.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1 ";

%feature("docstring")
Xapian::DecreasingValueWeightPostingSource::name "

Name of the posting source class.

std::string Xapian::DecreasingValueWeightPostingSource::name() const
override Xapian::DecreasingValueWeightPostingSource::name This is used
when serialising and unserialising posting sources; for example, for
performing remote searches.

If the subclass is in a C++ namespace, the namespace should be
included in the name, using \"::\" as a separator. For example, for a
PostingSource subclass called \"FooPostingSource\" in the \"Xapian\"
namespace the result of this call should be
\"Xapian::FooPostingSource\".

This should only be implemented if serialise() and unserialise() are
also implemented. The default implementation returns an empty string.

If this returns an empty string, Xapian will assume that serialise()
and unserialise() are not implemented. ";

%feature("docstring")
Xapian::DecreasingValueWeightPostingSource::serialise "

Serialise object parameters into a string.

std::string Xapian::DecreasingValueWeightPostingSource::serialise()
const override Xapian::DecreasingValueWeightPostingSource::serialise
The serialised parameters should represent the configuration of the
posting source, but need not (indeed, should not) represent the
current iteration state.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.
";

%feature("docstring")
Xapian::DecreasingValueWeightPostingSource::unserialise "

Create object given string serialisation returned by serialise().

DecreasingValueWeightPostingSource *
Xapian::DecreasingValueWeightPostingSource::unserialise(const
std::string &serialised) const override
Xapian::DecreasingValueWeightPostingSource::unserialise Note that the
returned object will be deallocated by Xapian after use with
\"delete\". If you want to handle the deletion in a special way (for
example when wrapping the Xapian API for use from another language)
then you can define a static operator delete method in your subclass
as shown here:https://trac.xapian.org/ticket/554#comment:1

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Parameters:
-----------

serialised:  A serialised instance of this PostingSource subclass. ";

%feature("docstring")
Xapian::DecreasingValueWeightPostingSource::reset "

Set this PostingSource to the start of the list of postings.

void Xapian::DecreasingValueWeightPostingSource::reset(const Database
&db_, Xapian::doccount shard_index) override
Xapian::DecreasingValueWeightPostingSource::reset This is called
automatically by the matcher prior to each query being processed.

If a PostingSource is used for multiple searches,  reset() will
therefore be called multiple times, and must handle this by using the
database passed in the most recent call.

Parameters:
-----------

db:  The database which the PostingSource should iterate through.

shard_index:  The 0-based index indicating which shard in a multi-
database db is. This can be useful if you have an external source of
postings corresponding to each shard.

Note: in the case of a multi-database search, a separate PostingSource
will be used for each database (the separate PostingSources will be
obtained using  clone()), and each PostingSource will be passed one of
the sub-databases as the db parameter here. The db parameter will
therefore always refer to a single database. All docids passed to, or
returned from, the PostingSource refer to docids in that single
database, rather than in the multi- database.

A default implementation is provided which calls the older init()
method to allow existing subclasses to continue to work, but the
default implementation of init() throws Xapian::InvalidOperationError
so you must override either this method or init(). In new code,
override this method in preference.

Added in Xapian 2.0.0. ";

%feature("docstring")
Xapian::DecreasingValueWeightPostingSource::next "

Advance the current position to the next matching document.

void Xapian::DecreasingValueWeightPostingSource::next(double min_wt)
override Xapian::DecreasingValueWeightPostingSource::next The
PostingSource starts before the first entry in the list, so next(),
skip_to() or check() must be called before any methods which need the
context of the current position.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Parameters:
-----------

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")
Xapian::DecreasingValueWeightPostingSource::skip_to "

Advance to the specified docid.

void Xapian::DecreasingValueWeightPostingSource::skip_to(Xapian::docid
min_docid, double min_wt) override
Xapian::DecreasingValueWeightPostingSource::skip_to If the specified
docid isn't in the list, position ourselves on the first document
after it (or at_end() if no greater docids are present).

If the current position is already the specified docid, this method
will leave the position unmodified.

If the specified docid is earlier than the current position, the
behaviour is unspecified. A sensible behaviour would be to leave the
current position unmodified, but it is also reasonable to move to the
specified docid.

The default implementation calls next() repeatedly, which works but
skip_to() can often be implemented much more efficiently.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Note: in the case of a multi-database search, the docid specified is
the docid in the single subdatabase relevant to this posting source.
See the  reset() method for details.

Parameters:
-----------

did:  The document id to advance to.

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")
Xapian::DecreasingValueWeightPostingSource::check "

Check if the specified docid occurs.

bool Xapian::DecreasingValueWeightPostingSource::check(Xapian::docid
min_docid, double min_wt) override
Xapian::DecreasingValueWeightPostingSource::check The caller is
required to ensure that the specified document id did actually exists
in the database. If it does, it must move to that document id, and
return true. If it does not, it may either:

return true, having moved to a definite position (including
\"at_end\"), which must be the same position as skip_to() would have
moved to.

or

return false, having moved to an \"indeterminate\" position, such that
a subsequent call to next() or skip_to() will move to the next
matching position after did.

Generally, this method should act like skip_to() and return true if
that can be done at little extra cost.

Otherwise it should simply check if a particular docid is present,
returning true if it is, and false if it isn't.

The default implementation calls skip_to() and always returns true.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Note: in the case of a multi-database search, the docid specified is
the docid in the single subdatabase relevant to this posting source.
See the  reset() method for details.

Parameters:
-----------

did:  The document id to check.

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")
Xapian::DecreasingValueWeightPostingSource::get_description "

Return a string describing this object.

std::string
Xapian::DecreasingValueWeightPostingSource::get_description() const
override Xapian::DecreasingValueWeightPostingSource::get_description
This default implementation returns a generic answer. This default it
provided to avoid forcing those deriving their own PostingSource
subclass from having to implement this (they may not care what
get_description() gives for their subclass). ";


// File: classXapian_1_1DiceWeight.xml
%feature("docstring") Xapian::DiceWeight "

Xapian::Weight subclass implementing Dice Coefficient.

The Dice Coefficient measures the degree of similarity between pairs
of sets (in Xapian, these sets are words in a document and words in a
query).

https://en.wikipedia.org/wiki/Dice-S%C3%B8rensen_coefficient

(It's named after Lee Raymond Dice rather than after cubes or other
polyhedra with numbered sides which are rolled to generate random
numbers in games.)

Ranking by the Dice Coefficient is the same ranking by the Jaccard
coefficient since you can calculate Jaccard coefficient J from Dice
coefficient D using equation J = D / (2 - D) which is a monotonic for
the range [0,1] (the range of possible Dice coefficient values).

2.0.0 ";

%feature("docstring")  Xapian::DiceWeight::clone "

Clone this object.

DiceWeight * Xapian::DiceWeight::clone() const
Xapian::DiceWeight::clone This method allocates and returns a copy of
the object it is called on.

If your subclass is called FooWeight and has parameters a and b, then
you would implement FooWeight::clone() like so:

FooWeight * FooWeight::clone() const { return new FooWeight(a, b); }

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1 ";

%feature("docstring")  Xapian::DiceWeight::DiceWeight "

Construct a DiceWeight.

Xapian::DiceWeight::DiceWeight() Xapian::DiceWeight::DiceWeight";

%feature("docstring")  Xapian::DiceWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::DiceWeight::name() const Xapian::DiceWeight::name
\"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::DiceWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::DiceWeight::serialise() const
Xapian::DiceWeight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::DiceWeight::unserialise "

Unserialise parameters.

DiceWeight * Xapian::DiceWeight::unserialise(const std::string
&serialised) const Xapian::DiceWeight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::DiceWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::DiceWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterm,
Xapian::termcount wdfdocmax) const Xapian::DiceWeight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::DiceWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::DiceWeight::get_maxpart() const
Xapian::DiceWeight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::DiceWeight::create_from_parameters "

Create from a human-readable parameter string.

DiceWeight * Xapian::DiceWeight::create_from_parameters(const char
*params) const Xapian::DiceWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1DLHWeight.xml
%feature("docstring") Xapian::DLHWeight "

This class implements the DLH weighting scheme, which is a
representative scheme of the Divergence from Randomness Framework by
Gianni Amati.

This is a parameter free weighting scheme and it should be used with
query expansion to obtain better results. It uses the HyperGeometric
Probabilistic model and Laplace's normalization to calculate the risk
gain.

For more information about the DFR Framework and the DLH scheme,
please refer to : a.) Gianni Amati and Cornelis Joost Van Rijsbergen
Probabilistic models of information retrieval based on measuring the
divergence from randomness ACM Transactions on Information Systems
(TOIS) 20, (4), 2002, pp. 357-389. b.) FUB, IASI-CNR and University of
Tor Vergata at TREC 2007 Blog Track. G. Amati and E. Ambrosi and M.
Bianchi and C. Gaibisso and G. Gambosi. Proceedings of the 16th Text
REtrieval Conference (TREC-2007), 2008. ";

%feature("docstring")  Xapian::DLHWeight::DLHWeight "Xapian::DLHWeight::DLHWeight() Xapian::DLHWeight::DLHWeight";

%feature("docstring")  Xapian::DLHWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::DLHWeight::name() const Xapian::DLHWeight::name
\"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::DLHWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::DLHWeight::serialise() const
Xapian::DLHWeight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::DLHWeight::unserialise "

Unserialise parameters.

DLHWeight * Xapian::DLHWeight::unserialise(const std::string
&serialised) const Xapian::DLHWeight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::DLHWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::DLHWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterms,
Xapian::termcount wdfdocmax) const Xapian::DLHWeight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::DLHWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::DLHWeight::get_maxpart() const
Xapian::DLHWeight::get_maxpart This information is used by the matcher
to perform various optimisations, so strive to make the bound as tight
as possible. ";

%feature("docstring")  Xapian::DLHWeight::create_from_parameters "

Create from a human-readable parameter string.

DLHWeight * Xapian::DLHWeight::create_from_parameters(const char
*params) const Xapian::DLHWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1DocNotFoundError.xml
%feature("docstring") Xapian::DocNotFoundError "

Indicates an attempt to access a document not present in the database.
";

%feature("docstring")  Xapian::DocNotFoundError::DocNotFoundError "

General purpose constructor.

Xapian::DocNotFoundError::DocNotFoundError(std::string_view msg_,
std::string_view context_={}, int errno_=0)
Xapian::DocNotFoundError::DocNotFoundError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")  Xapian::DocNotFoundError::DocNotFoundError "

Construct from message and errno value.

Xapian::DocNotFoundError::DocNotFoundError(std::string_view msg_, int
errno_) Xapian::DocNotFoundError::DocNotFoundError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1Document.xml
%feature("docstring") Xapian::Document "

Class representing a document.

The term \"document\" shouldn't be taken too literally - really it's a
\"thing to retrieve\", as the list of search results is essentially a
list of documents.

Document objects fetch information from the database lazily. Usually
this behaviour isn't visible to users (except for the speed benefits),
but if the document in the database is modified or deleted then
preexisting Document objects may return the old or new versions of
data (or throw Xapian::DocNotFoundError in the case of deletion).

Since Database objects work on a snapshot of the database's state, the
situation above can only happen with a WritableDatabase object, or if
you call Database::reopen() on the Database object which you got the
Document from.

We recommend you avoid designs where this behaviour is an issue, but
if you need a way to make a non-lazy version of a Document object, you
can do this like so:doc =
Xapian::Document::unserialise(doc.serialise()); ";

%feature("docstring")  Xapian::Document::Document "

Copy constructor.

Xapian::Document::Document(const Document &o)
Xapian::Document::Document The internals are reference counted, so
copying is cheap. ";

%feature("docstring")  Xapian::Document::Document "

Move constructor.

Xapian::Document::Document(Document &&o) Xapian::Document::Document";

%feature("docstring")  Xapian::Document::Document "

Default constructor.

Xapian::Document::Document() Xapian::Document::Document Creates an
empty Document. ";

%feature("docstring")  Xapian::Document::~Document "

Destructor.

Xapian::Document::~Document() Xapian::Document::~Document";

%feature("docstring")  Xapian::Document::get_docid "

Get the document ID this document came from.

Xapian::docid Xapian::Document::get_docid() const
Xapian::Document::get_docid If this document didn't come from a
database, this will be 0 (in Xapian 1.0.22/1.2.4 or later; prior to
this the returned value was uninitialised in this case).

Note that if the document came from a sharded database, this is the
docid in the shard it came from, not the docid in the combined
database. ";

%feature("docstring")  Xapian::Document::get_data "

Get the document data.

std::string Xapian::Document::get_data() const
Xapian::Document::get_data";

%feature("docstring")  Xapian::Document::set_data "

Set the document data.

void Xapian::Document::set_data(std::string_view data)
Xapian::Document::set_data This is an opaque blob as far as Xapian is
concerned - it's up to you to impose whatever structure you want on
it. If you want to store structured data, consider using something
like protocol buffers. ";

%feature("docstring")  Xapian::Document::add_term "

Add a term to this document.

void Xapian::Document::add_term(std::string_view term,
Xapian::termcount wdf_inc=1) Xapian::Document::add_term";

%feature("docstring")  Xapian::Document::add_boolean_term "

Add a boolean filter term to the document.

void Xapian::Document::add_boolean_term(std::string_view term)
Xapian::Document::add_boolean_term This method adds term to the
document with wdf of 0 - this is generally what you want for a term
used for boolean filtering as the wdf of such terms is ignored, and it
doesn't make sense for them to contribute to the document's length.

If the specified term already indexes this document, this method has
no effect.

It is exactly the same as add_term(term, 0) and is provided as a way
to make a common operation more explicit.

Parameters:
-----------

term:  The term to add.

This method was added in Xapian 1.0.18. ";

%feature("docstring")  Xapian::Document::remove_term "

Remove a term from this document.

void Xapian::Document::remove_term(std::string_view term)
Xapian::Document::remove_term";

%feature("docstring")  Xapian::Document::add_posting "

Add a posting for a term.

void Xapian::Document::add_posting(std::string_view term,
Xapian::termpos term_pos, Xapian::termcount wdf_inc=1)
Xapian::Document::add_posting";

%feature("docstring")  Xapian::Document::remove_posting "

Remove posting for a term.

void Xapian::Document::remove_posting(std::string_view term,
Xapian::termpos term_pos, Xapian::termcount wdf_dec=1)
Xapian::Document::remove_posting The instance of the specified term at
position term_pos will be removed, and the wdf reduced by wdf_dec (the
wdf will not ever go below zero though - the resultant wdf is clamped
to zero if it would).

If the term doesn't occur at position term_pos then
Xapian::InvalidArgumentError is thrown. If you want to remove a single
position which may not be present without triggering an exception you
can call remove_postings(term, pos, pos) instead.

Since 2.0.0, if the final position is removed and the wdf becomes zero
then the term will be removed from the document. ";

%feature("docstring")  Xapian::Document::remove_postings "

Remove a range of postings for a term.

Xapian::termpos Xapian::Document::remove_postings(std::string_view
term, Xapian::termpos term_pos_first, Xapian::termpos term_pos_last,
Xapian::termcount wdf_dec=1) Xapian::Document::remove_postings Any
instances of the term at positions >= term_pos_first and <=
term_pos_last will be removed, and the wdf reduced by wdf_dec for each
instance removed (the wdf will not ever go below zero though - the
resultant wdf is clamped to zero if it would).

If the term doesn't occur in the range of positions specified
(including if term_pos_first > term_pos_last) then this method does
nothing (unlike  remove_posting() which throws an exception if the
specified position is not present).

Since 2.0.0, if all remaining positions are removed and the wdf
becomes zero then the term will be removed from the document. Note
that this only happens if some positions are removed though - calling
this method on a term which has no positions and zero wdf won't remove
that term.

The number of postings removed.

Added in Xapian 1.4.8. ";

%feature("docstring")  Xapian::Document::clear_terms "

Clear all terms from the document.

void Xapian::Document::clear_terms() Xapian::Document::clear_terms";

%feature("docstring")  Xapian::Document::termlist_count "

Return the number of distinct terms in this document.

Xapian::termcount Xapian::Document::termlist_count() const
Xapian::Document::termlist_count";

%feature("docstring")  Xapian::Document::termlist_begin "

Start iterating the terms in this document.

TermIterator Xapian::Document::termlist_begin() const
Xapian::Document::termlist_begin The terms are returned in ascending
string order (by byte value).

Note that if the Document object came from a sharded database then the
TermIterator returned by this method only knows about the shard the
document came from so calling get_termfreq() on it will give you the
term frequency in that shard rather than in the combined database. ";

%feature("docstring")  Xapian::Document::termlist_end "

End iterator corresponding to  termlist_begin().

TermIterator Xapian::Document::termlist_end() const noexcept
Xapian::Document::termlist_end";

%feature("docstring")  Xapian::Document::get_value "

Read a value slot in this document.

std::string Xapian::Document::get_value(Xapian::valueno slot) const
Xapian::Document::get_value

Parameters:
-----------

slot:  The slot to read the value from

The value in slot slot, or an empty string if not set. ";

%feature("docstring")  Xapian::Document::add_value "

Add a value to a slot in this document.

void Xapian::Document::add_value(Xapian::valueno slot,
std::string_view value) Xapian::Document::add_value

Parameters:
-----------

slot:  The slot to set

value:  The new value ";

%feature("docstring")  Xapian::Document::remove_value "

Remove any value from the specified slot.

void Xapian::Document::remove_value(Xapian::valueno slot)
Xapian::Document::remove_value

Parameters:
-----------

slot:  The slot to remove any value from. ";

%feature("docstring")  Xapian::Document::clear_values "

Clear all value slots in this document.

void Xapian::Document::clear_values() Xapian::Document::clear_values";

%feature("docstring")  Xapian::Document::values_count "

Count the value slots used in this document.

Xapian::valueno Xapian::Document::values_count() const
Xapian::Document::values_count";

%feature("docstring")  Xapian::Document::values_begin "

Start iterating the values in this document.

ValueIterator Xapian::Document::values_begin() const
Xapian::Document::values_begin The values are returned in ascending
numerical slot order. ";

%feature("docstring")  Xapian::Document::values_end "

End iterator corresponding to  values_begin().

ValueIterator Xapian::Document::values_end() const noexcept
Xapian::Document::values_end";

%feature("docstring")  Xapian::Document::swap "

Efficiently swap this Document object with another.

void Xapian::Document::swap(Document &o) Xapian::Document::swap

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Document::serialise "

Serialise document into a string.

std::string Xapian::Document::serialise() const
Xapian::Document::serialise The document representation may change
between Xapian releases: even between minor versions. However, it is
guaranteed not to change if the remote database protocol has not
changed between releases. ";

%feature("docstring")  Xapian::Document::get_description "

Return a string describing this object.

std::string Xapian::Document::get_description() const
Xapian::Document::get_description";


// File: classXapian_1_1DocumentSet.xml
%feature("docstring") Xapian::DocumentSet "

Class representing a set of documents in a cluster. ";

%feature("docstring")  Xapian::DocumentSet::DocumentSet "

Copying is allowed.

Xapian::DocumentSet::DocumentSet(const DocumentSet &other)
Xapian::DocumentSet::DocumentSet The internals are reference counted,
so copying is cheap.

Parameters:
-----------

other:  The object to copy. ";

%feature("docstring")  Xapian::DocumentSet::DocumentSet "

Move constructor.

Xapian::DocumentSet::DocumentSet(DocumentSet &&other)
Xapian::DocumentSet::DocumentSet

Parameters:
-----------

other:  The object to move. ";

%feature("docstring")  Xapian::DocumentSet::DocumentSet "

Default constructor.

Xapian::DocumentSet::DocumentSet() Xapian::DocumentSet::DocumentSet";

%feature("docstring")  Xapian::DocumentSet::~DocumentSet "

Destructor.

Xapian::DocumentSet::~DocumentSet()
Xapian::DocumentSet::~DocumentSet";

%feature("docstring")  Xapian::DocumentSet::size "

Return the size of the DocumentSet.

Xapian::doccount Xapian::DocumentSet::size() const
Xapian::DocumentSet::size";

%feature("docstring")  Xapian::DocumentSet::add_document "

Add a new Document to the DocumentSet.

void Xapian::DocumentSet::add_document(const Document &document)
Xapian::DocumentSet::add_document

Parameters:
-----------

document:   Document object that is to be added to the DocumentSet ";


// File: classXapian_1_1DPHWeight.xml
%feature("docstring") Xapian::DPHWeight "

This class implements the DPH weighting scheme.

DPH is a representative scheme of the Divergence from Randomness
Framework by Gianni Amati.

This is a parameter free weighting scheme and it should be used with
query expansion to obtain better results. It uses the HyperGeometric
Probabilistic model and Popper's normalization to calculate the risk
gain.

For more information about the DFR Framework and the DPH scheme,
please refer to : a.) Gianni Amati and Cornelis Joost Van Rijsbergen
Probabilistic models of information retrieval based on measuring the
divergence from randomness ACM Transactions on Information Systems
(TOIS) 20, (4), 2002, pp. 357-389. b.) FUB, IASI-CNR and University of
Tor Vergata at TREC 2007 Blog Track. G. Amati and E. Ambrosi and M.
Bianchi and C. Gaibisso and G. Gambosi. Proceedings of the 16th Text
Retrieval Conference (TREC-2007), 2008. ";

%feature("docstring")  Xapian::DPHWeight::DPHWeight "

Construct a DPHWeight.

Xapian::DPHWeight::DPHWeight() Xapian::DPHWeight::DPHWeight";

%feature("docstring")  Xapian::DPHWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::DPHWeight::name() const Xapian::DPHWeight::name
\"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::DPHWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::DPHWeight::serialise() const
Xapian::DPHWeight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::DPHWeight::unserialise "

Unserialise parameters.

DPHWeight * Xapian::DPHWeight::unserialise(const std::string
&serialised) const Xapian::DPHWeight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::DPHWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::DPHWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterms,
Xapian::termcount wdfdocmax) const Xapian::DPHWeight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::DPHWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::DPHWeight::get_maxpart() const
Xapian::DPHWeight::get_maxpart This information is used by the matcher
to perform various optimisations, so strive to make the bound as tight
as possible. ";

%feature("docstring")  Xapian::DPHWeight::create_from_parameters "

Create from a human-readable parameter string.

DPHWeight * Xapian::DPHWeight::create_from_parameters(const char
*params) const Xapian::DPHWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1Enquire.xml
%feature("docstring") Xapian::Enquire "

Querying session.

An Enquire object represents a querying session - most of the options
for running a query can be set on it, and the query is run via
Enquire::get_mset(). ";

%feature("docstring")  Xapian::Enquire::Enquire "

Copying is allowed.

Xapian::Enquire::Enquire(const Enquire &o) Xapian::Enquire::Enquire
The internals are reference counted, so copying is cheap. ";

%feature("docstring")  Xapian::Enquire::Enquire "

Move constructor.

Xapian::Enquire::Enquire(Enquire &&o) Xapian::Enquire::Enquire";

%feature("docstring")  Xapian::Enquire::Enquire "

Constructor.

Xapian::Enquire::Enquire(const Database &db) Xapian::Enquire::Enquire

Parameters:
-----------

db:  The database (or databases) to query.

2.0.0 If db has no subdatabases, it's handled like any other empty
database. In earlier versions, Xapian::InvalidArgumentError was thrown
in this case. ";

%feature("docstring")  Xapian::Enquire::~Enquire "

Destructor.

Xapian::Enquire::~Enquire() Xapian::Enquire::~Enquire";

%feature("docstring")  Xapian::Enquire::set_query "

Set the query.

void Xapian::Enquire::set_query(const Query &query, termcount
query_length=0) Xapian::Enquire::set_query If set_query() is not
called before calling get_mset(), the default query used will be
Xapian::MatchNothing.

Parameters:
-----------

query:  The Xapian::Query object

query_length:  The query length to use (default: query.get_length())
";

%feature("docstring")  Xapian::Enquire::get_query "

Get the currently set query.

const Query & Xapian::Enquire::get_query() const
Xapian::Enquire::get_query If set_query() is not called before calling
get_query(), then the default query Xapian::MatchNothing will be
returned. ";

%feature("docstring")  Xapian::Enquire::set_weighting_scheme "

Set the weighting scheme to use.

void Xapian::Enquire::set_weighting_scheme(const Weight &weight)
Xapian::Enquire::set_weighting_scheme The Xapian::Weight object passed
is cloned by calling weight.clone(), so doesn't need to remain valid
after the call.

If set_weighting_scheme() is not called before calling get_mset(), the
default weighting scheme is Xapian::BM25Weight().

Parameters:
-----------

weight:   Xapian::Weight object ";

%feature("docstring")  Xapian::Enquire::set_docid_order "

Set sort order for document IDs.

void Xapian::Enquire::set_docid_order(docid_order order)
Xapian::Enquire::set_docid_order This order only has an effect on
documents which would otherwise have equal rank. When ordering by
relevance without a sort key, this means documents with equal weight.
For a boolean match with no sort key, this means all documents. And if
a sort key is used, this means documents with the same sort key (and
also equal weight if ordering on relevance before or after the sort
key).

Parameters:
-----------

order:  This can be:  Xapian::Enquire::ASCENDING docids sort in
ascending order (default)

Xapian::Enquire::DESCENDING docids sort in descending order

Xapian::Enquire::DONT_CARE docids sort in whatever order is most
efficient for the backend

Note: If you add documents in strict date order, then a boolean search
- i.e. set_weighting_scheme(Xapian::BoolWeight()) - with
set_docid_order(Xapian::Enquire::DESCENDING) is an efficient way to
perform \"sort by date, newest first\", and with
set_docid_order(Xapian::Enquire::ASCENDING) a very efficient way to
perform \"sort by date, oldest first\". ";

%feature("docstring")  Xapian::Enquire::set_sort_by_relevance "

Set the sorting to be by relevance only.

void Xapian::Enquire::set_sort_by_relevance()
Xapian::Enquire::set_sort_by_relevance This is the default. ";

%feature("docstring")  Xapian::Enquire::set_sort_by_value "

Set the sorting to be by value only.

void Xapian::Enquire::set_sort_by_value(valueno sort_key, bool
reverse) Xapian::Enquire::set_sort_by_value Note that sorting by
values uses a string comparison, so to use this to sort by a numeric
value you'll need to store the numeric values in a manner which sorts
appropriately. For example, you could use Xapian::sortable_serialise()
(which works for floating point numbers as well as integers), or store
numbers padded with leading zeros or spaces, or with the number of
digits prepended.

Parameters:
-----------

sort_key:  value number to sort on.

reverse:  If true, reverses the sort order. ";

%feature("docstring")  Xapian::Enquire::set_sort_by_key "

Set the sorting to be by key generated from values only.

void Xapian::Enquire::set_sort_by_key(KeyMaker *sorter, bool reverse)
XAPIAN_NONNULL() Xapian::Enquire::set_sort_by_key

Parameters:
-----------

sorter:  The functor to use for generating keys.

reverse:  If true, reverses the sort order. ";

%feature("docstring")
Xapian::Enquire::set_sort_by_value_then_relevance "

Set the sorting to be by value, then by relevance for documents with
the same value.

void Xapian::Enquire::set_sort_by_value_then_relevance(valueno
sort_key, bool reverse)
Xapian::Enquire::set_sort_by_value_then_relevance Note that sorting by
values uses a string comparison, so to use this to sort by a numeric
value you'll need to store the numeric values in a manner which sorts
appropriately. For example, you could use Xapian::sortable_serialise()
(which works for floating point numbers as well as integers), or store
numbers padded with leading zeros or spaces, or with the number of
digits prepended.

Parameters:
-----------

sort_key:  value number to sort on.

reverse:  If true, reverses the sort order. ";

%feature("docstring")  Xapian::Enquire::set_sort_by_key_then_relevance
"

Set the sorting to be by keys generated from values, then by relevance
for documents with identical keys.

void Xapian::Enquire::set_sort_by_key_then_relevance(KeyMaker *sorter,
bool reverse) XAPIAN_NONNULL()
Xapian::Enquire::set_sort_by_key_then_relevance

Parameters:
-----------

sorter:  The functor to use for generating keys.

reverse:  If true, reverses the sort order. ";

%feature("docstring")
Xapian::Enquire::set_sort_by_relevance_then_value "

Set the sorting to be by relevance then value.

void Xapian::Enquire::set_sort_by_relevance_then_value(valueno
sort_key, bool reverse)
Xapian::Enquire::set_sort_by_relevance_then_value Note that sorting by
values uses a string comparison, so to use this to sort by a numeric
value you'll need to store the numeric values in a manner which sorts
appropriately. For example, you could use Xapian::sortable_serialise()
(which works for floating point numbers as well as integers), or store
numbers padded with leading zeros or spaces, or with the number of
digits prepended.

Note that with the default BM25 weighting scheme parameters, non-
identical documents will rarely have the same weight, so this setting
will give very similar results to set_sort_by_relevance(). It becomes
more useful with particular BM25 parameter settings (e.g.
BM25Weight(1,0,1,0,0)) or custom weighting schemes.

Parameters:
-----------

sort_key:  value number to sort on.

reverse:  If true, reverses the sort order of sort_key. Beware that in
1.2.16 and earlier, the sense of this parameter was incorrectly
inverted and inconsistent with the other set_sort_by_... methods. This
was fixed in 1.2.17, so make that version a minimum requirement if
this detail matters to your application. ";

%feature("docstring")  Xapian::Enquire::set_sort_by_relevance_then_key
"

Set the sorting to be by relevance, then by keys generated from
values.

void Xapian::Enquire::set_sort_by_relevance_then_key(KeyMaker *sorter,
bool reverse) XAPIAN_NONNULL()
Xapian::Enquire::set_sort_by_relevance_then_key Note that with the
default BM25 weighting scheme parameters, non- identical documents
will rarely have the same weight, so this setting will give very
similar results to set_sort_by_relevance(). It becomes more useful
with particular BM25 parameter settings (e.g. BM25Weight(1,0,1,0,0))
or custom weighting schemes.

Parameters:
-----------

sorter:  The functor to use for generating keys.

reverse:  If true, reverses the sort order of the generated keys.
Beware that in 1.2.16 and earlier, the sense of this parameter was
incorrectly inverted and inconsistent with the other set_sort_by_...
methods. This was fixed in 1.2.17, so make that version a minimum
requirement if this detail matters to your application. ";

%feature("docstring")  Xapian::Enquire::set_collapse_key "

Control collapsing of results.

void Xapian::Enquire::set_collapse_key(valueno collapse_key, doccount
collapse_max=1) Xapian::Enquire::set_collapse_key The MSet returned by
get_mset() will have only the \"best\" (at most) collapse_max
documents with each particular non-empty value in slot collapse_key
(\"best\" being highest ranked - i.e. highest weight or highest
sorting key).

An example use might be to create a value for each document containing
an MD5 hash of the document contents. Then duplicate documents from
different sources can be eliminated at search time by collapsing with
collapse_max = 1 (it's better to eliminate duplicates at index time,
but this may not be always be possible - for example the search may be
over more than one Xapian database).

Another use is to group matches in a particular category (e.g. you
might collapse a mailing list search on the Subject: so that there's
only one result per discussion thread). In this case you can use
get_collapse_count() to give the user some idea how many other results
there are. And if you index the Subject: as a boolean term as well as
putting it in a value, you can offer a link to a non-collapsed search
restricted to that thread using a boolean filter.

Parameters:
-----------

collapse_key:  value slot to collapse on (default is
Xapian::BAD_VALUENO which means no collapsing).

collapse_max:  Maximum number of documents with the same key to allow
(default: 1). ";

%feature("docstring")  Xapian::Enquire::set_cutoff "

Set lower bounds on percentage and/or weight.

void Xapian::Enquire::set_cutoff(int percent_threshold, double
weight_threshold=0) Xapian::Enquire::set_cutoff

Parameters:
-----------

percent_threshold:  Lower bound on percentage score

weight_threshold:  Lower bound on weight (default: 0)

No thresholds are applied by default, and if either threshold is set
to 0, then that threshold is disabled. ";

%feature("docstring")  Xapian::Enquire::add_matchspy "

Add a matchspy.

void Xapian::Enquire::add_matchspy(MatchSpy *spy) XAPIAN_NONNULL()
Xapian::Enquire::add_matchspy This matchspy will be called with some
of the documents which match the query, during the match process.
Exactly which of the matching documents are passed to it depends on
exactly when certain optimisations occur during the match process, but
it can be controlled to some extent by setting the checkatleast
parameter to  get_mset().

In particular, if there are enough matching documents, at least the
number specified by checkatleast will be passed to the matchspy. This
means that you can force the matchspy to be shown all matching
documents by setting checkatleast to the number of documents in the
database.

Parameters:
-----------

spy:  The MatchSpy subclass to add. The caller must ensure that this
remains valid while the Enquire object remains active, or until
clear_matchspies() is called, or else allocate the MatchSpy object
with new and then disown it by calling spy->release() before passing
it in. ";

%feature("docstring")  Xapian::Enquire::clear_matchspies "

Remove all the matchspies.

void Xapian::Enquire::clear_matchspies()
Xapian::Enquire::clear_matchspies";

%feature("docstring")  Xapian::Enquire::set_time_limit "

Set a time limit for the match.

void Xapian::Enquire::set_time_limit(double time_limit)
Xapian::Enquire::set_time_limit Matches with check_at_least set high
can take a long time in some cases. You can set a time limit on this,
after which check_at_least will be turned off.

Parameters:
-----------

time_limit:  time in seconds after which to disable check_at_least
(default: 0.0 which means no time limit)

Limitations:

This feature is currently supported on platforms which support POSIX
interval timers. Interaction with the remote backend when using
multiple databases may have bugs. There's not currently a way to force
the match to end after a certain time. ";

%feature("docstring")  Xapian::Enquire::get_mset "

Run the query.

MSet Xapian::Enquire::get_mset(doccount first, doccount maxitems,
doccount checkatleast=0, const RSet *rset=NULL, const MatchDecider
*mdecider=NULL) const Xapian::Enquire::get_mset Run the query using
the settings in this Enquire object and those passed as parameters to
the method, and return a Xapian::MSet object.

Parameters:
-----------

first:  Zero-based index of the first result to return (which supports
retrieving pages of results).

maxitems:  The maximum number of documents to return.

checkatleast:  Check at least this many documents. By default Xapian
will avoiding considering documents which it can prove can't match,
which is faster but can result in a loose bounds on and a poor
estimate of the total number of matches - setting checkatleast higher
allows trading off speed for tighter bounds and a more accurate
estimate. (default: 0)

rset:  Documents marked as relevant (default: no documents have been
marked as relevant)

mdecider:   Xapian::MatchDecider object - this acts as a yes/no filter
on documents which match the query. See also Xapian::PostingSource.
(default: no Xapian::MatchDecider) ";

%feature("docstring")  Xapian::Enquire::get_mset "

Run the query.

MSet Xapian::Enquire::get_mset(doccount first, doccount maxitems,
const RSet *rset, const MatchDecider *mdecider=NULL) const
Xapian::Enquire::get_mset Run the query using the settings in this
Enquire object and those passed as parameters to the method, and
return a Xapian::MSet object.

Parameters:
-----------

first:  Zero-based index of the first result to return (which supports
retrieving pages of results).

maxitems:  The maximum number of documents to return.

rset:  Documents marked as relevant (default: no documents have been
marked as relevant)

mdecider:   Xapian::MatchDecider object - this acts as a yes/no filter
on documents which match the query. See also Xapian::PostingSource.
(default: no Xapian::MatchDecider) ";

%feature("docstring")  Xapian::Enquire::get_matching_terms_begin "

Iterate query terms matching a document.

TermIterator Xapian::Enquire::get_matching_terms_begin(docid did)
const Xapian::Enquire::get_matching_terms_begin Takes terms from the
query set by  set_query() and from the document with document ID did
in the database set in the constructor, and returns terms which are in
both, ordered by ascending query position. Terms which occur more than
once in the query are only returned once, at the lowest term position
they occur at.

Parameters:
-----------

did:   Document ID in the database set in the constructor ";

%feature("docstring")  Xapian::Enquire::get_matching_terms_begin "

Iterate query terms matching a document.

TermIterator Xapian::Enquire::get_matching_terms_begin(const
MSetIterator &it) const Xapian::Enquire::get_matching_terms_begin
Convenience overloaded form, taking a Xapian::MSetIterator instead of
a Xapian::docid.

Parameters:
-----------

it:   MSetIterator to return matching terms for ";

%feature("docstring")  Xapian::Enquire::get_matching_terms_end "

End iterator corresponding to  get_matching_terms_begin().

TermIterator Xapian::Enquire::get_matching_terms_end(docid) const
noexcept Xapian::Enquire::get_matching_terms_end";

%feature("docstring")  Xapian::Enquire::get_matching_terms_end "

End iterator corresponding to  get_matching_terms_begin().

TermIterator Xapian::Enquire::get_matching_terms_end(const
MSetIterator &) const noexcept
Xapian::Enquire::get_matching_terms_end";

%feature("docstring")  Xapian::Enquire::set_expansion_scheme "

Set the weighting scheme to use for expansion.

void Xapian::Enquire::set_expansion_scheme(std::string_view
eweightname, double expand_k=1.0) const
Xapian::Enquire::set_expansion_scheme If you don't call this method,
the default is as if you'd used:

set_expansion_scheme(\"prob\");

Parameters:
-----------

eweightname:  A string in lowercase specifying the name of the scheme
to be used. The following schemes are currently available: \"bo1\":
Bose-Einstein 1 model from the Divergence From Randomness framework.

\"prob\" : Probabilistic model (since 1.4.26).

\"trad\" : Deprecated alias for \"prob\".

expand_k:  Parameter k for probabilistic query expansion. A default
value of 1.0 is used if none is specified. ";

%feature("docstring")  Xapian::Enquire::get_eset "

Perform query expansion.

ESet Xapian::Enquire::get_eset(termcount maxitems, const RSet &rset,
int flags=0, const ExpandDecider *edecider=NULL, double
min_weight=0.0) const Xapian::Enquire::get_eset Perform query
expansion using a Xapian::RSet indicating some documents which are
relevant (typically based on the user marking results or similar).

Parameters:
-----------

maxitems:  The maximum number of terms to return.

rset:  Documents marked as relevant.

flags:  Bitwise-or combination of INCLUDE_QUERY_TERMS and
USE_EXACT_TERMFREQ flags (default: 0).

edecider:   Xapian::ExpandDecider object - this acts as a yes/no
filter on terms which are being considered. (default: no
Xapian::ExpandDecider)

min_weight:  Lower bound on weight of acceptable terms (default: 0.0)

Xapian::ESet object containing a list of terms with weights. ";

%feature("docstring")  Xapian::Enquire::get_eset "

Perform query expansion.

ESet Xapian::Enquire::get_eset(termcount maxitems, const RSet &rset,
const ExpandDecider *edecider) const Xapian::Enquire::get_eset Perform
query expansion using a Xapian::RSet indicating some documents which
are relevant (typically based on the user marking results or similar).

Parameters:
-----------

maxitems:  The maximum number of terms to return.

rset:  Documents marked as relevant.

edecider:   Xapian::ExpandDecider object - this acts as a yes/no
filter on terms which are being considered.

Xapian::ESet object containing a list of terms with weights. ";

%feature("docstring")  Xapian::Enquire::get_description "

Return a string describing this object.

std::string Xapian::Enquire::get_description() const
Xapian::Enquire::get_description";


// File: classXapian_1_1Error.xml
%feature("docstring") Xapian::Error "

All exceptions thrown by Xapian are subclasses of Xapian::Error.

This class can not be instantiated directly - instead a subclass
should be used. ";

%feature("docstring")  Xapian::Error::Error "

Default copy constructor.

Xapian::Error::Error(const Error &)=default Xapian::Error::Error We
explicitly specify this to avoid warnings from GCC 9 (from
-Wdeprecated-copy which is enabled by -Wextra). ";

%feature("docstring")  Xapian::Error::get_type "

The type of this error (e.g. \"DocNotFoundError\".).

const char * Xapian::Error::get_type() const noexcept
Xapian::Error::get_type";

%feature("docstring")  Xapian::Error::get_msg "

Message giving details of the error, intended for human consumption.

const std::string & Xapian::Error::get_msg() const noexcept
Xapian::Error::get_msg";

%feature("docstring")  Xapian::Error::get_context "

Optional context information.

const std::string & Xapian::Error::get_context() const noexcept
Xapian::Error::get_context This context is intended for machine use
(for example to know which remote server an error came from), but it
is typically a plain-text string, and so also fit for human
consumption. ";

%feature("docstring")  Xapian::Error::get_error_string "

Returns any system error string associated with this exception.

const char * Xapian::Error::get_error_string() const
Xapian::Error::get_error_string The system error string may come from
errno, h_errno (on UNIX), or GetLastError() (on MS Windows). If there
is no associated system error string, NULL is returned. ";

%feature("docstring")  Xapian::Error::get_description "

Return a string describing this object.

std::string Xapian::Error::get_description() const
Xapian::Error::get_description";


// File: classXapian_1_1ESet.xml
%feature("docstring") Xapian::ESet "

Class representing a list of search results. ";

%feature("docstring")  Xapian::ESet::ESet "

Copying is allowed.

Xapian::ESet::ESet(const ESet &o) Xapian::ESet::ESet The internals are
reference counted, so copying is cheap. ";

%feature("docstring")  Xapian::ESet::ESet "

Move constructor.

Xapian::ESet::ESet(ESet &&o) Xapian::ESet::ESet";

%feature("docstring")  Xapian::ESet::ESet "

Default constructor.

Xapian::ESet::ESet() Xapian::ESet::ESet Creates an empty ESet, mostly
useful as a placeholder. ";

%feature("docstring")  Xapian::ESet::~ESet "

Destructor.

Xapian::ESet::~ESet() Xapian::ESet::~ESet";

%feature("docstring")  Xapian::ESet::size "

Return number of items in this ESet object.

Xapian::termcount Xapian::ESet::size() const Xapian::ESet::size";

%feature("docstring")  Xapian::ESet::empty "

Return true if this ESet object is empty.

bool Xapian::ESet::empty() const Xapian::ESet::empty";

%feature("docstring")  Xapian::ESet::get_ebound "

Return a bound on the full size of this ESet object.

Xapian::termcount Xapian::ESet::get_ebound() const
Xapian::ESet::get_ebound This is a bound on size() if get_eset() had
been called with maxitems set high enough that all results were
returned. ";

%feature("docstring")  Xapian::ESet::swap "

Efficiently swap this ESet object with another.

void Xapian::ESet::swap(ESet &o) Xapian::ESet::swap";

%feature("docstring")  Xapian::ESet::begin "

Return iterator pointing to the first item in this ESet.

ESetIterator Xapian::ESet::begin() const Xapian::ESet::begin";

%feature("docstring")  Xapian::ESet::end "

Return iterator pointing to just after the last item in this ESet.

ESetIterator Xapian::ESet::end() const Xapian::ESet::end";

%feature("docstring")  Xapian::ESet::back "

Return iterator pointing to the last object in this ESet.

ESetIterator Xapian::ESet::back() const Xapian::ESet::back";

%feature("docstring")  Xapian::ESet::get_description "

Return a string describing this object.

std::string Xapian::ESet::get_description() const
Xapian::ESet::get_description";


// File: classXapian_1_1ESetIterator.xml
%feature("docstring") Xapian::ESetIterator "

Iterator over a Xapian::ESet. ";

%feature("docstring")  Xapian::ESetIterator::ESetIterator "

Create an unpositioned ESetIterator.

Xapian::ESetIterator::ESetIterator()
Xapian::ESetIterator::ESetIterator";

%feature("docstring")  Xapian::ESetIterator::get_weight "

Get the weight for the current position.

double Xapian::ESetIterator::get_weight() const
Xapian::ESetIterator::get_weight";

%feature("docstring")  Xapian::ESetIterator::get_description "

Return a string describing this object.

std::string Xapian::ESetIterator::get_description() const
Xapian::ESetIterator::get_description";


// File: classXapian_1_1ExpandDecider.xml
%feature("docstring") Xapian::ExpandDecider "

Virtual base class for expand decider functor. ";

%feature("docstring")  Xapian::ExpandDecider::ExpandDecider "

Default constructor.

Xapian::ExpandDecider::ExpandDecider()
Xapian::ExpandDecider::ExpandDecider";

%feature("docstring")  Xapian::ExpandDecider::~ExpandDecider "

Virtual destructor, because we have virtual methods.

virtual Xapian::ExpandDecider::~ExpandDecider()
Xapian::ExpandDecider::~ExpandDecider";

%feature("docstring")  Xapian::ExpandDecider::release "

Start reference counting this object.

ExpandDecider * Xapian::ExpandDecider::release()
Xapian::ExpandDecider::release You can transfer ownership of a
dynamically allocated ExpandDecider object to Xapian by calling
release() and then passing the object to a Xapian method. Xapian will
arrange to delete the object once it is no longer required. ";

%feature("docstring")  Xapian::ExpandDecider::release "

Start reference counting this object.

const ExpandDecider * Xapian::ExpandDecider::release() const
Xapian::ExpandDecider::release You can transfer ownership of a
dynamically allocated ExpandDecider object to Xapian by calling
release() and then passing the object to a Xapian method. Xapian will
arrange to delete the object once it is no longer required. ";


// File: classXapian_1_1ExpandDeciderAnd.xml
%feature("docstring") Xapian::ExpandDeciderAnd "

ExpandDecider subclass which rejects terms using two ExpandDeciders.

Terms are only accepted if they are accepted by both of the specified
ExpandDecider objects. ";

%feature("docstring")  Xapian::ExpandDeciderAnd::ExpandDeciderAnd "

Terms will be checked with first, and if accepted, then checked with
second.

Xapian::ExpandDeciderAnd::ExpandDeciderAnd(const ExpandDecider
&first_, const ExpandDecider &second_)
Xapian::ExpandDeciderAnd::ExpandDeciderAnd

Parameters:
-----------

first_:  First ExpandDecider object to test with.

second_:   ExpandDecider object to test with if first_ accepts. ";

%feature("docstring")  Xapian::ExpandDeciderAnd::ExpandDeciderAnd "

Compatibility method.

Xapian::ExpandDeciderAnd::ExpandDeciderAnd(const ExpandDecider
*first_, const ExpandDecider *second_)
Xapian::ExpandDeciderAnd::ExpandDeciderAnd

Parameters:
-----------

first_:  First ExpandDecider object to test with.

second_:   ExpandDecider object to test with if first_ accepts. ";


// File: classXapian_1_1ExpandDeciderFilterPrefix.xml
%feature("docstring") Xapian::ExpandDeciderFilterPrefix "

ExpandDecider subclass which restrict terms to a particular prefix.

ExpandDeciderFilterPrefix provides an easy way to choose terms with a
particular prefix when generating an ESet. ";

%feature("docstring")
Xapian::ExpandDeciderFilterPrefix::ExpandDeciderFilterPrefix "

The parameter specify the prefix of terms to be retained.

Xapian::ExpandDeciderFilterPrefix::ExpandDeciderFilterPrefix(const
std::string &prefix_)
Xapian::ExpandDeciderFilterPrefix::ExpandDeciderFilterPrefix

Parameters:
-----------

prefix_:  restrict terms to the particular prefix_ ";


// File: classXapian_1_1ExpandDeciderFilterTerms.xml
%feature("docstring") Xapian::ExpandDeciderFilterTerms "

ExpandDecider subclass which rejects terms in a specified list.

ExpandDeciderFilterTerms provides an easy way to filter out terms from
a fixed list when generating an ESet. ";

%feature("docstring")
Xapian::ExpandDeciderFilterTerms::ExpandDeciderFilterTerms "

The two iterators specify a list of terms to be rejected.

Xapian::ExpandDeciderFilterTerms::ExpandDeciderFilterTerms(Iterator
reject_begin, Iterator reject_end)
Xapian::ExpandDeciderFilterTerms::ExpandDeciderFilterTerms

Parameters:
-----------

reject_begin:  Begin iterator for the list of terms to reject. It can
be any input_iterator type which returns std::string or char * (e.g.
TermIterator or char **).

reject_end:  End iterator for the list of terms to reject. ";


// File: classXapian_1_1FeatureUnavailableError.xml
%feature("docstring") Xapian::FeatureUnavailableError "

Indicates an attempt to use a feature which is unavailable.

Typically a feature is unavailable because it wasn't compiled in, or
because it requires other software or facilities which aren't
available. ";

%feature("docstring")
Xapian::FeatureUnavailableError::FeatureUnavailableError "

General purpose constructor.

Xapian::FeatureUnavailableError::FeatureUnavailableError(std::string_view
msg_, std::string_view context_={}, int errno_=0)
Xapian::FeatureUnavailableError::FeatureUnavailableError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")
Xapian::FeatureUnavailableError::FeatureUnavailableError "

Construct from message and errno value.

Xapian::FeatureUnavailableError::FeatureUnavailableError(std::string_view
msg_, int errno_)
Xapian::FeatureUnavailableError::FeatureUnavailableError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1FieldProcessor.xml
%feature("docstring") Xapian::FieldProcessor "

Base class for field processors. ";

%feature("docstring")  Xapian::FieldProcessor::FieldProcessor "

Default constructor.

Xapian::FieldProcessor::FieldProcessor()
Xapian::FieldProcessor::FieldProcessor";

%feature("docstring")  Xapian::FieldProcessor::~FieldProcessor "

Destructor.

virtual Xapian::FieldProcessor::~FieldProcessor()
Xapian::FieldProcessor::~FieldProcessor";

%feature("docstring")  Xapian::FieldProcessor::release "

Start reference counting this object.

FieldProcessor * Xapian::FieldProcessor::release()
Xapian::FieldProcessor::release You can transfer ownership of a
dynamically allocated FieldProcessor object to Xapian by calling
release() and then passing the object to a Xapian method. Xapian will
arrange to delete the object once it is no longer required. ";

%feature("docstring")  Xapian::FieldProcessor::release "

Start reference counting this object.

const FieldProcessor * Xapian::FieldProcessor::release() const
Xapian::FieldProcessor::release You can transfer ownership of a
dynamically allocated FieldProcessor object to Xapian by calling
release() and then passing the object to a Xapian method. Xapian will
arrange to delete the object once it is no longer required. ";


// File: classXapian_1_1FixedWeightPostingSource.xml
%feature("docstring") Xapian::FixedWeightPostingSource "

A posting source which returns a fixed weight for all documents.

This returns entries for all documents in the given database, with a
fixed weight (specified by a parameter to the constructor). This can
be used to boost a sub-query by OP_AND-ing a FixedWeightPostingSource
with that sub-query - this OP_AND will match the same documents as the
sub-query does, but documents matching the subquery will get the
specified extra weight contribution. ";

%feature("docstring")
Xapian::FixedWeightPostingSource::FixedWeightPostingSource "

Construct a FixedWeightPostingSource.

Xapian::FixedWeightPostingSource::FixedWeightPostingSource(double wt)
Xapian::FixedWeightPostingSource::FixedWeightPostingSource

Parameters:
-----------

wt:  The fixed weight to return. ";

%feature("docstring")
Xapian::FixedWeightPostingSource::get_termfreq_min "

A lower bound on the number of documents this object can return.

Xapian::doccount Xapian::FixedWeightPostingSource::get_termfreq_min()
const override Xapian::FixedWeightPostingSource::get_termfreq_min
Xapian will always call reset() on a PostingSource before calling this
for the first time. ";

%feature("docstring")
Xapian::FixedWeightPostingSource::get_termfreq_est "

An estimate of the number of documents this object can return.

Xapian::doccount Xapian::FixedWeightPostingSource::get_termfreq_est()
const override Xapian::FixedWeightPostingSource::get_termfreq_est It
must always be true that:

get_termfreq_min() <= get_termfreq_est() <= get_termfreq_max()

Xapian will always call reset() on a PostingSource before calling this
for the first time. ";

%feature("docstring")
Xapian::FixedWeightPostingSource::get_termfreq_max "

An upper bound on the number of documents this object can return.

Xapian::doccount Xapian::FixedWeightPostingSource::get_termfreq_max()
const override Xapian::FixedWeightPostingSource::get_termfreq_max
Xapian will always call reset() on a PostingSource before calling this
for the first time. ";

%feature("docstring")  Xapian::FixedWeightPostingSource::get_weight "

Return the weight contribution for the current document.

double Xapian::FixedWeightPostingSource::get_weight() const override
Xapian::FixedWeightPostingSource::get_weight This default
implementation always returns 0, for convenience when implementing
\"weight-less\" PostingSource subclasses.

This method may assume that it will only be called when there is a
\"current document\". In detail: Xapian will always call reset() on a
PostingSource before calling this for the first time. It will also
only call this if the PostingSource reports that it is pointing to a
valid document (ie, it will not call it before calling at least one of
next(), skip_to() or check(), and will ensure that the PostingSource
is not at the end by calling at_end()). ";

%feature("docstring")  Xapian::FixedWeightPostingSource::next "

Advance the current position to the next matching document.

void Xapian::FixedWeightPostingSource::next(double min_wt) override
Xapian::FixedWeightPostingSource::next The PostingSource starts before
the first entry in the list, so next(), skip_to() or check() must be
called before any methods which need the context of the current
position.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Parameters:
-----------

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")  Xapian::FixedWeightPostingSource::skip_to "

Advance to the specified docid.

void Xapian::FixedWeightPostingSource::skip_to(Xapian::docid
min_docid, double min_wt) override
Xapian::FixedWeightPostingSource::skip_to If the specified docid isn't
in the list, position ourselves on the first document after it (or
at_end() if no greater docids are present).

If the current position is already the specified docid, this method
will leave the position unmodified.

If the specified docid is earlier than the current position, the
behaviour is unspecified. A sensible behaviour would be to leave the
current position unmodified, but it is also reasonable to move to the
specified docid.

The default implementation calls next() repeatedly, which works but
skip_to() can often be implemented much more efficiently.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Note: in the case of a multi-database search, the docid specified is
the docid in the single subdatabase relevant to this posting source.
See the  reset() method for details.

Parameters:
-----------

did:  The document id to advance to.

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")  Xapian::FixedWeightPostingSource::check "

Check if the specified docid occurs.

bool Xapian::FixedWeightPostingSource::check(Xapian::docid min_docid,
double min_wt) override Xapian::FixedWeightPostingSource::check The
caller is required to ensure that the specified document id did
actually exists in the database. If it does, it must move to that
document id, and return true. If it does not, it may either:

return true, having moved to a definite position (including
\"at_end\"), which must be the same position as skip_to() would have
moved to.

or

return false, having moved to an \"indeterminate\" position, such that
a subsequent call to next() or skip_to() will move to the next
matching position after did.

Generally, this method should act like skip_to() and return true if
that can be done at little extra cost.

Otherwise it should simply check if a particular docid is present,
returning true if it is, and false if it isn't.

The default implementation calls skip_to() and always returns true.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Note: in the case of a multi-database search, the docid specified is
the docid in the single subdatabase relevant to this posting source.
See the  reset() method for details.

Parameters:
-----------

did:  The document id to check.

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")  Xapian::FixedWeightPostingSource::at_end "

Return true if the current position is past the last entry in this
list.

bool Xapian::FixedWeightPostingSource::at_end() const override
Xapian::FixedWeightPostingSource::at_end At least one of  next(),
skip_to() or  check() will be called before this method is first
called. ";

%feature("docstring")  Xapian::FixedWeightPostingSource::get_docid "

Return the current docid.

Xapian::docid Xapian::FixedWeightPostingSource::get_docid() const
override Xapian::FixedWeightPostingSource::get_docid This method may
assume that it will only be called when there is a \"current
document\". See  get_weight() for details.

Note: in the case of a multi-database search, the returned docid
should be in the single subdatabase relevant to this posting source.
See the  reset() method for details. ";

%feature("docstring")  Xapian::FixedWeightPostingSource::clone "

Clone the posting source.

FixedWeightPostingSource * Xapian::FixedWeightPostingSource::clone()
const override Xapian::FixedWeightPostingSource::clone The clone
should inherit the configuration of the parent, but need not inherit
the state. ie, the clone does not need to be in the same iteration
position as the original: the matcher will always call reset() on the
clone before attempting to move the iterator, or read the information
about the current position of the iterator.

This may return NULL to indicate that cloning is not supported. In
this case, the PostingSource may only be used with a single-database
search.

The default implementation returns NULL.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1 ";

%feature("docstring")  Xapian::FixedWeightPostingSource::name "

Name of the posting source class.

std::string Xapian::FixedWeightPostingSource::name() const override
Xapian::FixedWeightPostingSource::name This is used when serialising
and unserialising posting sources; for example, for performing remote
searches.

If the subclass is in a C++ namespace, the namespace should be
included in the name, using \"::\" as a separator. For example, for a
PostingSource subclass called \"FooPostingSource\" in the \"Xapian\"
namespace the result of this call should be
\"Xapian::FooPostingSource\".

This should only be implemented if serialise() and unserialise() are
also implemented. The default implementation returns an empty string.

If this returns an empty string, Xapian will assume that serialise()
and unserialise() are not implemented. ";

%feature("docstring")  Xapian::FixedWeightPostingSource::serialise "

Serialise object parameters into a string.

std::string Xapian::FixedWeightPostingSource::serialise() const
override Xapian::FixedWeightPostingSource::serialise The serialised
parameters should represent the configuration of the posting source,
but need not (indeed, should not) represent the current iteration
state.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.
";

%feature("docstring")  Xapian::FixedWeightPostingSource::unserialise "

Create object given string serialisation returned by serialise().

FixedWeightPostingSource *
Xapian::FixedWeightPostingSource::unserialise(const std::string
&serialised) const override
Xapian::FixedWeightPostingSource::unserialise Note that the returned
object will be deallocated by Xapian after use with \"delete\". If you
want to handle the deletion in a special way (for example when
wrapping the Xapian API for use from another language) then you can
define a static operator delete method in your subclass as shown
here:https://trac.xapian.org/ticket/554#comment:1

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Parameters:
-----------

serialised:  A serialised instance of this PostingSource subclass. ";

%feature("docstring")  Xapian::FixedWeightPostingSource::reset "

Set this PostingSource to the start of the list of postings.

void Xapian::FixedWeightPostingSource::reset(const Database &db_,
Xapian::doccount shard_index) override
Xapian::FixedWeightPostingSource::reset This is called automatically
by the matcher prior to each query being processed.

If a PostingSource is used for multiple searches,  reset() will
therefore be called multiple times, and must handle this by using the
database passed in the most recent call.

Parameters:
-----------

db:  The database which the PostingSource should iterate through.

shard_index:  The 0-based index indicating which shard in a multi-
database db is. This can be useful if you have an external source of
postings corresponding to each shard.

Note: in the case of a multi-database search, a separate PostingSource
will be used for each database (the separate PostingSources will be
obtained using  clone()), and each PostingSource will be passed one of
the sub-databases as the db parameter here. The db parameter will
therefore always refer to a single database. All docids passed to, or
returned from, the PostingSource refer to docids in that single
database, rather than in the multi- database.

A default implementation is provided which calls the older init()
method to allow existing subclasses to continue to work, but the
default implementation of init() throws Xapian::InvalidOperationError
so you must override either this method or init(). In new code,
override this method in preference.

Added in Xapian 2.0.0. ";

%feature("docstring")
Xapian::FixedWeightPostingSource::get_description "

Return a string describing this object.

std::string Xapian::FixedWeightPostingSource::get_description() const
override Xapian::FixedWeightPostingSource::get_description This
default implementation returns a generic answer. This default it
provided to avoid forcing those deriving their own PostingSource
subclass from having to implement this (they may not care what
get_description() gives for their subclass). ";


// File: classXapian_1_1FreqSource.xml
%feature("docstring") Xapian::FreqSource "

Base class for TermListGroup Stores and provides terms that are
contained in a document and their respective term frequencies. ";

%feature("docstring")  Xapian::FreqSource::FreqSource "

Default constructor.

Xapian::FreqSource::FreqSource() Xapian::FreqSource::FreqSource";

%feature("docstring")  Xapian::FreqSource::~FreqSource "

Destructor.

virtual Xapian::FreqSource::~FreqSource()
Xapian::FreqSource::~FreqSource";

%feature("docstring")  Xapian::FreqSource::get_termfreq "

Return the term frequency of a particular term 'tname'.

virtual doccount Xapian::FreqSource::get_termfreq(const std::string
&tname) const =0 Xapian::FreqSource::get_termfreq

Parameters:
-----------

tname:  The term for which to return the term frequency ";

%feature("docstring")  Xapian::FreqSource::get_doccount "

Return the number of documents within the MSet.

virtual doccount Xapian::FreqSource::get_doccount() const =0
Xapian::FreqSource::get_doccount";

%feature("docstring")  Xapian::FreqSource::release "

Start reference counting this object.

FreqSource * Xapian::FreqSource::release() Xapian::FreqSource::release
You can transfer ownership of a dynamically allocated FreqSource
object to Xapian by calling release() and then passing the object to a
Xapian method. Xapian will arrange to delete the object once it is no
longer required. ";

%feature("docstring")  Xapian::FreqSource::release "

Start reference counting this object.

const FreqSource * Xapian::FreqSource::release() const
Xapian::FreqSource::release You can transfer ownership of a
dynamically allocated FreqSource object to Xapian by calling release()
and then passing the object to a Xapian method. Xapian will arrange to
delete the object once it is no longer required. ";


// File: classXapian_1_1GreatCircleMetric.xml
%feature("docstring") Xapian::GreatCircleMetric "

Calculate the great-circle distance between two coordinates on a
sphere.

Experimental - seehttps://xapian.org/docs/deprecation#experimental-
features

This uses the haversine formula to calculate the distance. Note that
this formula is subject to inaccuracy due to numerical errors for
coordinates on the opposite side of the sphere.

Seehttps://en.wikipedia.org/wiki/Haversine_formula ";

%feature("docstring")  Xapian::GreatCircleMetric::GreatCircleMetric "

Construct a GreatCircleMetric.

Xapian::GreatCircleMetric::GreatCircleMetric()
Xapian::GreatCircleMetric::GreatCircleMetric The (quadratic mean)
radius of the Earth will be used by this calculator. ";

%feature("docstring")  Xapian::GreatCircleMetric::GreatCircleMetric "

Construct a GreatCircleMetric using a specified radius.

Xapian::GreatCircleMetric::GreatCircleMetric(double radius_)
Xapian::GreatCircleMetric::GreatCircleMetric This is useful for data
sets in which the points are not on Earth (eg, a database of features
on Mars).

Parameters:
-----------

radius_:  The radius of the sphere to use, in metres. ";

%feature("docstring")  Xapian::GreatCircleMetric::pointwise_distance "

Return the great-circle distance between points on the sphere.

double Xapian::GreatCircleMetric::pointwise_distance(const
LatLongCoord &a, const LatLongCoord &b) const
Xapian::GreatCircleMetric::pointwise_distance";

%feature("docstring")  Xapian::GreatCircleMetric::clone "

Clone the metric.

LatLongMetric * Xapian::GreatCircleMetric::clone() const
Xapian::GreatCircleMetric::clone";

%feature("docstring")  Xapian::GreatCircleMetric::name "

Return the full name of the metric.

std::string Xapian::GreatCircleMetric::name() const
Xapian::GreatCircleMetric::name This is used when serialising and
unserialising metrics; for example, for performing remote searches.

If the subclass is in a C++ namespace, the namespace should be
included in the name, using \"::\" as a separator. For example, for a
LatLongMetric subclass called \"FooLatLongMetric\" in the \"Xapian\"
namespace the result of this call should be
\"Xapian::FooLatLongMetric\". ";

%feature("docstring")  Xapian::GreatCircleMetric::serialise "

Serialise object parameters into a string.

std::string Xapian::GreatCircleMetric::serialise() const
Xapian::GreatCircleMetric::serialise The serialised parameters should
represent the configuration of the metric. ";

%feature("docstring")  Xapian::GreatCircleMetric::unserialise "

Create object given string serialisation returned by serialise().

LatLongMetric * Xapian::GreatCircleMetric::unserialise(const
std::string &serialised) const Xapian::GreatCircleMetric::unserialise

Parameters:
-----------

serialised:  A serialised instance of this LatLongMetric subclass. ";


// File: classXapian_1_1IfB2Weight.xml
%feature("docstring") Xapian::IfB2Weight "

This class implements the IfB2 weighting scheme.

IfB2 is a representative scheme of the Divergence from Randomness
Framework by Gianni Amati.

It uses the Inverse term frequency model (If), the Bernoulli method to
find the aftereffect of sampling (B) and the second wdf normalization
proposed by Amati to normalize the wdf in the document to the length
of the document (H2).

For more information about the DFR Framework and the IfB2 scheme,
please refer to: Gianni Amati and Cornelis Joost Van Rijsbergen
Probabilistic models of information retrieval based on measuring the
divergence from randomness ACM Transactions on Information Systems
(TOIS) 20, (4), 2002, pp. 357-389. ";

%feature("docstring")  Xapian::IfB2Weight::IfB2Weight "

Construct an IfB2Weight.

Xapian::IfB2Weight::IfB2Weight(double c)
Xapian::IfB2Weight::IfB2Weight

Parameters:
-----------

c:  A strictly positive parameter controlling the extent of the
normalization of the wdf to the document length. The default value of
1 is suitable for longer queries but it may need to be changed for
shorter queries. For more information, please refer to Gianni Amati's
PHD thesis titled Probabilistic Models for Information Retrieval based
on Divergence from Randomness. ";

%feature("docstring")  Xapian::IfB2Weight::IfB2Weight "Xapian::IfB2Weight::IfB2Weight() Xapian::IfB2Weight::IfB2Weight";

%feature("docstring")  Xapian::IfB2Weight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::IfB2Weight::name() const Xapian::IfB2Weight::name
\"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::IfB2Weight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::IfB2Weight::serialise() const
Xapian::IfB2Weight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::IfB2Weight::unserialise "

Unserialise parameters.

IfB2Weight * Xapian::IfB2Weight::unserialise(const std::string
&serialised) const Xapian::IfB2Weight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::IfB2Weight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::IfB2Weight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterm,
Xapian::termcount wdfdocmax) const Xapian::IfB2Weight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::IfB2Weight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::IfB2Weight::get_maxpart() const
Xapian::IfB2Weight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::IfB2Weight::create_from_parameters "

Create from a human-readable parameter string.

IfB2Weight * Xapian::IfB2Weight::create_from_parameters(const char
*params) const Xapian::IfB2Weight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1IneB2Weight.xml
%feature("docstring") Xapian::IneB2Weight "

This class implements the IneB2 weighting scheme.

IneB2 is a representative scheme of the Divergence from Randomness
Framework by Gianni Amati.

It uses the Inverse expected document frequency model (Ine), the
Bernoulli method to find the aftereffect of sampling (B) and the
second wdf normalization proposed by Amati to normalize the wdf in the
document to the length of the document (H2).

For more information about the DFR Framework and the IneB2 scheme,
please refer to: Gianni Amati and Cornelis Joost Van Rijsbergen
Probabilistic models of information retrieval based on measuring the
divergence from randomness ACM Transactions on Information Systems
(TOIS) 20, (4), 2002, pp. 357-389. ";

%feature("docstring")  Xapian::IneB2Weight::IneB2Weight "

Construct an IneB2Weight.

Xapian::IneB2Weight::IneB2Weight(double c)
Xapian::IneB2Weight::IneB2Weight

Parameters:
-----------

c:  A strictly positive parameter controlling the extent of the
normalization of the wdf to the document length. The default value of
1 is suitable for longer queries but it may need to be changed for
shorter queries. For more information, please refer to Gianni Amati's
PHD thesis. ";

%feature("docstring")  Xapian::IneB2Weight::IneB2Weight "Xapian::IneB2Weight::IneB2Weight() Xapian::IneB2Weight::IneB2Weight";

%feature("docstring")  Xapian::IneB2Weight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::IneB2Weight::name() const
Xapian::IneB2Weight::name \"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::IneB2Weight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::IneB2Weight::serialise() const
Xapian::IneB2Weight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::IneB2Weight::unserialise "

Unserialise parameters.

IneB2Weight * Xapian::IneB2Weight::unserialise(const std::string
&serialised) const Xapian::IneB2Weight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::IneB2Weight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::IneB2Weight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterms,
Xapian::termcount wdfdocmax) const Xapian::IneB2Weight::get_sumpart
The parameters give information about the document which may be used
in the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::IneB2Weight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::IneB2Weight::get_maxpart() const
Xapian::IneB2Weight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::IneB2Weight::create_from_parameters "

Create from a human-readable parameter string.

IneB2Weight * Xapian::IneB2Weight::create_from_parameters(const char
*params) const Xapian::IneB2Weight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1InL2Weight.xml
%feature("docstring") Xapian::InL2Weight "

This class implements the InL2 weighting scheme.

InL2 is a representative scheme of the Divergence from Randomness
Framework by Gianni Amati.

This weighting scheme is useful for tasks that require early
precision.

It uses the Inverse document frequency model (In), the Laplace method
to find the aftereffect of sampling (L) and the second wdf
normalization proposed by Amati to normalize the wdf in the document
to the length of the document (H2).

For more information about the DFR Framework and the InL2 scheme,
please refer to: Gianni Amati and Cornelis Joost Van Rijsbergen
Probabilistic models of information retrieval based on measuring the
divergence from randomness ACM Transactions on Information Systems
(TOIS) 20, (4), 2002, pp. 357-389. ";

%feature("docstring")  Xapian::InL2Weight::InL2Weight "

Construct an InL2Weight.

Xapian::InL2Weight::InL2Weight(double c)
Xapian::InL2Weight::InL2Weight

Parameters:
-----------

c:  A strictly positive parameter controlling the extent of the
normalization of the wdf to the document length. The default value of
1 is suitable for longer queries but it may need to be changed for
shorter queries. For more information, please refer to Gianni Amati's
PHD thesis. ";

%feature("docstring")  Xapian::InL2Weight::InL2Weight "Xapian::InL2Weight::InL2Weight() Xapian::InL2Weight::InL2Weight";

%feature("docstring")  Xapian::InL2Weight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::InL2Weight::name() const Xapian::InL2Weight::name
\"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::InL2Weight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::InL2Weight::serialise() const
Xapian::InL2Weight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::InL2Weight::unserialise "

Unserialise parameters.

InL2Weight * Xapian::InL2Weight::unserialise(const std::string
&serialised) const Xapian::InL2Weight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::InL2Weight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::InL2Weight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterms,
Xapian::termcount wdfdocmax) const Xapian::InL2Weight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::InL2Weight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::InL2Weight::get_maxpart() const
Xapian::InL2Weight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::InL2Weight::create_from_parameters "

Create from a human-readable parameter string.

InL2Weight * Xapian::InL2Weight::create_from_parameters(const char
*params) const Xapian::InL2Weight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1Query_1_1Internal.xml


// File: structXapian_1_1ValueCountMatchSpy_1_1Internal.xml


// File: classXapian_1_1InternalError.xml
%feature("docstring") Xapian::InternalError "

InternalError indicates a runtime problem of some sort. ";

%feature("docstring")  Xapian::InternalError::InternalError "

General purpose constructor.

Xapian::InternalError::InternalError(std::string_view msg_,
std::string_view context_={}, int errno_=0)
Xapian::InternalError::InternalError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")  Xapian::InternalError::InternalError "

Construct from message and errno value.

Xapian::InternalError::InternalError(std::string_view msg_, int
errno_) Xapian::InternalError::InternalError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1InvalidArgumentError.xml
%feature("docstring") Xapian::InvalidArgumentError "

InvalidArgumentError indicates an invalid parameter value was passed
to the API. ";

%feature("docstring")
Xapian::InvalidArgumentError::InvalidArgumentError "

General purpose constructor.

Xapian::InvalidArgumentError::InvalidArgumentError(std::string_view
msg_, std::string_view context_={}, int errno_=0)
Xapian::InvalidArgumentError::InvalidArgumentError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")
Xapian::InvalidArgumentError::InvalidArgumentError "

Construct from message and errno value.

Xapian::InvalidArgumentError::InvalidArgumentError(std::string_view
msg_, int errno_) Xapian::InvalidArgumentError::InvalidArgumentError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1InvalidOperationError.xml
%feature("docstring") Xapian::InvalidOperationError "

InvalidOperationError indicates the API was used in an invalid way. ";

%feature("docstring")
Xapian::InvalidOperationError::InvalidOperationError "

General purpose constructor.

Xapian::InvalidOperationError::InvalidOperationError(std::string_view
msg_, std::string_view context_={}, int errno_=0)
Xapian::InvalidOperationError::InvalidOperationError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")
Xapian::InvalidOperationError::InvalidOperationError "

Construct from message and errno value.

Xapian::InvalidOperationError::InvalidOperationError(std::string_view
msg_, int errno_) Xapian::InvalidOperationError::InvalidOperationError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1InvertedQuery__.xml


// File: classXapian_1_1KeyMaker.xml
%feature("docstring") Xapian::KeyMaker "

Virtual base class for key making functors. ";

%feature("docstring")  Xapian::KeyMaker::KeyMaker "

Default constructor.

Xapian::KeyMaker::KeyMaker() Xapian::KeyMaker::KeyMaker";

%feature("docstring")  Xapian::KeyMaker::~KeyMaker "

Virtual destructor, because we have virtual methods.

virtual Xapian::KeyMaker::~KeyMaker() Xapian::KeyMaker::~KeyMaker";

%feature("docstring")  Xapian::KeyMaker::name "

Return the name of this KeyMaker.

virtual std::string Xapian::KeyMaker::name() const
Xapian::KeyMaker::name This name is used by the remote backend. It is
passed with the serialised parameters to the remote server so that it
knows which class to create.

Return the full namespace-qualified name of your class here - if your
class is called MyApp::FooKeyMaker, return \"MyApp::FooKeyMaker\" from
this method.

If you don't want to support the remote backend in your KeyMaker, you
can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::KeyMaker::serialise "

Return this object's parameters serialised as a single string.

virtual std::string Xapian::KeyMaker::serialise() const
Xapian::KeyMaker::serialise If there are no parameters, just return an
empty string.

If you don't want to support the remote backend in your KeyMaker, you
can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::KeyMaker::unserialise "

Unserialise parameters.

virtual KeyMaker * Xapian::KeyMaker::unserialise(const std::string
&serialised, const Registry &context) const
Xapian::KeyMaker::unserialise This method unserialises parameters
serialised by the  serialise() method and allocates and returns a new
object initialised with them.

If you don't want to support the remote backend in your KeyMaker, you
can use the default implementation which simply throws
Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised results.

context:   Registry object to use for unserialisation to permit
KeyMaker subclasses with sub-KeyMaker objects to be implemented. ";

%feature("docstring")  Xapian::KeyMaker::release "

Start reference counting this object.

KeyMaker * Xapian::KeyMaker::release() Xapian::KeyMaker::release You
can transfer ownership of a dynamically allocated KeyMaker object to
Xapian by calling release() and then passing the object to a Xapian
method. Xapian will arrange to delete the object once it is no longer
required. ";

%feature("docstring")  Xapian::KeyMaker::release "

Start reference counting this object.

const KeyMaker * Xapian::KeyMaker::release() const
Xapian::KeyMaker::release You can transfer ownership of a dynamically
allocated KeyMaker object to Xapian by calling release() and then
passing the object to a Xapian method. Xapian will arrange to delete
the object once it is no longer required. ";


// File: structXapian_1_1MultiValueKeyMaker_1_1KeySpec.xml


// File: classXapian_1_1KMeans.xml
%feature("docstring") Xapian::KMeans "

Kmeans clusterer: This clusterer implements the K-Means clustering
algorithm. ";

%feature("docstring")  Xapian::KMeans::KMeans "

Constructor specifying number of clusters and maximum iterations.

Xapian::KMeans::KMeans(unsigned int k_, unsigned int max_iters_=0)
Xapian::KMeans::KMeans

Parameters:
-----------

k_:  Number of required clusters

max_iters_:  The maximum number of iterations for which KMeans will
run if it doesn't converge ";

%feature("docstring")  Xapian::KMeans::cluster "

Implements the KMeans clustering algorithm.

ClusterSet Xapian::KMeans::cluster(const MSet &mset) override
Xapian::KMeans::cluster

Parameters:
-----------

mset:   MSet object containing the documents that are to be clustered
";

%feature("docstring")  Xapian::KMeans::set_stopper "

Set the Xapian::Stopper object to be used for identifying stopwords.

void Xapian::KMeans::set_stopper(const Xapian::Stopper *stop=NULL)
Xapian::KMeans::set_stopper Stopwords are discarded while calculating
term frequency for terms.

Parameters:
-----------

stop:  The Stopper object to set (default NULL, which means no
stopwords) ";

%feature("docstring")  Xapian::KMeans::get_description "

Return a string describing this object.

std::string Xapian::KMeans::get_description() const override
Xapian::KMeans::get_description";


// File: structXapian_1_1LatLongCoord.xml
%feature("docstring") Xapian::LatLongCoord "

A latitude-longitude coordinate.

Experimental - seehttps://xapian.org/docs/deprecation#experimental-
features

Note that latitude-longitude coordinates are only precisely meaningful
if the datum used to define them is specified. This class ignores this
issue - it is up to the caller to ensure that the datum used for each
coordinate in a system is consistent. ";

%feature("docstring")  Xapian::LatLongCoord::LatLongCoord "

Construct an uninitialised coordinate.

Xapian::LatLongCoord::LatLongCoord() noexcept
Xapian::LatLongCoord::LatLongCoord";

%feature("docstring")  Xapian::LatLongCoord::LatLongCoord "

Construct a coordinate.

Xapian::LatLongCoord::LatLongCoord(double latitude_, double
longitude_) Xapian::LatLongCoord::LatLongCoord If the supplied
longitude is out of the standard range, it will be normalised to the
range 0 <= longitude < 360.

If you want to avoid the checks (for example, you know that your
values are already in range), you can use the alternate constructor to
construct an uninitialised coordinate, and then set the latitude and
longitude directly.

Parameters:
-----------

InvalidArgumentError:  the supplied latitude is out of range. ";

%feature("docstring")  Xapian::LatLongCoord::unserialise "

Unserialise a string and set this object to its coordinate.

void Xapian::LatLongCoord::unserialise(std::string_view serialised)
Xapian::LatLongCoord::unserialise

Parameters:
-----------

serialised:  the string to unserialise the coordinate from.

Parameters:
-----------

Xapian::SerialisationError:  if the string does not contain a valid
serialised latitude-longitude pair, or contains extra data at the end
of it. ";

%feature("docstring")  Xapian::LatLongCoord::unserialise "

Unserialise a buffer and set this object to its coordinate.

void Xapian::LatLongCoord::unserialise(const char **ptr, const char
*end) Xapian::LatLongCoord::unserialise The buffer may contain further
data after that for the coordinate.

Parameters:
-----------

ptr:  A pointer to the start of the string. This will be updated to
point to the end of the data representing the coordinate.

end:  A pointer to the end of the string.

Parameters:
-----------

Xapian::SerialisationError:  if the string does not start with a valid
serialised latitude- longitude pair. ";

%feature("docstring")  Xapian::LatLongCoord::serialise "

Return a serialised representation of the coordinate.

std::string Xapian::LatLongCoord::serialise() const
Xapian::LatLongCoord::serialise";

%feature("docstring")  Xapian::LatLongCoord::get_description "

Return a string describing this object.

std::string Xapian::LatLongCoord::get_description() const
Xapian::LatLongCoord::get_description";


// File: classXapian_1_1LatLongCoords.xml
%feature("docstring") Xapian::LatLongCoords "

A sequence of latitude-longitude coordinates.

Experimental - seehttps://xapian.org/docs/deprecation#experimental-
features ";

%feature("docstring")  Xapian::LatLongCoords::begin "

Get a begin iterator for the coordinates.

LatLongCoordsIterator Xapian::LatLongCoords::begin() const
Xapian::LatLongCoords::begin";

%feature("docstring")  Xapian::LatLongCoords::end "

Get an end iterator for the coordinates.

LatLongCoordsIterator Xapian::LatLongCoords::end() const
Xapian::LatLongCoords::end";

%feature("docstring")  Xapian::LatLongCoords::size "

Get the number of coordinates in the container.

size_t Xapian::LatLongCoords::size() const
Xapian::LatLongCoords::size";

%feature("docstring")  Xapian::LatLongCoords::empty "

Return true if and only if there are no coordinates in the container.

bool Xapian::LatLongCoords::empty() const
Xapian::LatLongCoords::empty";

%feature("docstring")  Xapian::LatLongCoords::append "

Append a coordinate to the end of the sequence.

void Xapian::LatLongCoords::append(const LatLongCoord &coord)
Xapian::LatLongCoords::append";

%feature("docstring")  Xapian::LatLongCoords::LatLongCoords "

Construct an empty container.

Xapian::LatLongCoords::LatLongCoords()
Xapian::LatLongCoords::LatLongCoords";

%feature("docstring")  Xapian::LatLongCoords::LatLongCoords "

Construct a container holding one coordinate.

Xapian::LatLongCoords::LatLongCoords(const LatLongCoord &coord)
Xapian::LatLongCoords::LatLongCoords";

%feature("docstring")  Xapian::LatLongCoords::unserialise "

Unserialise a string and set this object to the coordinates in it.

void Xapian::LatLongCoords::unserialise(std::string_view serialised)
Xapian::LatLongCoords::unserialise

Parameters:
-----------

serialised:  the string to unserialise the coordinates from.

Parameters:
-----------

Xapian::SerialisationError:  if the string does not contain a valid
serialised latitude-longitude pair, or contains junk at the end of it.
";

%feature("docstring")  Xapian::LatLongCoords::serialise "

Return a serialised form of the coordinate list.

std::string Xapian::LatLongCoords::serialise() const
Xapian::LatLongCoords::serialise";

%feature("docstring")  Xapian::LatLongCoords::get_description "

Return a string describing this object.

std::string Xapian::LatLongCoords::get_description() const
Xapian::LatLongCoords::get_description";


// File: classXapian_1_1LatLongCoordsIterator.xml
%feature("docstring") Xapian::LatLongCoordsIterator "

An iterator across the values in a LatLongCoords object.

Experimental - seehttps://xapian.org/docs/deprecation#experimental-
features ";

%feature("docstring")
Xapian::LatLongCoordsIterator::LatLongCoordsIterator "

Default constructor. Produces an uninitialised iterator.

Xapian::LatLongCoordsIterator::LatLongCoordsIterator()
Xapian::LatLongCoordsIterator::LatLongCoordsIterator";


// File: classXapian_1_1LatLongDistanceKeyMaker.xml
%feature("docstring") Xapian::LatLongDistanceKeyMaker "

KeyMaker subclass which sorts by distance from a latitude/longitude.

Experimental - seehttps://xapian.org/docs/deprecation#experimental-
features

Results are ordered by the distance from a fixed point, or list of
points, calculated according to the metric supplied. If multiple
points are supplied (either in the constructor, or in the coordinates
stored in a document), the closest pointwise distance is used.

If a document contains no coordinate stored in the specified slot, a
special value for the distance will be used. This defaults to a large
number, so that such results get a low rank, but may be specified by a
constructor parameter. ";

%feature("docstring")
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker "

Construct a LatLongDistanceKeyMaker.

Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker(Xapian::valueno
slot_, const LatLongCoords &centre_, const LatLongMetric &metric_,
double defdistance)
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker

Parameters:
-----------

slot_:  Value slot to use.

centre_:  List of points to calculate distance from (closest distance
is used).

metric_:   LatLongMetric to use.

defdistance:  Distance to use for docs with no value set. ";

%feature("docstring")
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker "

Construct a LatLongDistanceKeyMaker.

Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker(Xapian::valueno
slot_, const LatLongCoords &centre_, const LatLongMetric &metric_)
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker

Parameters:
-----------

slot_:  Value slot to use.

centre_:  List of points to calculate distance from (closest distance
is used).

metric_:   LatLongMetric to use.

Documents where no value is set are assumed to be a large distance
away. ";

%feature("docstring")
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker "

Construct a LatLongDistanceKeyMaker.

Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker(Xapian::valueno
slot_, const LatLongCoords &centre_)
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker

Parameters:
-----------

slot_:  Value slot to use.

centre_:  List of points to calculate distance from (closest distance
is used).

Xapian::GreatCircleMetric is used as the metric.

Documents where no value is set are assumed to be a large distance
away. ";

%feature("docstring")
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker "

Construct a LatLongDistanceKeyMaker.

Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker(Xapian::valueno
slot_, const LatLongCoord &centre_, const LatLongMetric &metric_,
double defdistance)
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker

Parameters:
-----------

slot_:  Value slot to use.

centre_:   Point to calculate distance from.

metric_:   LatLongMetric to use.

defdistance:  Distance to use for docs with no value set. ";

%feature("docstring")
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker "

Construct a LatLongDistanceKeyMaker.

Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker(Xapian::valueno
slot_, const LatLongCoord &centre_, const LatLongMetric &metric_)
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker

Parameters:
-----------

slot_:  Value slot to use.

centre_:   Point to calculate distance from.

metric_:   LatLongMetric to use.

Documents where no value is set are assumed to be a large distance
away. ";

%feature("docstring")
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker "

Construct a LatLongDistanceKeyMaker.

Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker(Xapian::valueno
slot_, const LatLongCoord &centre_)
Xapian::LatLongDistanceKeyMaker::LatLongDistanceKeyMaker

Parameters:
-----------

slot_:  Value slot to use.

centre_:   Point to calculate distance from.

Xapian::GreatCircleMetric is used as the metric.

Documents where no value is set are assumed to be a large distance
away. ";

%feature("docstring")
Xapian::LatLongDistanceKeyMaker::~LatLongDistanceKeyMaker "Xapian::LatLongDistanceKeyMaker::~LatLongDistanceKeyMaker()
Xapian::LatLongDistanceKeyMaker::~LatLongDistanceKeyMaker";


// File: classXapian_1_1LatLongDistancePostingSource.xml
%feature("docstring") Xapian::LatLongDistancePostingSource "

Posting source which returns a weight based on geospatial distance.

Experimental - seehttps://xapian.org/docs/deprecation#experimental-
features

Results are weighted by the distance from a fixed point, or list of
points, calculated according to the metric supplied. If multiple
points are supplied (either in the constructor, or in the coordinates
stored in a document), the closest pointwise distance is used.

Documents further away than a specified maximum range (or with no
location stored in the specified slot) will not be returned.

The weight returned is computed from the distance using the formula:

k1 * pow(distance + k1, -k2)

(Where k1 and k2 are (strictly) positive, floating point constants,
which default to 1000 and 1, respectively. Distance is measured in
metres, so this means that something at the centre gets a weight of
1.0, something 1km away gets a weight of 0.5, and something 3km away
gets a weight of 0.25, etc) ";

%feature("docstring")
Xapian::LatLongDistancePostingSource::LatLongDistancePostingSource "

Construct a new posting source which returns only documents within
range of one of the central coordinates.

Xapian::LatLongDistancePostingSource::LatLongDistancePostingSource(Xapian::valueno
slot_, const LatLongCoords &centre_, const LatLongMetric &metric_,
double max_range_=0.0, double k1_=1000.0, double k2_=1.0)
Xapian::LatLongDistancePostingSource::LatLongDistancePostingSource

Parameters:
-----------

slot_:  The value slot to read values from.

centre_:  The centre point to use for distance calculations.

metric_:  The metric to use for distance calculations.

max_range_:  The maximum distance for documents which are returned.

k1_:  The k1 constant to use in the weighting function.

k2_:  The k2 constant to use in the weighting function. ";

%feature("docstring")
Xapian::LatLongDistancePostingSource::LatLongDistancePostingSource "

Construct a new posting source which returns only documents within
range of one of the central coordinates.

Xapian::LatLongDistancePostingSource::LatLongDistancePostingSource(Xapian::valueno
slot_, const LatLongCoords &centre_, double max_range_=0.0, double
k1_=1000.0, double k2_=1.0)
Xapian::LatLongDistancePostingSource::LatLongDistancePostingSource

Parameters:
-----------

slot_:  The value slot to read values from.

centre_:  The centre point to use for distance calculations.

max_range_:  The maximum distance for documents which are returned.

k1_:  The k1 constant to use in the weighting function.

k2_:  The k2 constant to use in the weighting function.

Xapian::GreatCircleMetric is used as the metric. ";

%feature("docstring")
Xapian::LatLongDistancePostingSource::~LatLongDistancePostingSource "Xapian::LatLongDistancePostingSource::~LatLongDistancePostingSource()
Xapian::LatLongDistancePostingSource::~LatLongDistancePostingSource";

%feature("docstring")  Xapian::LatLongDistancePostingSource::next "

Advance the current position to the next matching document.

void Xapian::LatLongDistancePostingSource::next(double min_wt)
Xapian::LatLongDistancePostingSource::next The PostingSource starts
before the first entry in the list, so next(), skip_to() or check()
must be called before any methods which need the context of the
current position.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Parameters:
-----------

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")  Xapian::LatLongDistancePostingSource::skip_to "

Advance to the specified docid.

void Xapian::LatLongDistancePostingSource::skip_to(Xapian::docid
min_docid, double min_wt)
Xapian::LatLongDistancePostingSource::skip_to If the specified docid
isn't in the list, position ourselves on the first document after it
(or at_end() if no greater docids are present).

If the current position is already the specified docid, this method
will leave the position unmodified.

If the specified docid is earlier than the current position, the
behaviour is unspecified. A sensible behaviour would be to leave the
current position unmodified, but it is also reasonable to move to the
specified docid.

The default implementation calls next() repeatedly, which works but
skip_to() can often be implemented much more efficiently.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Note: in the case of a multi-database search, the docid specified is
the docid in the single subdatabase relevant to this posting source.
See the  reset() method for details.

Parameters:
-----------

did:  The document id to advance to.

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")  Xapian::LatLongDistancePostingSource::check "

Check if the specified docid occurs.

bool Xapian::LatLongDistancePostingSource::check(Xapian::docid
min_docid, double min_wt) Xapian::LatLongDistancePostingSource::check
The caller is required to ensure that the specified document id did
actually exists in the database. If it does, it must move to that
document id, and return true. If it does not, it may either:

return true, having moved to a definite position (including
\"at_end\"), which must be the same position as skip_to() would have
moved to.

or

return false, having moved to an \"indeterminate\" position, such that
a subsequent call to next() or skip_to() will move to the next
matching position after did.

Generally, this method should act like skip_to() and return true if
that can be done at little extra cost.

Otherwise it should simply check if a particular docid is present,
returning true if it is, and false if it isn't.

The default implementation calls skip_to() and always returns true.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Note: in the case of a multi-database search, the docid specified is
the docid in the single subdatabase relevant to this posting source.
See the  reset() method for details.

Parameters:
-----------

did:  The document id to check.

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")
Xapian::LatLongDistancePostingSource::get_weight "

Return the weight contribution for the current document.

double Xapian::LatLongDistancePostingSource::get_weight() const
Xapian::LatLongDistancePostingSource::get_weight This default
implementation always returns 0, for convenience when implementing
\"weight-less\" PostingSource subclasses.

This method may assume that it will only be called when there is a
\"current document\". In detail: Xapian will always call reset() on a
PostingSource before calling this for the first time. It will also
only call this if the PostingSource reports that it is pointing to a
valid document (ie, it will not call it before calling at least one of
next(), skip_to() or check(), and will ensure that the PostingSource
is not at the end by calling at_end()). ";

%feature("docstring")  Xapian::LatLongDistancePostingSource::clone "

Clone the posting source.

LatLongDistancePostingSource *
Xapian::LatLongDistancePostingSource::clone() const
Xapian::LatLongDistancePostingSource::clone The clone should inherit
the configuration of the parent, but need not inherit the state. ie,
the clone does not need to be in the same iteration position as the
original: the matcher will always call reset() on the clone before
attempting to move the iterator, or read the information about the
current position of the iterator.

This may return NULL to indicate that cloning is not supported. In
this case, the PostingSource may only be used with a single-database
search.

The default implementation returns NULL.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1 ";

%feature("docstring")  Xapian::LatLongDistancePostingSource::name "

Name of the posting source class.

std::string Xapian::LatLongDistancePostingSource::name() const
Xapian::LatLongDistancePostingSource::name This is used when
serialising and unserialising posting sources; for example, for
performing remote searches.

If the subclass is in a C++ namespace, the namespace should be
included in the name, using \"::\" as a separator. For example, for a
PostingSource subclass called \"FooPostingSource\" in the \"Xapian\"
namespace the result of this call should be
\"Xapian::FooPostingSource\".

This should only be implemented if serialise() and unserialise() are
also implemented. The default implementation returns an empty string.

If this returns an empty string, Xapian will assume that serialise()
and unserialise() are not implemented. ";

%feature("docstring")  Xapian::LatLongDistancePostingSource::serialise
"

Serialise object parameters into a string.

std::string Xapian::LatLongDistancePostingSource::serialise() const
Xapian::LatLongDistancePostingSource::serialise The serialised
parameters should represent the configuration of the posting source,
but need not (indeed, should not) represent the current iteration
state.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.
";

%feature("docstring")
Xapian::LatLongDistancePostingSource::unserialise_with_registry "

Create object given string serialisation returned by serialise().

LatLongDistancePostingSource *
Xapian::LatLongDistancePostingSource::unserialise_with_registry(const
std::string &serialised, const Registry &registry) const
Xapian::LatLongDistancePostingSource::unserialise_with_registry Note
that the returned object will be deallocated by Xapian after use with
\"delete\". If you want to handle the deletion in a special way (for
example when wrapping the Xapian API for use from another language)
then you can define a static operator delete method in your subclass
as shown here:https://trac.xapian.org/ticket/554#comment:1

This method is supplied with a Registry object, which can be used when
unserialising objects contained within the posting source. The default
implementation simply calls unserialise() which doesn't take the
Registry object, so you do not need to implement this method unless
you want to take advantage of the Registry object when unserialising.

Parameters:
-----------

serialised:  A serialised instance of this PostingSource subclass.

registry:  The Xapian::Registry object to use. ";

%feature("docstring")  Xapian::LatLongDistancePostingSource::reset "

Set this PostingSource to the start of the list of postings.

void Xapian::LatLongDistancePostingSource::reset(const Database &db_,
Xapian::doccount shard_index)
Xapian::LatLongDistancePostingSource::reset This is called
automatically by the matcher prior to each query being processed.

If a PostingSource is used for multiple searches,  reset() will
therefore be called multiple times, and must handle this by using the
database passed in the most recent call.

Parameters:
-----------

db:  The database which the PostingSource should iterate through.

shard_index:  The 0-based index indicating which shard in a multi-
database db is. This can be useful if you have an external source of
postings corresponding to each shard.

Note: in the case of a multi-database search, a separate PostingSource
will be used for each database (the separate PostingSources will be
obtained using  clone()), and each PostingSource will be passed one of
the sub-databases as the db parameter here. The db parameter will
therefore always refer to a single database. All docids passed to, or
returned from, the PostingSource refer to docids in that single
database, rather than in the multi- database.

A default implementation is provided which calls the older init()
method to allow existing subclasses to continue to work, but the
default implementation of init() throws Xapian::InvalidOperationError
so you must override either this method or init(). In new code,
override this method in preference.

Added in Xapian 2.0.0. ";

%feature("docstring")
Xapian::LatLongDistancePostingSource::get_description "

Return a string describing this object.

std::string Xapian::LatLongDistancePostingSource::get_description()
const Xapian::LatLongDistancePostingSource::get_description This
default implementation returns a generic answer. This default it
provided to avoid forcing those deriving their own PostingSource
subclass from having to implement this (they may not care what
get_description() gives for their subclass). ";


// File: classXapian_1_1LatLongMetric.xml
%feature("docstring") Xapian::LatLongMetric "

Base class for calculating distances between two lat/long coordinates.

Experimental - seehttps://xapian.org/docs/deprecation#experimental-
features ";

%feature("docstring")  Xapian::LatLongMetric::~LatLongMetric "

Destructor.

virtual Xapian::LatLongMetric::~LatLongMetric()
Xapian::LatLongMetric::~LatLongMetric";

%feature("docstring")  Xapian::LatLongMetric::pointwise_distance "

Return the distance between two coordinates, in metres.

virtual double Xapian::LatLongMetric::pointwise_distance(const
LatLongCoord &a, const LatLongCoord &b) const =0
Xapian::LatLongMetric::pointwise_distance";

%feature("docstring")  Xapian::LatLongMetric::clone "

Clone the metric.

virtual LatLongMetric * Xapian::LatLongMetric::clone() const =0
Xapian::LatLongMetric::clone";

%feature("docstring")  Xapian::LatLongMetric::name "

Return the full name of the metric.

virtual std::string Xapian::LatLongMetric::name() const =0
Xapian::LatLongMetric::name This is used when serialising and
unserialising metrics; for example, for performing remote searches.

If the subclass is in a C++ namespace, the namespace should be
included in the name, using \"::\" as a separator. For example, for a
LatLongMetric subclass called \"FooLatLongMetric\" in the \"Xapian\"
namespace the result of this call should be
\"Xapian::FooLatLongMetric\". ";

%feature("docstring")  Xapian::LatLongMetric::serialise "

Serialise object parameters into a string.

virtual std::string Xapian::LatLongMetric::serialise() const =0
Xapian::LatLongMetric::serialise The serialised parameters should
represent the configuration of the metric. ";

%feature("docstring")  Xapian::LatLongMetric::unserialise "

Create object given string serialisation returned by serialise().

virtual LatLongMetric * Xapian::LatLongMetric::unserialise(const
std::string &serialised) const =0 Xapian::LatLongMetric::unserialise

Parameters:
-----------

serialised:  A serialised instance of this LatLongMetric subclass. ";


// File: classXapian_1_1LCDClusterer.xml
%feature("docstring") Xapian::LCDClusterer "

LCD clusterer: This clusterer implements the LCD clustering algorithm
adapted from Modelling efficient novelty-based search result
diversification in metric spaces Gil-Costa et al.

2013 ";

%feature("docstring")  Xapian::LCDClusterer::LCDClusterer "

Constructor specifying number of clusters.

Xapian::LCDClusterer::LCDClusterer(unsigned int k_)
Xapian::LCDClusterer::LCDClusterer

Parameters:
-----------

k_:  Number of required clusters ";

%feature("docstring")  Xapian::LCDClusterer::cluster "

Implements the LCD clustering algorithm.

ClusterSet Xapian::LCDClusterer::cluster(const MSet &mset) override
Xapian::LCDClusterer::cluster

Parameters:
-----------

mset:   MSet object containing the documents that are to be clustered
";

%feature("docstring")  Xapian::LCDClusterer::get_description "

Return a string describing this object.

std::string Xapian::LCDClusterer::get_description() const override
Xapian::LCDClusterer::get_description";


// File: classXapian_1_1LM2StageWeight.xml
%feature("docstring") Xapian::LM2StageWeight "

Language Model weighting with Two Stage smoothing.

As described in:

Zhai, C., & Lafferty, J.D. (2004). A study of smoothing methods for
language models applied to information retrieval. ACM Trans. Inf.
Syst., 22, 179-214.

2.0.0 ";

%feature("docstring")  Xapian::LM2StageWeight::LM2StageWeight "

Construct a LM2StageWeight.

Xapian::LM2StageWeight::LM2StageWeight(double lambda=0.7, double
mu=2000.0) Xapian::LM2StageWeight::LM2StageWeight

Parameters:
-----------

lambda:  A parameter between 0 and 1 which linearly interpolates
between the maximum likelihood model (at 0) and the collection model
(at 1). Default: 0.7

mu:  A parameter which is greater than 0. Default: 2000 ";

%feature("docstring")  Xapian::LM2StageWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::LM2StageWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterm,
Xapian::termcount wdfdocmax) const Xapian::LM2StageWeight::get_sumpart
The parameters give information about the document which may be used
in the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::LM2StageWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::LM2StageWeight::get_maxpart() const
Xapian::LM2StageWeight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::LM2StageWeight::get_sumextra "

Calculate the term-independent weight component for a document.

double Xapian::LM2StageWeight::get_sumextra(Xapian::termcount doclen,
Xapian::termcount uniqterm, Xapian::termcount wdfdocmax) const
Xapian::LM2StageWeight::get_sumextra The default implementation always
returns 0 (in Xapian < 2.0.0 this was a pure virtual method).

The parameter gives information about the document which may be used
in the calculations:

Parameters:
-----------

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::LM2StageWeight::get_maxextra "

Return an upper bound on what get_sumextra() can return for any
document.

double Xapian::LM2StageWeight::get_maxextra() const
Xapian::LM2StageWeight::get_maxextra The default implementation always
returns 0 (in Xapian < 2.0.0 this was a pure virtual method).

This information is used by the matcher to perform various
optimisations, so strive to make the bound as tight as possible. ";

%feature("docstring")  Xapian::LM2StageWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::LM2StageWeight::name() const
Xapian::LM2StageWeight::name \"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::LM2StageWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::LM2StageWeight::serialise() const
Xapian::LM2StageWeight::serialise If you don't want to support the
remote backend, you can use the default implementation which simply
throws Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::LM2StageWeight::unserialise "

Unserialise parameters.

LM2StageWeight * Xapian::LM2StageWeight::unserialise(const std::string
&serialised) const Xapian::LM2StageWeight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::LM2StageWeight::create_from_parameters
"

Create from a human-readable parameter string.

LM2StageWeight * Xapian::LM2StageWeight::create_from_parameters(const
char *params) const Xapian::LM2StageWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1LMAbsDiscountWeight.xml
%feature("docstring") Xapian::LMAbsDiscountWeight "

Language Model weighting with Absolute Discount smoothing.

As described in:

Zhai, C., & Lafferty, J.D. (2004). A study of smoothing methods for
language models applied to information retrieval. ACM Trans. Inf.
Syst., 22, 179-214.

2.0.0 ";

%feature("docstring")
Xapian::LMAbsDiscountWeight::LMAbsDiscountWeight "

Construct a LMAbsDiscountWeight.

Xapian::LMAbsDiscountWeight::LMAbsDiscountWeight(double delta=0.7)
Xapian::LMAbsDiscountWeight::LMAbsDiscountWeight

Parameters:
-----------

delta:  A parameter between 0 and 1. Default: 0.7 ";

%feature("docstring")  Xapian::LMAbsDiscountWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::LMAbsDiscountWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount, Xapian::termcount uniqterm, Xapian::termcount
wdfdocmax) const Xapian::LMAbsDiscountWeight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::LMAbsDiscountWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::LMAbsDiscountWeight::get_maxpart() const
Xapian::LMAbsDiscountWeight::get_maxpart This information is used by
the matcher to perform various optimisations, so strive to make the
bound as tight as possible. ";

%feature("docstring")  Xapian::LMAbsDiscountWeight::get_sumextra "

Calculate the term-independent weight component for a document.

double Xapian::LMAbsDiscountWeight::get_sumextra(Xapian::termcount
doclen, Xapian::termcount, Xapian::termcount) const
Xapian::LMAbsDiscountWeight::get_sumextra The default implementation
always returns 0 (in Xapian < 2.0.0 this was a pure virtual method).

The parameter gives information about the document which may be used
in the calculations:

Parameters:
-----------

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::LMAbsDiscountWeight::get_maxextra "

Return an upper bound on what get_sumextra() can return for any
document.

double Xapian::LMAbsDiscountWeight::get_maxextra() const
Xapian::LMAbsDiscountWeight::get_maxextra The default implementation
always returns 0 (in Xapian < 2.0.0 this was a pure virtual method).

This information is used by the matcher to perform various
optimisations, so strive to make the bound as tight as possible. ";

%feature("docstring")  Xapian::LMAbsDiscountWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::LMAbsDiscountWeight::name() const
Xapian::LMAbsDiscountWeight::name \"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::LMAbsDiscountWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::LMAbsDiscountWeight::serialise() const
Xapian::LMAbsDiscountWeight::serialise If you don't want to support
the remote backend, you can use the default implementation which
simply throws Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::LMAbsDiscountWeight::unserialise "

Unserialise parameters.

LMAbsDiscountWeight * Xapian::LMAbsDiscountWeight::unserialise(const
std::string &serialised) const
Xapian::LMAbsDiscountWeight::unserialise This method unserialises
parameters serialised by the  serialise() method and allocates and
returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")
Xapian::LMAbsDiscountWeight::create_from_parameters "

Create from a human-readable parameter string.

LMAbsDiscountWeight *
Xapian::LMAbsDiscountWeight::create_from_parameters(const char
*params) const Xapian::LMAbsDiscountWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1LMDirichletWeight.xml
%feature("docstring") Xapian::LMDirichletWeight "

Language Model weighting with Dirichlet or Dir+ smoothing.

Dirichlet smoothing is as described in:

Zhai, C., & Lafferty, J.D. (2004). A study of smoothing methods for
language models applied to information retrieval. ACM Trans. Inf.
Syst., 22, 179-214.

Dir+ is described in:

Lv, Y., & Zhai, C. (2011). Lower-bounding term frequency
normalization. International Conference on Information and Knowledge
Management.

2.0.0 ";

%feature("docstring")  Xapian::LMDirichletWeight::LMDirichletWeight "

Construct a LMDirichletWeight.

Xapian::LMDirichletWeight::LMDirichletWeight(double mu=2000.0, double
delta=0.05) Xapian::LMDirichletWeight::LMDirichletWeight

Parameters:
-----------

mu:  A parameter which is > 0. Default: 2000

delta:  A parameter which is >= 0, which is \"a pseudo [wdf] value to
control the scale of the [wdf] lower bound\". If this parameter is >
0, then the smoothing is Dir+; if it's zero, it's Dirichlet. Default:
0.05 ";

%feature("docstring")  Xapian::LMDirichletWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::LMDirichletWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterm,
Xapian::termcount wdfdocmax) const
Xapian::LMDirichletWeight::get_sumpart The parameters give information
about the document which may be used in the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::LMDirichletWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::LMDirichletWeight::get_maxpart() const
Xapian::LMDirichletWeight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::LMDirichletWeight::get_sumextra "

Calculate the term-independent weight component for a document.

double Xapian::LMDirichletWeight::get_sumextra(Xapian::termcount
doclen, Xapian::termcount, Xapian::termcount) const
Xapian::LMDirichletWeight::get_sumextra The default implementation
always returns 0 (in Xapian < 2.0.0 this was a pure virtual method).

The parameter gives information about the document which may be used
in the calculations:

Parameters:
-----------

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::LMDirichletWeight::get_maxextra "

Return an upper bound on what get_sumextra() can return for any
document.

double Xapian::LMDirichletWeight::get_maxextra() const
Xapian::LMDirichletWeight::get_maxextra The default implementation
always returns 0 (in Xapian < 2.0.0 this was a pure virtual method).

This information is used by the matcher to perform various
optimisations, so strive to make the bound as tight as possible. ";

%feature("docstring")  Xapian::LMDirichletWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::LMDirichletWeight::name() const
Xapian::LMDirichletWeight::name \"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::LMDirichletWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::LMDirichletWeight::serialise() const
Xapian::LMDirichletWeight::serialise If you don't want to support the
remote backend, you can use the default implementation which simply
throws Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::LMDirichletWeight::unserialise "

Unserialise parameters.

LMDirichletWeight * Xapian::LMDirichletWeight::unserialise(const
std::string &serialised) const Xapian::LMDirichletWeight::unserialise
This method unserialises parameters serialised by the  serialise()
method and allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")
Xapian::LMDirichletWeight::create_from_parameters "

Create from a human-readable parameter string.

LMDirichletWeight *
Xapian::LMDirichletWeight::create_from_parameters(const char *params)
const Xapian::LMDirichletWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1LMJMWeight.xml
%feature("docstring") Xapian::LMJMWeight "

Language Model weighting with Jelinek-Mercer smoothing.

As described in:

Zhai, C., & Lafferty, J.D. (2004). A study of smoothing methods for
language models applied to information retrieval. ACM Trans. Inf.
Syst., 22, 179-214.

2.0.0 ";

%feature("docstring")  Xapian::LMJMWeight::LMJMWeight "

Construct a LMJMWeight.

Xapian::LMJMWeight::LMJMWeight(double lambda=0.0)
Xapian::LMJMWeight::LMJMWeight

Parameters:
-----------

lambda:  A parameter strictly between 0 and 1 which linearly
interpolates between the maximum likelihood model (the limit as λ→0)
and the collection model (the limit as λ→1).

Values of λ around 0.1 are apparently optimal for short queries and
around 0.7 for long queries. If lambda is out of range (i.e. <= 0 or
>= 1) then the λ value used is chosen dynamically based on the query
length using the formula:

(query_length - 1) / 10.0

The result is clamped to 0.1 for query_length <= 2, and to 0.7 for
query_length >= 8. ";

%feature("docstring")  Xapian::LMJMWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::LMJMWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterm,
Xapian::termcount wdfdocmax) const Xapian::LMJMWeight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::LMJMWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::LMJMWeight::get_maxpart() const
Xapian::LMJMWeight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::LMJMWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::LMJMWeight::name() const Xapian::LMJMWeight::name
\"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::LMJMWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::LMJMWeight::serialise() const
Xapian::LMJMWeight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::LMJMWeight::unserialise "

Unserialise parameters.

LMJMWeight * Xapian::LMJMWeight::unserialise(const std::string
&serialised) const Xapian::LMJMWeight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::LMJMWeight::create_from_parameters "

Create from a human-readable parameter string.

LMJMWeight * Xapian::LMJMWeight::create_from_parameters(const char
*params) const Xapian::LMJMWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1LogicError.xml
%feature("docstring") Xapian::LogicError "

The base class for exceptions indicating errors in the program logic.

A subclass of LogicError will be thrown if Xapian detects a violation
of a class invariant or a logical precondition or postcondition, etc.
";


// File: classXapian_1_1MatchDecider.xml
%feature("docstring") Xapian::MatchDecider "

Abstract base class for match deciders. ";

%feature("docstring")  Xapian::MatchDecider::MatchDecider "

Default constructor, needed by subclass constructors.

Xapian::MatchDecider::MatchDecider() noexcept
Xapian::MatchDecider::MatchDecider";

%feature("docstring")  Xapian::MatchDecider::~MatchDecider "

Virtual destructor, because we have virtual methods.

virtual Xapian::MatchDecider::~MatchDecider()
Xapian::MatchDecider::~MatchDecider";


// File: classXapian_1_1MatchSpy.xml
%feature("docstring") Xapian::MatchSpy "

Abstract base class for match spies.

The subclasses will generally accumulate information seen during the
match, to calculate aggregate functions, or other profiles of the
matching documents. ";

%feature("docstring")  Xapian::MatchSpy::MatchSpy "

Default constructor, needed by subclass constructors.

Xapian::MatchSpy::MatchSpy() noexcept Xapian::MatchSpy::MatchSpy";

%feature("docstring")  Xapian::MatchSpy::~MatchSpy "

Virtual destructor, because we have virtual methods.

virtual Xapian::MatchSpy::~MatchSpy() Xapian::MatchSpy::~MatchSpy";

%feature("docstring")  Xapian::MatchSpy::clone "

Clone the match spy.

virtual MatchSpy * Xapian::MatchSpy::clone() const
Xapian::MatchSpy::clone The clone should inherit the configuration of
the parent, but need not inherit the state. ie, the clone does not
need to be passed information about the results seen by the parent.

If you don't want to support the remote backend in your match spy, you
can use the default implementation which simply throws
Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1 ";

%feature("docstring")  Xapian::MatchSpy::name "

Return the name of this match spy.

virtual std::string Xapian::MatchSpy::name() const
Xapian::MatchSpy::name This name is used by the remote backend. It is
passed with the serialised parameters to the remote server so that it
knows which class to create.

Return the full namespace-qualified name of your class here - if your
class is called MyApp::FooMatchSpy, return \"MyApp::FooMatchSpy\" from
this method.

If you don't want to support the remote backend in your match spy, you
can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::MatchSpy::serialise "

Return this object's parameters serialised as a single string.

virtual std::string Xapian::MatchSpy::serialise() const
Xapian::MatchSpy::serialise If you don't want to support the remote
backend in your match spy, you can use the default implementation
which simply throws Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::MatchSpy::unserialise "

Unserialise parameters.

virtual MatchSpy * Xapian::MatchSpy::unserialise(const std::string
&serialised, const Registry &context) const
Xapian::MatchSpy::unserialise This method unserialises parameters
serialised by the  serialise() method and allocates and returns a new
object initialised with them.

If you don't want to support the remote backend in your match spy, you
can use the default implementation which simply throws
Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised results.

context:   Registry object to use for unserialisation to permit
MatchSpy subclasses with sub-MatchSpy objects to be implemented. ";

%feature("docstring")  Xapian::MatchSpy::serialise_results "

Serialise the results of this match spy.

virtual std::string Xapian::MatchSpy::serialise_results() const
Xapian::MatchSpy::serialise_results If you don't want to support the
remote backend in your match spy, you can use the default
implementation which simply throws Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::MatchSpy::merge_results "

Unserialise some results, and merge them into this matchspy.

virtual void Xapian::MatchSpy::merge_results(const std::string
&serialised) Xapian::MatchSpy::merge_results The order in which
results are merged should not be significant, since this order is not
specified (and will vary depending on the speed of the search in each
sub-database).

If you don't want to support the remote backend in your match spy, you
can use the default implementation which simply throws
Xapian::UnimplementedError.

Parameters:
-----------

serialised:  A string containing the serialised results. ";

%feature("docstring")  Xapian::MatchSpy::get_description "

Return a string describing this object.

virtual std::string Xapian::MatchSpy::get_description() const
Xapian::MatchSpy::get_description This default implementation returns
a generic answer, to avoid forcing those deriving their own MatchSpy
subclasses from having to implement this (they may not care what
get_description() gives for their subclass). ";

%feature("docstring")  Xapian::MatchSpy::release "

Start reference counting this object.

MatchSpy * Xapian::MatchSpy::release() Xapian::MatchSpy::release You
can transfer ownership of a dynamically allocated MatchSpy object to
Xapian by calling release() and then passing the object to a Xapian
method. Xapian will arrange to delete the object once it is no longer
required. ";

%feature("docstring")  Xapian::MatchSpy::release "

Start reference counting this object.

const MatchSpy * Xapian::MatchSpy::release() const
Xapian::MatchSpy::release You can transfer ownership of a dynamically
allocated MatchSpy object to Xapian by calling release() and then
passing the object to a Xapian method. Xapian will arrange to delete
the object once it is no longer required. ";


// File: classXapian_1_1MSet.xml
%feature("docstring") Xapian::MSet "

Class representing a list of search results. ";

%feature("docstring")  Xapian::MSet::MSet "

Copying is allowed.

Xapian::MSet::MSet(const MSet &o) Xapian::MSet::MSet The internals are
reference counted, so copying is cheap. ";

%feature("docstring")  Xapian::MSet::MSet "

Move constructor.

Xapian::MSet::MSet(MSet &&o) Xapian::MSet::MSet";

%feature("docstring")  Xapian::MSet::MSet "

Default constructor.

Xapian::MSet::MSet() Xapian::MSet::MSet Creates an empty MSet, mostly
useful as a placeholder. ";

%feature("docstring")  Xapian::MSet::~MSet "

Destructor.

Xapian::MSet::~MSet() Xapian::MSet::~MSet";

%feature("docstring")  Xapian::MSet::replace_weights "

Assigns new weights and updates MSet.

void Xapian::MSet::replace_weights(Iterator first, Iterator last)
Xapian::MSet::replace_weights Dereferencing the Iterator should return
a double.

The weights returned by the iterator are assigned to elements of the
MSet in rank order.

Parameters:
-----------

begin:  Begin iterator.

end:  End iterator.

Parameters:
-----------

Xapian::InvalidArgument:  is thrown if the total number of elements in
the input doesn't match the total number of documents in MSet.

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::MSet::sort_by_relevance "

Sorts the list of documents in MSet according to their weights.

void Xapian::MSet::sort_by_relevance() Xapian::MSet::sort_by_relevance
Use after calling MSet::replace_weights.

This invalidates any MSetIterator objects active on this MSet.

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::MSet::convert_to_percent "

Convert a weight to a percentage.

int Xapian::MSet::convert_to_percent(double weight) const
Xapian::MSet::convert_to_percent The matching document with the
highest weight will get 100% if it matches all the weighted query
terms, and proportionally less if it only matches some, and other
weights are scaled by the same factor.

Documents with a non-zero score will always score at least 1%.

Note that these generally aren't percentages of anything meaningful
(unless you use a custom weighting formula where they are!) ";

%feature("docstring")  Xapian::MSet::convert_to_percent "

Convert the weight of the current iterator position to a percentage.

int Xapian::MSet::convert_to_percent(const MSetIterator &it) const
Xapian::MSet::convert_to_percent The matching document with the
highest weight will get 100% if it matches all the weighted query
terms, and proportionally less if it only matches some, and other
weights are scaled by the same factor.

Documents with a non-zero score will always score at least 1%.

Note that these generally aren't percentages of anything meaningful
(unless you use a custom weighting formula where they are!) ";

%feature("docstring")  Xapian::MSet::get_termfreq "

Get the termfreq of a term.

Xapian::doccount Xapian::MSet::get_termfreq(std::string_view term)
const Xapian::MSet::get_termfreq

The number of documents which term occurs in. This considers all
documents in the database being searched, so gives the same answer as
db.get_termfreq(term) (but is more efficient for query terms as it
returns a value cached during the search.)  Since 2.0.0, this method
returns 0 if called on an MSet which is not associated with a database
(which is consistent with Database::get_termfreq() returning 0 when
called on a Database with no sub-databases); in earlier versions,
Xapian::InvalidOperationError was thrown in this case. ";

%feature("docstring")  Xapian::MSet::get_termweight "

Get the term weight of a term.

double Xapian::MSet::get_termweight(std::string_view term) const
Xapian::MSet::get_termweight

The maximum weight that term could have contributed to a document.
Since 2.0.0, this method returns 0.0 if called on an MSet which is not
associated with a database, or with a term which wasn't present in the
query (since in both cases the term contributes no weight to any
matching documents); in earlier versions,
Xapian::InvalidOperationError was thrown for the first case, and
Xapian::InvalidArgumentError for the second. ";

%feature("docstring")  Xapian::MSet::get_firstitem "

Rank of first item in this MSet.

Xapian::doccount Xapian::MSet::get_firstitem() const
Xapian::MSet::get_firstitem This is the parameter first passed to
Xapian::Enquire::get_mset(). ";

%feature("docstring")  Xapian::MSet::get_matches_lower_bound "

Lower bound on the total number of matching documents.

Xapian::doccount Xapian::MSet::get_matches_lower_bound() const
Xapian::MSet::get_matches_lower_bound";

%feature("docstring")  Xapian::MSet::get_matches_estimated "

Estimate of the total number of matching documents.

Xapian::doccount Xapian::MSet::get_matches_estimated() const
Xapian::MSet::get_matches_estimated";

%feature("docstring")  Xapian::MSet::get_matches_upper_bound "

Upper bound on the total number of matching documents.

Xapian::doccount Xapian::MSet::get_matches_upper_bound() const
Xapian::MSet::get_matches_upper_bound";

%feature("docstring")
Xapian::MSet::get_uncollapsed_matches_lower_bound "

Lower bound on the total number of matching documents before
collapsing.

Xapian::doccount Xapian::MSet::get_uncollapsed_matches_lower_bound()
const Xapian::MSet::get_uncollapsed_matches_lower_bound Conceptually
the same as get_matches_lower_bound() for the same query without any
collapse part (though the actual value may differ). ";

%feature("docstring")  Xapian::MSet::get_uncollapsed_matches_estimated
"

Estimate of the total number of matching documents before collapsing.

Xapian::doccount Xapian::MSet::get_uncollapsed_matches_estimated()
const Xapian::MSet::get_uncollapsed_matches_estimated Conceptually the
same as get_matches_estimated() for the same query without any
collapse part (though the actual value may differ). ";

%feature("docstring")
Xapian::MSet::get_uncollapsed_matches_upper_bound "

Upper bound on the total number of matching documents before
collapsing.

Xapian::doccount Xapian::MSet::get_uncollapsed_matches_upper_bound()
const Xapian::MSet::get_uncollapsed_matches_upper_bound Conceptually
the same as get_matches_upper_bound() for the same query without any
collapse part (though the actual value may differ). ";

%feature("docstring")  Xapian::MSet::get_max_attained "

The maximum weight attained by any document.

double Xapian::MSet::get_max_attained() const
Xapian::MSet::get_max_attained";

%feature("docstring")  Xapian::MSet::get_max_possible "

The maximum possible weight any document could achieve.

double Xapian::MSet::get_max_possible() const
Xapian::MSet::get_max_possible";

%feature("docstring")  Xapian::MSet::snippet "

Generate a snippet.

std::string Xapian::MSet::snippet(std::string_view text, size_t
length=500, const Xapian::Stem &stemmer=Xapian::Stem(), unsigned
flags=SNIPPET_BACKGROUND_MODEL|SNIPPET_EXHAUSTIVE, std::string_view
hi_start=\"<b>\", std::string_view hi_end=\"</b>\", std::string_view
omit=\"...\") const Xapian::MSet::snippet This method selects a
continuous run of words from text, based mainly on where the query
matches (currently terms, exact phrases and wildcards are taken into
account). If flag SNIPPET_BACKGROUND_MODEL is used (which it is by
default) then the selection algorithm also considers the non-query
terms in the text with the aim of showing a context which provides
more useful information.

The size of the text selected can be controlled by the length
parameter, which specifies a number of bytes of text to aim to select.
However slightly more text may be selected. Also the size of any
escaping, highlighting or omission markers is not considered.

The returned text is escaped to make it suitable for use in HTML
(though beware that in upstream releases 1.4.5 and earlier this
escaping was sometimes incomplete), and matches with the query will be
highlighted using hi_start and hi_end.

If the snippet seems to start or end mid-sentence, then omit is
prepended or append (respectively) to indicate this.

The same stemming algorithm which was used to build the query should
be specified in stemmer.

And flags contains flags controlling behaviour.

Added in 1.3.5. ";

%feature("docstring")  Xapian::MSet::fetch "

Prefetch hint a range of items.

void Xapian::MSet::fetch(const MSetIterator &begin, const MSetIterator
&end) const Xapian::MSet::fetch For a remote database, this may start
a pipelined fetch of the requested documents from the remote server.

For a disk-based database, this may send prefetch hints to the
operating system such that the disk blocks the requested documents are
stored in are more likely to be in the cache when we come to actually
read them. ";

%feature("docstring")  Xapian::MSet::fetch "

Prefetch hint a single MSet item.

void Xapian::MSet::fetch(const MSetIterator &item) const
Xapian::MSet::fetch For a remote database, this may start a pipelined
fetch of the requested documents from the remote server.

For a disk-based database, this may send prefetch hints to the
operating system such that the disk blocks the requested documents are
stored in are more likely to be in the cache when we come to actually
read them. ";

%feature("docstring")  Xapian::MSet::fetch "

Prefetch hint the whole MSet.

void Xapian::MSet::fetch() const Xapian::MSet::fetch For a remote
database, this may start a pipelined fetch of the requested documents
from the remote server.

For a disk-based database, this may send prefetch hints to the
operating system such that the disk blocks the requested documents are
stored in are more likely to be in the cache when we come to actually
read them. ";

%feature("docstring")  Xapian::MSet::size "

Return number of items in this MSet object.

Xapian::doccount Xapian::MSet::size() const Xapian::MSet::size";

%feature("docstring")  Xapian::MSet::empty "

Return true if this MSet object is empty.

bool Xapian::MSet::empty() const Xapian::MSet::empty";

%feature("docstring")  Xapian::MSet::swap "

Efficiently swap this MSet object with another.

void Xapian::MSet::swap(MSet &o) Xapian::MSet::swap";

%feature("docstring")  Xapian::MSet::begin "

Return iterator pointing to the first item in this MSet.

MSetIterator Xapian::MSet::begin() const Xapian::MSet::begin";

%feature("docstring")  Xapian::MSet::end "

Return iterator pointing to just after the last item in this MSet.

MSetIterator Xapian::MSet::end() const Xapian::MSet::end";

%feature("docstring")  Xapian::MSet::back "

Return iterator pointing to the last object in this MSet.

MSetIterator Xapian::MSet::back() const Xapian::MSet::back";

%feature("docstring")  Xapian::MSet::get_description "

Return a string describing this object.

std::string Xapian::MSet::get_description() const
Xapian::MSet::get_description";


// File: classXapian_1_1MSetIterator.xml
%feature("docstring") Xapian::MSetIterator "

Iterator over a Xapian::MSet. ";

%feature("docstring")  Xapian::MSetIterator::MSetIterator "

Create an unpositioned MSetIterator.

Xapian::MSetIterator::MSetIterator()
Xapian::MSetIterator::MSetIterator";

%feature("docstring")  Xapian::MSetIterator::get_rank "

Return the MSet rank for the current position.

Xapian::doccount Xapian::MSetIterator::get_rank() const
Xapian::MSetIterator::get_rank The rank of mset[0] is
mset.get_firstitem(). ";

%feature("docstring")  Xapian::MSetIterator::get_document "

Get the Document object for the current position.

Xapian::Document Xapian::MSetIterator::get_document() const
Xapian::MSetIterator::get_document";

%feature("docstring")  Xapian::MSetIterator::get_weight "

Get the weight for the current position.

double Xapian::MSetIterator::get_weight() const
Xapian::MSetIterator::get_weight";

%feature("docstring")  Xapian::MSetIterator::get_collapse_key "

Return the collapse key for the current position.

std::string Xapian::MSetIterator::get_collapse_key() const
Xapian::MSetIterator::get_collapse_key If collapsing isn't in use, an
empty string will be returned. ";

%feature("docstring")  Xapian::MSetIterator::get_collapse_count "

Return a count of the number of collapses done onto the current key.

Xapian::doccount Xapian::MSetIterator::get_collapse_count() const
Xapian::MSetIterator::get_collapse_count This starts at 0, and is
incremented each time an item is eliminated because its key is the
same as that of the current item (as returned by get_collapse_key()).

Note that this is NOT necessarily one less than the total number of
matching documents with this collapse key due to various optimisations
implemented in the matcher - for example, it can skip documents
completely if it can prove their weight wouldn't be enough to make the
result set.

You can say is that if get_collapse_count() > 0 then there are >=
get_collapse_count() other documents with the current collapse key.
But if get_collapse_count() == 0 then there may or may not be other
such documents. ";

%feature("docstring")  Xapian::MSetIterator::get_sort_key "

Return the sort key for the current position.

std::string Xapian::MSetIterator::get_sort_key() const
Xapian::MSetIterator::get_sort_key If sorting didn't use a key then an
empty string will be returned.

Added in Xapian 1.4.6. ";

%feature("docstring")  Xapian::MSetIterator::get_percent "

Convert the weight of the current iterator position to a percentage.

int Xapian::MSetIterator::get_percent() const
Xapian::MSetIterator::get_percent The matching document with the
highest weight will get 100% if it matches all the weighted query
terms, and proportionally less if it only matches some, and other
weights are scaled by the same factor.

Documents with a non-zero score will always score at least 1%.

Note that these generally aren't percentages of anything meaningful
(unless you use a custom weighting formula where they are!) ";

%feature("docstring")  Xapian::MSetIterator::get_description "

Return a string describing this object.

std::string Xapian::MSetIterator::get_description() const
Xapian::MSetIterator::get_description";


// File: classXapian_1_1MultiValueKeyMaker.xml
%feature("docstring") Xapian::MultiValueKeyMaker "

KeyMaker subclass which combines several values.

When the result is used for sorting, results are ordered by the first
value. In the event of a tie, the second is used. If this is the same
for both, the third is used, and so on. If reverse is true for a
value, then the sort order for that value is reversed.

When used for collapsing, the documents will only be considered equal
if all the values specified match. If none of the specified values are
set then the generated key will be empty, so such documents won't be
collapsed (which is consistent with the behaviour in the \"collapse on
a value\" case). If you'd prefer that documents with none of the keys
set are collapsed together, then you can set reverse for at least one
of the values. Other than this, it isn't useful to set reverse for
collapsing. ";

%feature("docstring")  Xapian::MultiValueKeyMaker::MultiValueKeyMaker
"Xapian::MultiValueKeyMaker::MultiValueKeyMaker()
Xapian::MultiValueKeyMaker::MultiValueKeyMaker";

%feature("docstring")  Xapian::MultiValueKeyMaker::MultiValueKeyMaker
"

Construct a MultiValueKeyMaker from a pair of iterators.

Xapian::MultiValueKeyMaker::MultiValueKeyMaker(Iterator begin,
Iterator end) Xapian::MultiValueKeyMaker::MultiValueKeyMaker The
iterators must be a begin/end pair returning Xapian::valueno (or a
compatible type) when dereferenced. ";

%feature("docstring")  Xapian::MultiValueKeyMaker::add_value "

Add a value slot to the list to build a key from.

void Xapian::MultiValueKeyMaker::add_value(Xapian::valueno slot, bool
reverse=false, std::string_view defvalue={})
Xapian::MultiValueKeyMaker::add_value

Parameters:
-----------

slot:  The value slot to add

reverse:  Adjust values from this slot to reverse their sort order
(default: false)

defvalue:  Value to use for documents which don't have a value set in
this slot (default: empty). This can be used to make such documents
sort after all others by passing get_value_upper_bound(slot) + \"x\"
this is guaranteed to be greater than any value in this slot. ";

%feature("docstring")  Xapian::MultiValueKeyMaker::name "

Return the name of this KeyMaker.

std::string Xapian::MultiValueKeyMaker::name() const
Xapian::MultiValueKeyMaker::name This name is used by the remote
backend. It is passed with the serialised parameters to the remote
server so that it knows which class to create.

Return the full namespace-qualified name of your class here - if your
class is called MyApp::FooKeyMaker, return \"MyApp::FooKeyMaker\" from
this method.

If you don't want to support the remote backend in your KeyMaker, you
can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::MultiValueKeyMaker::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::MultiValueKeyMaker::serialise() const
Xapian::MultiValueKeyMaker::serialise If there are no parameters, just
return an empty string.

If you don't want to support the remote backend in your KeyMaker, you
can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::MultiValueKeyMaker::unserialise "

Unserialise parameters.

KeyMaker * Xapian::MultiValueKeyMaker::unserialise(const std::string
&serialised, const Registry &context) const
Xapian::MultiValueKeyMaker::unserialise This method unserialises
parameters serialised by the  serialise() method and allocates and
returns a new object initialised with them.

If you don't want to support the remote backend in your KeyMaker, you
can use the default implementation which simply throws
Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised results.

context:   Registry object to use for unserialisation to permit
KeyMaker subclasses with sub-KeyMaker objects to be implemented. ";


// File: classXapian_1_1NetworkError.xml
%feature("docstring") Xapian::NetworkError "

Indicates a problem communicating with a remote database. ";

%feature("docstring")  Xapian::NetworkError::NetworkError "

General purpose constructor.

Xapian::NetworkError::NetworkError(std::string_view msg_,
std::string_view context_={}, int errno_=0)
Xapian::NetworkError::NetworkError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")  Xapian::NetworkError::NetworkError "

Construct from message and errno value.

Xapian::NetworkError::NetworkError(std::string_view msg_, int errno_)
Xapian::NetworkError::NetworkError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1NetworkTimeoutError.xml
%feature("docstring") Xapian::NetworkTimeoutError "

Indicates a timeout expired while communicating with a remote
database. ";

%feature("docstring")
Xapian::NetworkTimeoutError::NetworkTimeoutError "

General purpose constructor.

Xapian::NetworkTimeoutError::NetworkTimeoutError(std::string_view
msg_, std::string_view context_={}, int errno_=0)
Xapian::NetworkTimeoutError::NetworkTimeoutError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")
Xapian::NetworkTimeoutError::NetworkTimeoutError "

Construct from message and errno value.

Xapian::NetworkTimeoutError::NetworkTimeoutError(std::string_view
msg_, int errno_) Xapian::NetworkTimeoutError::NetworkTimeoutError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1NumberRangeProcessor.xml
%feature("docstring") Xapian::NumberRangeProcessor "

Handle a number range.

This class must be used on values which have been encoded using
Xapian::sortable_serialise() which turns numbers into strings which
will sort in the same order as the numbers (the same values can be
used to implement a numeric sort). ";

%feature("docstring")
Xapian::NumberRangeProcessor::NumberRangeProcessor "

Constructor.

Xapian::NumberRangeProcessor::NumberRangeProcessor(Xapian::valueno
slot_, std::string_view str_={}, unsigned flags_=0)
Xapian::NumberRangeProcessor::NumberRangeProcessor

Parameters:
-----------

slot_:  The value slot number to query.

str_:  A string to look for to recognise values as belonging to this
numeric range.

flags_:  Zero or more of the following flags, combined with bitwise-
or: Xapian::RP_SUFFIX - require str_ as a suffix instead of a prefix.

Xapian::RP_REPEATED - optionally allow str_ on both ends of the range
- e.g. $1..$10 or 5m..50m. By default a prefix is only checked for on
the start (e.g. date:1/1/1980..31/12/1989), and a suffix only on the
end (e.g. 2..12kg).

The string supplied in str_ is used by operator() to decide whether
the pair of strings supplied to it constitute a valid range. If
prefix_ is true, the first value in a range must begin with str_ (and
the second value may optionally begin with str_); if prefix_ is false,
the second value in a range must end with str_ (and the first value
may optionally end with str_).

If str_ is empty, the setting of prefix_ is irrelevant, and no special
strings are required at the start or end of the strings defining the
range.

The remainder of both strings defining the endpoints must be valid
floating point numbers. (FIXME: define format recognised).

For example, if str_ is \"$\" and prefix_ is true, and the range
processor has been added to the queryparser, the queryparser will
accept \"$10..50\" or \"$10..$50\", but not \"10..50\" or \"10..$50\"
as valid ranges. If str_ is \"kg\" and prefix_ is false, the
queryparser will accept \"10..50kg\" or \"10kg..50kg\", but not
\"10..50\" or \"10kg..50\" as valid ranges. ";


// File: classXapian_1_1PL2PlusWeight.xml
%feature("docstring") Xapian::PL2PlusWeight "

Xapian::Weight subclass implementing the PL2+ probabilistic formula.
";

%feature("docstring")  Xapian::PL2PlusWeight::PL2PlusWeight "

Construct a PL2PlusWeight.

Xapian::PL2PlusWeight::PL2PlusWeight(double c, double delta)
Xapian::PL2PlusWeight::PL2PlusWeight

Parameters:
-----------

c:  A strictly positive parameter controlling the extent of the
normalization of the wdf to the document length. The default value of
1 is suitable for longer queries but it may need to be changed for
shorter queries. For more information, please refer to Gianni Amati's
PHD thesis titled Probabilistic Models for Information Retrieval based
on Divergence from Randomness.

delta:  A parameter for pseudo tf value to control the scale of the tf
lower bound. Delta(δ) should be a positive real number. It can be
tuned for example from 0.1 to 1.5 in increments of 0.1 or so.
Experiments have shown that PL2+ works effectively across collections
with a fixed δ = 0.8 (default 0.8) ";

%feature("docstring")  Xapian::PL2PlusWeight::PL2PlusWeight "Xapian::PL2PlusWeight::PL2PlusWeight()
Xapian::PL2PlusWeight::PL2PlusWeight";

%feature("docstring")  Xapian::PL2PlusWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::PL2PlusWeight::name() const
Xapian::PL2PlusWeight::name \"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::PL2PlusWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::PL2PlusWeight::serialise() const
Xapian::PL2PlusWeight::serialise If you don't want to support the
remote backend, you can use the default implementation which simply
throws Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::PL2PlusWeight::unserialise "

Unserialise parameters.

PL2PlusWeight * Xapian::PL2PlusWeight::unserialise(const std::string
&serialised) const Xapian::PL2PlusWeight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::PL2PlusWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::PL2PlusWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterms,
Xapian::termcount wdfdocmax) const Xapian::PL2PlusWeight::get_sumpart
The parameters give information about the document which may be used
in the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::PL2PlusWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::PL2PlusWeight::get_maxpart() const
Xapian::PL2PlusWeight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::PL2PlusWeight::create_from_parameters "

Create from a human-readable parameter string.

PL2PlusWeight * Xapian::PL2PlusWeight::create_from_parameters(const
char *params) const Xapian::PL2PlusWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1PL2Weight.xml
%feature("docstring") Xapian::PL2Weight "

This class implements the PL2 weighting scheme.

PL2 is a representative scheme of the Divergence from Randomness
Framework by Gianni Amati.

This weighting scheme is useful for tasks that require early
precision.

It uses the Poisson approximation of the Binomial Probabilistic
distribution (P) along with Stirling's approximation for the factorial
value, the Laplace method to find the aftereffect of sampling (L) and
the second wdf normalization proposed by Amati to normalize the wdf in
the document to the length of the document (H2).

For more information about the DFR Framework and the PL2 scheme,
please refer to : Gianni Amati and Cornelis Joost Van Rijsbergen
Probabilistic models of information retrieval based on measuring the
divergence from randomness ACM Transactions on Information Systems
(TOIS) 20, (4), 2002, pp. 357-389. ";

%feature("docstring")  Xapian::PL2Weight::PL2Weight "

Construct a PL2Weight.

Xapian::PL2Weight::PL2Weight(double c) Xapian::PL2Weight::PL2Weight

Parameters:
-----------

c:  A strictly positive parameter controlling the extent of the
normalization of the wdf to the document length. The default value of
1 is suitable for longer queries but it may need to be changed for
shorter queries. For more information, please refer to Gianni Amati's
PHD thesis titled Probabilistic Models for Information Retrieval based
on Divergence from Randomness. ";

%feature("docstring")  Xapian::PL2Weight::PL2Weight "Xapian::PL2Weight::PL2Weight() Xapian::PL2Weight::PL2Weight";

%feature("docstring")  Xapian::PL2Weight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::PL2Weight::name() const Xapian::PL2Weight::name
\"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::PL2Weight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::PL2Weight::serialise() const
Xapian::PL2Weight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::PL2Weight::unserialise "

Unserialise parameters.

PL2Weight * Xapian::PL2Weight::unserialise(const std::string
&serialised) const Xapian::PL2Weight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::PL2Weight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::PL2Weight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterms,
Xapian::termcount wdfdocmax) const Xapian::PL2Weight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::PL2Weight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::PL2Weight::get_maxpart() const
Xapian::PL2Weight::get_maxpart This information is used by the matcher
to perform various optimisations, so strive to make the bound as tight
as possible. ";

%feature("docstring")  Xapian::PL2Weight::create_from_parameters "

Create from a human-readable parameter string.

PL2Weight * Xapian::PL2Weight::create_from_parameters(const char
*params) const Xapian::PL2Weight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1Point.xml
%feature("docstring") Xapian::Point "

Class to represent a document as a point in the Vector Space Model. ";

%feature("docstring")  Xapian::Point::Point "

Constructor Initialise the point with terms and corresponding TF-IDF
weights.

Xapian::Point::Point(const FreqSource &freqsource, const Document
&document) Xapian::Point::Point

Parameters:
-----------

freqsource:   FreqSource object which provides the term frequencies.
It is used for TF-IDF weight calculations

document:  The Document object over which the Point object will be
initialised ";

%feature("docstring")  Xapian::Point::get_document "

Returns the document corresponding to this Point.

Document Xapian::Point::get_document() const
Xapian::Point::get_document";


// File: classXapian_1_1PointType.xml
%feature("docstring") Xapian::PointType "

Abstract class representing a point in the VSM. ";

%feature("docstring")  Xapian::PointType::PointType "

Default constructor.

Xapian::PointType::PointType() Xapian::PointType::PointType";

%feature("docstring")  Xapian::PointType::termlist_begin "

Return a TermIterator to the beginning of the termlist.

TermIterator Xapian::PointType::termlist_begin() const
Xapian::PointType::termlist_begin";

%feature("docstring")  Xapian::PointType::termlist_end "

Return a TermIterator to the end of the termlist.

TermIterator Xapian::PointType::termlist_end() const noexcept
Xapian::PointType::termlist_end";

%feature("docstring")  Xapian::PointType::contains "

Validate whether a certain term exists in the termlist or not by
performing a lookup operation in the existing values.

bool Xapian::PointType::contains(std::string_view term) const
Xapian::PointType::contains

Parameters:
-----------

term:  Term which is to be searched ";

%feature("docstring")  Xapian::PointType::get_weight "

Return the TF-IDF weight associated with a certain term.

double Xapian::PointType::get_weight(std::string_view term) const
Xapian::PointType::get_weight

Parameters:
-----------

term:  Term for which TF-IDF weight is returned ";

%feature("docstring")  Xapian::PointType::add_weight "

Add the weight 'weight' to the mapping of a term.

void Xapian::PointType::add_weight(std::string_view term, double
weight) Xapian::PointType::add_weight

Parameters:
-----------

term:  Term to which the weight is to be added

weight:   Weight which has to be added to the existing mapping of the
term ";

%feature("docstring")  Xapian::PointType::get_magnitude "

Return the pre-computed squared magnitude.

double Xapian::PointType::get_magnitude() const
Xapian::PointType::get_magnitude";

%feature("docstring")  Xapian::PointType::termlist_size "

Return the size of the termlist.

Xapian::termcount Xapian::PointType::termlist_size() const
Xapian::PointType::termlist_size";

%feature("docstring")  Xapian::PointType::release "

Start reference counting this object.

PointType * Xapian::PointType::release() Xapian::PointType::release
You can transfer ownership of a dynamically allocated PointType object
to Xapian by calling release() and then passing the object to a Xapian
method. Xapian will arrange to delete the object once it is no longer
required. ";

%feature("docstring")  Xapian::PointType::release "

Start reference counting this object.

const PointType * Xapian::PointType::release() const
Xapian::PointType::release You can transfer ownership of a dynamically
allocated PointType object to Xapian by calling release() and then
passing the object to a Xapian method. Xapian will arrange to delete
the object once it is no longer required. ";


// File: classXapian_1_1PositionIterator.xml
%feature("docstring") Xapian::PositionIterator "

Class for iterating over term positions. ";

%feature("docstring")  Xapian::PositionIterator::PositionIterator "

Copy constructor.

Xapian::PositionIterator::PositionIterator(const PositionIterator &o)
Xapian::PositionIterator::PositionIterator";

%feature("docstring")  Xapian::PositionIterator::PositionIterator "

Move constructor.

Xapian::PositionIterator::PositionIterator(PositionIterator &&o)
Xapian::PositionIterator::PositionIterator";

%feature("docstring")  Xapian::PositionIterator::PositionIterator "

Default constructor.

Xapian::PositionIterator::PositionIterator() noexcept
Xapian::PositionIterator::PositionIterator Creates an uninitialised
iterator, which can't be used before being assigned to, but is
sometimes syntactically convenient. ";

%feature("docstring")  Xapian::PositionIterator::~PositionIterator "

Destructor.

Xapian::PositionIterator::~PositionIterator()
Xapian::PositionIterator::~PositionIterator";

%feature("docstring")  Xapian::PositionIterator::skip_to "

Advance the iterator to term position termpos.

void Xapian::PositionIterator::skip_to(Xapian::termpos termpos)
Xapian::PositionIterator::skip_to

Parameters:
-----------

termpos:  The position to advance to. If this position isn't in the
stream being iterated, then the iterator is moved to the next term
position after it which is. ";

%feature("docstring")  Xapian::PositionIterator::get_description "

Return a string describing this object.

std::string Xapian::PositionIterator::get_description() const
Xapian::PositionIterator::get_description";


// File: classXapian_1_1PostingIterator.xml
%feature("docstring") Xapian::PostingIterator "

Class for iterating over a list of terms. ";

%feature("docstring")  Xapian::PostingIterator::PostingIterator "

Copy constructor.

Xapian::PostingIterator::PostingIterator(const PostingIterator &o)
Xapian::PostingIterator::PostingIterator";

%feature("docstring")  Xapian::PostingIterator::PostingIterator "

Move constructor.

Xapian::PostingIterator::PostingIterator(PostingIterator &&o)
Xapian::PostingIterator::PostingIterator";

%feature("docstring")  Xapian::PostingIterator::PostingIterator "

Default constructor.

Xapian::PostingIterator::PostingIterator() noexcept
Xapian::PostingIterator::PostingIterator Creates an uninitialised
iterator, which can't be used before being assigned to, but is
sometimes syntactically convenient. ";

%feature("docstring")  Xapian::PostingIterator::~PostingIterator "

Destructor.

Xapian::PostingIterator::~PostingIterator()
Xapian::PostingIterator::~PostingIterator";

%feature("docstring")  Xapian::PostingIterator::get_wdf "

Return the wdf for the document at the current position.

Xapian::termcount Xapian::PostingIterator::get_wdf() const
Xapian::PostingIterator::get_wdf";

%feature("docstring")  Xapian::PostingIterator::get_doclength "

Return the length of the document at the current position.

Xapian::termcount Xapian::PostingIterator::get_doclength() const
Xapian::PostingIterator::get_doclength";

%feature("docstring")  Xapian::PostingIterator::get_unique_terms "

Return the number of unique terms in the current document.

Xapian::termcount Xapian::PostingIterator::get_unique_terms() const
Xapian::PostingIterator::get_unique_terms";

%feature("docstring")  Xapian::PostingIterator::get_wdfdocmax "

Return the max_wdf in the current document.

Xapian::termcount Xapian::PostingIterator::get_wdfdocmax() const
Xapian::PostingIterator::get_wdfdocmax";

%feature("docstring")  Xapian::PostingIterator::positionlist_begin "

Return a PositionIterator for the current document.

PositionIterator Xapian::PostingIterator::positionlist_begin() const
Xapian::PostingIterator::positionlist_begin";

%feature("docstring")  Xapian::PostingIterator::positionlist_end "

Return an end PositionIterator for the current document.

PositionIterator Xapian::PostingIterator::positionlist_end() const
noexcept Xapian::PostingIterator::positionlist_end";

%feature("docstring")  Xapian::PostingIterator::skip_to "

Advance the iterator to document did.

void Xapian::PostingIterator::skip_to(Xapian::docid did)
Xapian::PostingIterator::skip_to

Parameters:
-----------

did:  The document id to advance to. If this document id isn't in the
stream being iterated, then the iterator is moved to the next document
id after it which is. ";

%feature("docstring")  Xapian::PostingIterator::get_description "

Return a string describing this object.

std::string Xapian::PostingIterator::get_description() const
Xapian::PostingIterator::get_description";


// File: classXapian_1_1PostingSource.xml
%feature("docstring") Xapian::PostingSource "

Base class which provides an \"external\" source of postings. ";

%feature("docstring")  Xapian::PostingSource::PostingSource "

Allow subclasses to be instantiated.

Xapian::PostingSource::PostingSource() noexcept
Xapian::PostingSource::PostingSource";

%feature("docstring")  Xapian::PostingSource::~PostingSource "virtual
Xapian::PostingSource::~PostingSource()
Xapian::PostingSource::~PostingSource";

%feature("docstring")  Xapian::PostingSource::get_termfreq_min "

A lower bound on the number of documents this object can return.

virtual Xapian::doccount Xapian::PostingSource::get_termfreq_min()
const =0 Xapian::PostingSource::get_termfreq_min  Xapian will always
call reset() on a PostingSource before calling this for the first
time. ";

%feature("docstring")  Xapian::PostingSource::get_termfreq_est "

An estimate of the number of documents this object can return.

virtual Xapian::doccount Xapian::PostingSource::get_termfreq_est()
const =0 Xapian::PostingSource::get_termfreq_est It must always be
true that:

get_termfreq_min() <= get_termfreq_est() <= get_termfreq_max()

Xapian will always call reset() on a PostingSource before calling this
for the first time. ";

%feature("docstring")  Xapian::PostingSource::get_termfreq_max "

An upper bound on the number of documents this object can return.

virtual Xapian::doccount Xapian::PostingSource::get_termfreq_max()
const =0 Xapian::PostingSource::get_termfreq_max  Xapian will always
call reset() on a PostingSource before calling this for the first
time. ";

%feature("docstring")  Xapian::PostingSource::set_maxweight "

Specify an upper bound on what get_weight() will return from now on.

void Xapian::PostingSource::set_maxweight(double max_weight)
Xapian::PostingSource::set_maxweight This upper bound is used by the
matcher to perform various optimisations, so if you can return a good
bound, then matches will generally run faster.

This method should be called after calling reset(), and may be called
during iteration if the upper bound drops. It is probably only useful
to call from subclasses (it was actually a \"protected\" method prior
to Xapian 1.3.4, but that makes it tricky to wrap for other
languages).

It is valid for the posting source to have returned a higher value
from get_weight() earlier in the iteration, but the posting source
must not return a higher value from get_weight() than the currently
set upper bound, and the upper bound must not be increased (until
reset() has been called).

If you don't call this method, the upper bound will default to 0, for
convenience when implementing \"weight-less\" PostingSource
subclasses.

Parameters:
-----------

max_weight:  The upper bound to set. ";

%feature("docstring")  Xapian::PostingSource::get_maxweight "

Return the currently set upper bound on what get_weight() can return.

double Xapian::PostingSource::get_maxweight() const noexcept
Xapian::PostingSource::get_maxweight";

%feature("docstring")  Xapian::PostingSource::get_weight "

Return the weight contribution for the current document.

virtual double Xapian::PostingSource::get_weight() const
Xapian::PostingSource::get_weight This default implementation always
returns 0, for convenience when implementing \"weight-less\"
PostingSource subclasses.

This method may assume that it will only be called when there is a
\"current document\". In detail: Xapian will always call reset() on a
PostingSource before calling this for the first time. It will also
only call this if the PostingSource reports that it is pointing to a
valid document (ie, it will not call it before calling at least one of
next(), skip_to() or check(), and will ensure that the PostingSource
is not at the end by calling at_end()). ";

%feature("docstring")  Xapian::PostingSource::get_docid "

Return the current docid.

virtual Xapian::docid Xapian::PostingSource::get_docid() const =0
Xapian::PostingSource::get_docid This method may assume that it will
only be called when there is a \"current document\". See  get_weight()
for details.

Note: in the case of a multi-database search, the returned docid
should be in the single subdatabase relevant to this posting source.
See the  reset() method for details. ";

%feature("docstring")  Xapian::PostingSource::next "

Advance the current position to the next matching document.

virtual void Xapian::PostingSource::next(double min_wt)=0
Xapian::PostingSource::next The PostingSource starts before the first
entry in the list, so next(), skip_to() or check() must be called
before any methods which need the context of the current position.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Parameters:
-----------

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")  Xapian::PostingSource::skip_to "

Advance to the specified docid.

virtual void Xapian::PostingSource::skip_to(Xapian::docid did, double
min_wt) Xapian::PostingSource::skip_to If the specified docid isn't in
the list, position ourselves on the first document after it (or
at_end() if no greater docids are present).

If the current position is already the specified docid, this method
will leave the position unmodified.

If the specified docid is earlier than the current position, the
behaviour is unspecified. A sensible behaviour would be to leave the
current position unmodified, but it is also reasonable to move to the
specified docid.

The default implementation calls next() repeatedly, which works but
skip_to() can often be implemented much more efficiently.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Note: in the case of a multi-database search, the docid specified is
the docid in the single subdatabase relevant to this posting source.
See the  reset() method for details.

Parameters:
-----------

did:  The document id to advance to.

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")  Xapian::PostingSource::check "

Check if the specified docid occurs.

virtual bool Xapian::PostingSource::check(Xapian::docid did, double
min_wt) Xapian::PostingSource::check The caller is required to ensure
that the specified document id did actually exists in the database. If
it does, it must move to that document id, and return true. If it does
not, it may either:

return true, having moved to a definite position (including
\"at_end\"), which must be the same position as skip_to() would have
moved to.

or

return false, having moved to an \"indeterminate\" position, such that
a subsequent call to next() or skip_to() will move to the next
matching position after did.

Generally, this method should act like skip_to() and return true if
that can be done at little extra cost.

Otherwise it should simply check if a particular docid is present,
returning true if it is, and false if it isn't.

The default implementation calls skip_to() and always returns true.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Note: in the case of a multi-database search, the docid specified is
the docid in the single subdatabase relevant to this posting source.
See the  reset() method for details.

Parameters:
-----------

did:  The document id to check.

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")  Xapian::PostingSource::at_end "

Return true if the current position is past the last entry in this
list.

virtual bool Xapian::PostingSource::at_end() const =0
Xapian::PostingSource::at_end At least one of  next(),  skip_to() or
check() will be called before this method is first called. ";

%feature("docstring")  Xapian::PostingSource::clone "

Clone the posting source.

virtual PostingSource * Xapian::PostingSource::clone() const
Xapian::PostingSource::clone The clone should inherit the
configuration of the parent, but need not inherit the state. ie, the
clone does not need to be in the same iteration position as the
original: the matcher will always call reset() on the clone before
attempting to move the iterator, or read the information about the
current position of the iterator.

This may return NULL to indicate that cloning is not supported. In
this case, the PostingSource may only be used with a single-database
search.

The default implementation returns NULL.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1 ";

%feature("docstring")  Xapian::PostingSource::name "

Name of the posting source class.

virtual std::string Xapian::PostingSource::name() const
Xapian::PostingSource::name This is used when serialising and
unserialising posting sources; for example, for performing remote
searches.

If the subclass is in a C++ namespace, the namespace should be
included in the name, using \"::\" as a separator. For example, for a
PostingSource subclass called \"FooPostingSource\" in the \"Xapian\"
namespace the result of this call should be
\"Xapian::FooPostingSource\".

This should only be implemented if serialise() and unserialise() are
also implemented. The default implementation returns an empty string.

If this returns an empty string, Xapian will assume that serialise()
and unserialise() are not implemented. ";

%feature("docstring")  Xapian::PostingSource::serialise "

Serialise object parameters into a string.

virtual std::string Xapian::PostingSource::serialise() const
Xapian::PostingSource::serialise The serialised parameters should
represent the configuration of the posting source, but need not
(indeed, should not) represent the current iteration state.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.
";

%feature("docstring")  Xapian::PostingSource::unserialise "

Create object given string serialisation returned by serialise().

virtual PostingSource * Xapian::PostingSource::unserialise(const
std::string &serialised) const Xapian::PostingSource::unserialise Note
that the returned object will be deallocated by Xapian after use with
\"delete\". If you want to handle the deletion in a special way (for
example when wrapping the Xapian API for use from another language)
then you can define a static operator delete method in your subclass
as shown here:https://trac.xapian.org/ticket/554#comment:1

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Parameters:
-----------

serialised:  A serialised instance of this PostingSource subclass. ";

%feature("docstring")
Xapian::PostingSource::unserialise_with_registry "

Create object given string serialisation returned by serialise().

virtual PostingSource *
Xapian::PostingSource::unserialise_with_registry(const std::string
&serialised, const Registry &registry) const
Xapian::PostingSource::unserialise_with_registry Note that the
returned object will be deallocated by Xapian after use with
\"delete\". If you want to handle the deletion in a special way (for
example when wrapping the Xapian API for use from another language)
then you can define a static operator delete method in your subclass
as shown here:https://trac.xapian.org/ticket/554#comment:1

This method is supplied with a Registry object, which can be used when
unserialising objects contained within the posting source. The default
implementation simply calls unserialise() which doesn't take the
Registry object, so you do not need to implement this method unless
you want to take advantage of the Registry object when unserialising.

Parameters:
-----------

serialised:  A serialised instance of this PostingSource subclass.

registry:  The Xapian::Registry object to use. ";

%feature("docstring")  Xapian::PostingSource::reset "

Set this PostingSource to the start of the list of postings.

virtual void Xapian::PostingSource::reset(const Database &db,
Xapian::doccount shard_index) Xapian::PostingSource::reset This is
called automatically by the matcher prior to each query being
processed.

If a PostingSource is used for multiple searches,  reset() will
therefore be called multiple times, and must handle this by using the
database passed in the most recent call.

Parameters:
-----------

db:  The database which the PostingSource should iterate through.

shard_index:  The 0-based index indicating which shard in a multi-
database db is. This can be useful if you have an external source of
postings corresponding to each shard.

Note: in the case of a multi-database search, a separate PostingSource
will be used for each database (the separate PostingSources will be
obtained using  clone()), and each PostingSource will be passed one of
the sub-databases as the db parameter here. The db parameter will
therefore always refer to a single database. All docids passed to, or
returned from, the PostingSource refer to docids in that single
database, rather than in the multi- database.

A default implementation is provided which calls the older init()
method to allow existing subclasses to continue to work, but the
default implementation of init() throws Xapian::InvalidOperationError
so you must override either this method or init(). In new code,
override this method in preference.

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::PostingSource::init "

Older method which did the same job as reset().

virtual void Xapian::PostingSource::init(const Database &db)
Xapian::PostingSource::init Prior to 2.0.0, instead of reset() there
was a method called init() taking one parameter. The default
implementation of reset() calls init() to allow existing subclasses to
continue to work.

A default implementation of init() is provided so that new subclasses
can just override reset() (the default implementation should not
actually get called, and will throw Xapian::InvalidOperationError if
it is). ";

%feature("docstring")  Xapian::PostingSource::get_description "

Return a string describing this object.

virtual std::string Xapian::PostingSource::get_description() const
Xapian::PostingSource::get_description This default implementation
returns a generic answer. This default it provided to avoid forcing
those deriving their own PostingSource subclass from having to
implement this (they may not care what get_description() gives for
their subclass). ";

%feature("docstring")  Xapian::PostingSource::release "

Start reference counting this object.

PostingSource * Xapian::PostingSource::release()
Xapian::PostingSource::release You can transfer ownership of a
dynamically allocated PostingSource object to Xapian by calling
release() and then passing the object to a Xapian method. Xapian will
arrange to delete the object once it is no longer required. ";

%feature("docstring")  Xapian::PostingSource::release "

Start reference counting this object.

const PostingSource * Xapian::PostingSource::release() const
Xapian::PostingSource::release You can transfer ownership of a
dynamically allocated PostingSource object to Xapian by calling
release() and then passing the object to a Xapian method. Xapian will
arrange to delete the object once it is no longer required. ";


// File: classXapian_1_1Query.xml
%feature("docstring") Xapian::Query "

Class representing a query. ";

%feature("docstring")  Xapian::Query::Query "

Construct a query matching no documents.

Xapian::Query::Query() noexcept Xapian::Query::Query  MatchNothing is
a static instance of this.

When combined with other Query objects using the various supported
operators,  Query() works like false in boolean logic, so  Query() & q
is  Query(), while  Query() | q is q. ";

%feature("docstring")  Xapian::Query::~Query "

Destructor.

Xapian::Query::~Query() Xapian::Query::~Query";

%feature("docstring")  Xapian::Query::Query "

Copying is allowed.

Xapian::Query::Query(const Query &o) Xapian::Query::Query The
internals are reference counted, so copying is cheap. ";

%feature("docstring")  Xapian::Query::Query "

Move constructor.

Xapian::Query::Query(Query &&)=default Xapian::Query::Query";

%feature("docstring")  Xapian::Query::Query "

Construct a Query object for a term.

Xapian::Query::Query(const std::string &term, Xapian::termcount wqf=1,
Xapian::termpos pos=0) Xapian::Query::Query

Parameters:
-----------

term:  The term. An empty string constructs a query matching all
documents ( MatchAll is a static instance of this).

wqf:  The within-query frequency. (default: 1)

pos:  The query position. Currently this is mainly used to determine
the order of terms obtained via get_terms_begin(). (default: 0) ";

%feature("docstring")  Xapian::Query::Query "

Construct a Query object for a term.

Xapian::Query::Query(const char *term, Xapian::termcount wqf=1,
Xapian::termpos pos=0) Xapian::Query::Query

Parameters:
-----------

term:  The term. An empty string constructs a query matching all
documents ( MatchAll is a static instance of this).

wqf:  The within-query frequency. (default: 1)

pos:  The query position. Currently this is mainly used to determine
the order of terms obtained via get_terms_begin(). (default: 0) ";

%feature("docstring")  Xapian::Query::Query "

Construct a Query object for a term.

Xapian::Query::Query(std::string_view term, Xapian::termcount wqf=1,
Xapian::termpos pos=0) Xapian::Query::Query

Parameters:
-----------

term:  The term. An empty string constructs a query matching all
documents ( MatchAll is a static instance of this).

wqf:  The within-query frequency. (default: 1)

pos:  The query position. Currently this is mainly used to determine
the order of terms obtained via get_terms_begin(). (default: 0) ";

%feature("docstring")  Xapian::Query::Query "

Construct a Query object for a PostingSource.

Xapian::Query::Query(Xapian::PostingSource *source)
Xapian::Query::Query";

%feature("docstring")  Xapian::Query::Query "

Scale using OP_SCALE_WEIGHT.

Xapian::Query::Query(double factor, const Xapian::Query &subquery)
Xapian::Query::Query

Parameters:
-----------

factor:  Non-negative real number to multiply weights by.

subquery:   Query object to scale weights from. ";

%feature("docstring")  Xapian::Query::Query "

Scale using OP_SCALE_WEIGHT.

Xapian::Query::Query(op op_, const Xapian::Query &subquery, double
factor) Xapian::Query::Query In this form, the op_ parameter is
totally redundant - use Query(factor, subquery) in preference.

Parameters:
-----------

op_:  Must be OP_SCALE_WEIGHT.

factor:  Non-negative real number to multiply weights by.

subquery:   Query object to scale weights from. ";

%feature("docstring")  Xapian::Query::Query "

Construct a Query object by combining two others.

Xapian::Query::Query(op op_, const Xapian::Query &a, const
Xapian::Query &b) Xapian::Query::Query

Parameters:
-----------

op_:  The operator to combine the queries with.

a:  First subquery.

b:  Second subquery. ";

%feature("docstring")  Xapian::Query::Query "

Construct a Query object by combining two terms.

Xapian::Query::Query(op op_, S1 a, S2 b) Xapian::Query::Query

Parameters:
-----------

op_:  The operator to combine the terms with.

a:  First term.

b:  Second term. ";

%feature("docstring")  Xapian::Query::Query "

Construct a Query object for a single-ended value range.

Xapian::Query::Query(op op_, Xapian::valueno slot, std::string_view
range_limit) Xapian::Query::Query

Parameters:
-----------

op_:  Must be OP_VALUE_LE or OP_VALUE_GE currently.

slot:  The value slot to work over.

range_limit:  The limit of the range. ";

%feature("docstring")  Xapian::Query::Query "

Construct a Query object for a value range.

Xapian::Query::Query(op op_, Xapian::valueno slot, std::string_view
range_lower, std::string_view range_upper) Xapian::Query::Query

Parameters:
-----------

op_:  Must be OP_VALUE_RANGE currently.

slot:  The value slot to work over.

range_lower:  Lower end of the range.

range_upper:  Upper end of the range. ";

%feature("docstring")  Xapian::Query::Query "

Query constructor for OP_EDIT_DISTANCE and OP_WILDCARD queries.

Xapian::Query::Query(op op_, std::string_view pattern,
Xapian::termcount max_expansion=0, int flags=WILDCARD_LIMIT_ERROR, op
combiner=OP_SYNONYM) Xapian::Query::Query

Parameters:
-----------

op_:  Must be OP_EDIT_DISTANCE or OP_WILDCARD

pattern:  The wildcard pattern (for OP_WILDCARD) or target string (for
OP_EDIT_DISTANCE). See flags which affects how this pattern is
interpreted.

max_expansion:  The maximum number of terms to expand to (default: 0,
which means no limit)

flags:  Flags controlling aspects of the wildcarding - this consists
of a bitwise OR of:

At most one of WILDCARD_LIMIT_ERROR (the default),
WILDCARD_LIMIT_FIRST or WILDCARD_LIMIT_MOST_FREQUENT specifying how to
enforce max_expansion.

When searching multiple databases, the expansion limit is currently
applied independently for each database, so the total number of terms
may be higher than the limit. This is arguably a bug, and may change
in future versions.

For OP_WILDCARD: Zero or more of WILDCARD_PATTERN_MULTI and
WILDCARD_PATTERN_SINGLE, which specify whether '*' (matching zero or
more characters) and '?' (matching exactly one character) are
supported. If neither is specified, then a Xapian-1.4-compatible mode
is used where the pattern matches terms which start with the pattern
interpreted as a literal string.

Parameters:
-----------

combiner:  The  Query::op to combine the terms with - one of
OP_SYNONYM (the default), OP_OR or OP_MAX.

For OP_WILDCARD: A leading wildcard won't match terms starting with an
ASCII capital letter, as this is assumed to be part of a term prefix.
";

%feature("docstring")  Xapian::Query::Query "

Query constructor for OP_EDIT_DISTANCE queries.

Xapian::Query::Query(op op_, std::string_view pattern,
Xapian::termcount max_expansion, int flags, op combiner, unsigned
edit_distance, size_t min_prefix_len=0) Xapian::Query::Query This form
supports some additional parameters.

Parameters:
-----------

op_:  Must be OP_EDIT_DISTANCE.

pattern:  The target string.

max_expansion:  The maximum number of terms to expand to (default: 0,
which means no limit)

flags:  Flags controlling aspects of the wildcarding:            * At
most one of @a WILDCARD_LIMIT_ERROR (the default), @a
WILDCARD_LIMIT_FIRST or               @a WILDCARD_LIMIT_MOST_FREQUENT
specifying how to               enforce max_expansion.
When searching multiple databases, the expansion               limit
is currently applied independently for each               database, so
the total number of terms may be higher               than the limit.
This is arguably a bug, and may change in future versions.

combiner:  The  Query::op to combine the terms with - one of
OP_SYNONYM (the default), OP_OR or OP_MAX.

edit_distance:  The maximum number of edits allowed between a term and
target (an edit is insertion, deletion or substitution of a character,
or transposition of two adjacent characters). Default: 2

min_prefix_len:  The length in bytes of any initial substring of
target that is required to match exactly. Default: 0

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Query::Query "

Construct a Query object from a begin/end iterator pair.

Xapian::Query::Query(op op_, I begin, I end, Xapian::termcount
window=0) Xapian::Query::Query Dereferencing the iterator should
return a Xapian::Query, a non-NULL Xapian::Query*, a std::string_view
or a type which converts to one of these (e.g. std::string or const
char*).

If begin == end then there are no subqueries and the resulting Query
won't match anything.

Parameters:
-----------

op_:  The operator to combine the queries with.

begin:  Begin iterator.

end:  End iterator.

window:  Window size for OP_NEAR and OP_PHRASE, or 0 to use the number
of subqueries as the window size (default: 0). ";

%feature("docstring")  Xapian::Query::get_terms_begin "

Begin iterator for terms in the query object.

const TermIterator Xapian::Query::get_terms_begin() const
Xapian::Query::get_terms_begin The iterator returns terms in ascending
query position order, and will return the same term in each unique
position it occurs in. If you want the terms in sorted order and
without duplicates, see get_unique_terms_begin(). ";

%feature("docstring")  Xapian::Query::get_terms_end "

End iterator for terms in the query object.

const TermIterator Xapian::Query::get_terms_end() const noexcept
Xapian::Query::get_terms_end";

%feature("docstring")  Xapian::Query::get_unique_terms_begin "

Begin iterator for unique terms in the query object.

const TermIterator Xapian::Query::get_unique_terms_begin() const
Xapian::Query::get_unique_terms_begin Terms are sorted and terms with
the same name removed from the list.

If you want the terms in ascending query position order, see
get_terms_begin(). ";

%feature("docstring")  Xapian::Query::get_unique_terms_end "

End iterator for unique terms in the query object.

const TermIterator Xapian::Query::get_unique_terms_end() const
noexcept Xapian::Query::get_unique_terms_end";

%feature("docstring")  Xapian::Query::get_length "

Return the length of this query object.

Xapian::termcount Xapian::Query::get_length() const noexcept
Xapian::Query::get_length";

%feature("docstring")  Xapian::Query::empty "

Check if this query is Xapian::Query::MatchNothing.

bool Xapian::Query::empty() const noexcept Xapian::Query::empty";

%feature("docstring")  Xapian::Query::serialise "

Serialise this object into a string.

std::string Xapian::Query::serialise() const
Xapian::Query::serialise";

%feature("docstring")  Xapian::Query::get_type "

Get the type of the top level of the query.

op Xapian::Query::get_type() const noexcept Xapian::Query::get_type";

%feature("docstring")  Xapian::Query::get_num_subqueries "

Get the number of subqueries of the top level query.

size_t Xapian::Query::get_num_subqueries() const noexcept
Xapian::Query::get_num_subqueries";

%feature("docstring")  Xapian::Query::get_leaf_wqf "

Get the wqf parameter of a leaf node.

Xapian::termcount Xapian::Query::get_leaf_wqf() const
Xapian::Query::get_leaf_wqf

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Query::get_leaf_pos "

Get the pos parameter of a leaf node.

Xapian::termpos Xapian::Query::get_leaf_pos() const
Xapian::Query::get_leaf_pos

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Query::get_subquery "

Read a top level subquery.

const Query Xapian::Query::get_subquery(size_t n) const
Xapian::Query::get_subquery

Parameters:
-----------

n:  Return the n-th subquery (starting from 0) - only valid when 0 <=
n < get_num_subqueries(). ";

%feature("docstring")  Xapian::Query::get_description "

Return a string describing this object.

std::string Xapian::Query::get_description() const
Xapian::Query::get_description";

%feature("docstring")  Xapian::Query::Query "

Construct with just an operator.

Xapian::Query::Query(Query::op op_) Xapian::Query::Query

Parameters:
-----------

op_:  The operator to use - currently only OP_INVALID is useful. ";


// File: classXapian_1_1QueryParser.xml
%feature("docstring") Xapian::QueryParser "

Build a Xapian::Query object from a user query string. ";

%feature("docstring")  Xapian::QueryParser::QueryParser "

Copy constructor.

Xapian::QueryParser::QueryParser(const QueryParser &o)
Xapian::QueryParser::QueryParser";

%feature("docstring")  Xapian::QueryParser::QueryParser "

Move constructor.

Xapian::QueryParser::QueryParser(QueryParser &&o)
Xapian::QueryParser::QueryParser";

%feature("docstring")  Xapian::QueryParser::QueryParser "

Default constructor.

Xapian::QueryParser::QueryParser() Xapian::QueryParser::QueryParser";

%feature("docstring")  Xapian::QueryParser::~QueryParser "

Destructor.

Xapian::QueryParser::~QueryParser()
Xapian::QueryParser::~QueryParser";

%feature("docstring")  Xapian::QueryParser::set_stemmer "

Set the stemmer.

void Xapian::QueryParser::set_stemmer(const Xapian::Stem &stemmer)
Xapian::QueryParser::set_stemmer This sets the stemming algorithm
which will be used by the query parser. The stemming algorithm will be
used according to the stemming strategy set by
set_stemming_strategy(). As of 1.3.1, this defaults to STEM_SOME, but
in earlier versions the default was STEM_NONE. If you want to work
with older versions, you should explicitly set a stemming strategy as
well as setting a stemmer, otherwise your stemmer won't actually be
used.

Parameters:
-----------

stemmer:  The Xapian::Stem object to set. ";

%feature("docstring")  Xapian::QueryParser::set_stemming_strategy "

Set the stemming strategy.

void Xapian::QueryParser::set_stemming_strategy(stem_strategy
strategy) Xapian::QueryParser::set_stemming_strategy This controls how
the query parser will apply the stemming algorithm. Note that the
stemming algorithm is only applied to words in free-text fields -
boolean filter terms are never stemmed.

Parameters:
-----------

strategy:  The strategy to use - possible values are: STEM_NONE: Don't
perform any stemming. (default in Xapian <= 1.3.0)

STEM_SOME: Stem all terms except for those which start with a capital
letter, or are followed by certain characters (currently: (/@<>=*[{\"
), or are used with operators which need positional information.
Stemmed terms are prefixed with 'Z'. (default in Xapian >= 1.3.1)

STEM_SOME_FULL_POS: Like STEM_SOME but also stems terms used with
operators which need positional information. Added in Xapian 1.4.8.

STEM_ALL: Stem all terms (note: no 'Z' prefix is added).

STEM_ALL_Z: Stem all terms (note: 'Z' prefix is added). (new in Xapian
1.2.11 and 1.3.1) ";

%feature("docstring")  Xapian::QueryParser::set_stopper "

Set the stopper.

void Xapian::QueryParser::set_stopper(const Stopper *stop=NULL)
Xapian::QueryParser::set_stopper

Parameters:
-----------

stop:  The Stopper object to set (default NULL, which means no
stopwords). ";

%feature("docstring")  Xapian::QueryParser::set_stopper_strategy "

Set the stopper strategy.

void Xapian::QueryParser::set_stopper_strategy(stop_strategy strategy)
Xapian::QueryParser::set_stopper_strategy This method controls how the
stopper is used.

You need to also call  set_stopper() for this to have any effect.

Parameters:
-----------

strategy:  The strategy to use - possible values are: STOP_NONE: Don't
use the stopper.

STOP_ALL: If a word is identified as a stop word, skip it completely.
This makes some queries less useful (e.g. \"to be or not to be that is
the question\" would become a search for just question if the other
words were all stopwords). If you index with STOP_ALL you should use
it when parsing queries too.

STOP_STEMMED: If a word is identified as a stop word, assume it was
still indexed unstemmed and don't treat it as a stopword in contexts
where we would use the unstemmed form (for example, phrase searches,
ADJ, NEAR). (This is the default mode).

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::QueryParser::set_default_op "

Set the default operator.

void Xapian::QueryParser::set_default_op(Query::op default_op)
Xapian::QueryParser::set_default_op

Parameters:
-----------

default_op:  The operator to use to combine non-filter query items
when no explicit operator is used.

So for example, 'weather forecast' is parsed as if it were 'weather OR
forecast' by default.

The most useful values for this are OP_OR (the default) and OP_AND.
OP_NEAR, OP_PHRASE, OP_ELITE_SET, OP_SYNONYM and OP_MAX are also
permitted. Passing other values will result in InvalidArgumentError
being thrown. ";

%feature("docstring")  Xapian::QueryParser::get_default_op "

Get the current default operator.

Query::op Xapian::QueryParser::get_default_op() const
Xapian::QueryParser::get_default_op";

%feature("docstring")  Xapian::QueryParser::set_database "

Specify the database being searched.

void Xapian::QueryParser::set_database(const Database &db)
Xapian::QueryParser::set_database

Parameters:
-----------

db:  The database to use for spelling correction
(FLAG_SPELLING_CORRECTION), and synonyms (FLAG_SYNONYM,
FLAG_AUTO_SYNONYMS, and FLAG_AUTO_MULTIWORD_SYNONYMS). ";

%feature("docstring")  Xapian::QueryParser::set_max_expansion "

Specify the maximum expansion of a wildcard and/or partial and/or
fuzzy term.

void Xapian::QueryParser::set_max_expansion(Xapian::termcount
max_expansion, int max_type=Xapian::Query::WILDCARD_LIMIT_ERROR,
unsigned flags=FLAG_WILDCARD|FLAG_PARTIAL|FLAG_FUZZY)
Xapian::QueryParser::set_max_expansion Note: you must also set
FLAG_WILDCARD and/or FLAG_PARTIAL and/or FLAG_FUZZY in the flags
parameter to  parse_query() for this setting to have anything to
affect.

If you don't call this method, the default settings are no limit on
wildcard and fuzzy expansion, and partial terms expanding to the most
frequent 100 terms - i.e. as if you'd called:

set_max_expansion(0); set_max_expansion(100,
Xapian::Query::WILDCARD_LIMIT_MOST_FREQUENT,
Xapian::QueryParser::FLAG_PARTIAL);

Parameters:
-----------

max_expansion:  The maximum number of terms each wildcard in the query
can expand to, or 0 for no limit (which is the default).

max_type:    Xapian::Query::WILDCARD_LIMIT_ERROR,
Xapian::Query::WILDCARD_LIMIT_FIRST or
Xapian::Query::WILDCARD_LIMIT_MOST_FREQUENT (default:
Xapian::Query::WILDCARD_LIMIT_ERROR).

flags:  What to set the limit for (default:
FLAG_WILDCARD|FLAG_PARTIAL|FLAG_FUZZY, setting the limit for all
types).

1.3.3 ";

%feature("docstring")  Xapian::QueryParser::set_min_wildcard_prefix "

Specify minimum length for fixed initial portion in wildcard patterns.

void Xapian::QueryParser::set_min_wildcard_prefix(unsigned
min_prefix_len, unsigned flags=FLAG_WILDCARD|FLAG_PARTIAL)
Xapian::QueryParser::set_min_wildcard_prefix It can be desirable for
performance reasons to restrict use of wildcards to patterns with a
fixed initial portion, so this method provides a way to specify a
minimum length. A wildcard pattern with a shorter (or no) fixed
initial portion will result in Xapian::QueryParser being thrown. The
default minimum length is 0.

It also provides a way to specify the minimum length of a word to
expand for partial matching (see FLAG_PARTIAL). In this case a shorter
word at the end of the query simply result in no partial matching. The
default minimum length for this case is 2 (since 2.0.0 - in earlier
versions it was effectively 0).

Parameters:
-----------

min_prefix_len:  Minimum length of fixed initial portion in Unicode
characters.

flags:  What to set the minimum length for (default:
FLAG_WILDCARD|FLAG_PARTIAL, setting the limit for both wildcards and
partial terms).

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::QueryParser::parse_query "

Parse a query.

Query Xapian::QueryParser::parse_query(std::string_view query_string,
unsigned flags=FLAG_DEFAULT, std::string_view default_prefix={})
Xapian::QueryParser::parse_query

Parameters:
-----------

query_string:  A free-text query as entered by a user

flags:  Zero or more QueryParser::feature_flag specifying what
features the QueryParser should support. Combine multiple values with
bitwise-or (|) (default FLAG_DEFAULT).

default_prefix:  The default term prefix to use (default none). For
example, you can pass \"A\" when parsing an \"Author\" field.

Parameters:
-----------

If:  the query string can't be parsed, then Xapian::QueryParserError
is thrown. You can get an English error message to report to the user
by catching it and calling get_msg() on the caught exception. The
current possible values (in case you want to translate them) are:

Unknown range operation

parse error

Syntax: <expression> AND <expression>

Syntax: <expression> AND NOT <expression>

Syntax: <expression> NOT <expression>

Syntax: <expression> OR <expression>

Syntax: <expression> XOR <expression> ";

%feature("docstring")  Xapian::QueryParser::add_prefix "

Add a free-text field term prefix.

void Xapian::QueryParser::add_prefix(std::string_view field,
std::string_view prefix) Xapian::QueryParser::add_prefix For example:

This allows the user to search for author:Orwell which will be
converted to a search for the term \"Aorwell\".

Multiple fields can be mapped to the same prefix. For example, you can
make title: and subject: aliases for each other.

As of 1.0.4, you can call this method multiple times with the same
value of field to allow a single field to be mapped to multiple
prefixes. Multiple terms being generated for such a field, and
combined with  Xapian::Query::OP_OR.

If any prefixes are specified for the empty field name (i.e. you call
this method with an empty string as the first parameter) these
prefixes will be used for terms without a field specifier. If you do
this and also specify the default_prefix parameter to  parse_query(),
then the default_prefix parameter will override.

If the prefix parameter is empty, then \"field:word\" will produce the
term \"word\" (and this can be one of several prefixes for a
particular field, or for terms without a field specifier).

If you call  add_prefix() and  add_boolean_prefix() for the same value
of field, a  Xapian::InvalidOperationError exception will be thrown.

In 1.0.3 and earlier, subsequent calls to this method with the same
value of field had no effect.

Parameters:
-----------

field:  The user visible field name. Currently this needs to consist
of characters for which Xapian::Unicode::is_wordchar() is true
(approximately alphanumerics plus connector punctuation such as _).
Since 1.4.26 it can optionally end in a : for consistency with how
range prefixes are specified.

prefix:  The term prefix to map this to. ";

%feature("docstring")  Xapian::QueryParser::add_prefix "

Register a FieldProcessor.

void Xapian::QueryParser::add_prefix(std::string_view field,
Xapian::FieldProcessor *proc) Xapian::QueryParser::add_prefix";

%feature("docstring")  Xapian::QueryParser::add_boolean_prefix "

Add a boolean term prefix allowing the user to restrict a search with
a boolean filter specified in the free text query.

void Xapian::QueryParser::add_boolean_prefix(std::string_view field,
std::string_view prefix, const std::string *grouping=NULL)
Xapian::QueryParser::add_boolean_prefix For example:

This allows the user to restrict a search with site:xapian.org which
will be converted to Hxapian.org combined with any weighted query with
Xapian::Query::OP_FILTER.

If multiple boolean filters are specified in a query for the same
prefix, they will be combined with the  Xapian::Query::OP_OR operator.
Then, if there are boolean filters for different prefixes, they will
be combined with the  Xapian::Query::OP_AND operator.

Multiple fields can be mapped to the same prefix (so for example you
can make site: and domain: aliases for each other). Instances of
fields with different aliases but the same prefix will still be
combined with the OR operator.

For example, if \"site\" and \"domain\" map to \"H\", but author maps
to \"A\", a search for \"site:foo domain:bar author:Fred\" will map to
\"(Hfoo OR Hbar) AND Afred\".

As of 1.0.4, you can call this method multiple times with the same
value of field to allow a single field to be mapped to multiple
prefixes. Multiple terms being generated for such a field, and
combined with  Xapian::Query::OP_OR.

Calling this method with an empty string for field will cause a
Xapian::InvalidArgumentError.

If you call  add_prefix() and  add_boolean_prefix() for the same value
of field, a  Xapian::InvalidOperationError exception will be thrown.

In 1.0.3 and earlier, subsequent calls to this method with the same
value of field had no effect.

Parameters:
-----------

field:  The user visible field name, which may not be empty for a
boolean filter. Currently this needs to consist of characters for
which Xapian::Unicode::is_wordchar() is true (approximately
alphanumerics plus connector punctuation such as _). Since 1.4.26 it
can optionally end in a : for consistency with how range prefixes are
specified.

prefix:  The term prefix to map this to

grouping:  Controls how multiple filters are combined - filters with
the same grouping value are combined with OP_OR, then the resulting
queries are combined with OP_AND. If NULL, then field is used for
grouping. If an empty string, then a unique grouping is created for
each filter (this is sometimes useful when each document can have
multiple terms with this prefix). [default: NULL] ";

%feature("docstring")  Xapian::QueryParser::add_boolean_prefix "

Add a boolean term prefix allowing the user to restrict a search with
a boolean filter specified in the free text query.

void Xapian::QueryParser::add_boolean_prefix(std::string_view field,
std::string_view prefix, bool exclusive)
Xapian::QueryParser::add_boolean_prefix This is an older version of
this method - use the version with the grouping parameter in
preference to this one.

Parameters:
-----------

field:  The user visible field name, which may not be empty for a
boolean filter. Currently this needs to consist of characters for
which Xapian::Unicode::is_wordchar() is true (approximately
alphanumerics plus connector punctuation such as _). Since 1.4.26 it
can optionally end in a : for consistency with how range prefixes are
specified.

prefix:  The term prefix to map this to

exclusive:  Controls how multiple filters are combined. If true then
prefix is used as the grouping value, so terms with the same prefix
are combined with OP_OR, then the resulting queries are combined with
OP_AND. If false, then a unique grouping is created for each filter
(this is sometimes useful when each document can have multiple terms
with this prefix). ";

%feature("docstring")  Xapian::QueryParser::add_boolean_prefix "

Register a FieldProcessor for a boolean prefix.

void Xapian::QueryParser::add_boolean_prefix(std::string_view field,
Xapian::FieldProcessor *proc, const std::string *grouping=NULL)
Xapian::QueryParser::add_boolean_prefix";

%feature("docstring")  Xapian::QueryParser::add_boolean_prefix "

Register a FieldProcessor for a boolean prefix.

void Xapian::QueryParser::add_boolean_prefix(std::string_view field,
Xapian::FieldProcessor *proc, bool exclusive)
Xapian::QueryParser::add_boolean_prefix This is an older version of
this method - use the version with the grouping parameter in
preference to this one. ";

%feature("docstring")  Xapian::QueryParser::stoplist_begin "

Begin iterator over terms omitted from the query as stopwords.

TermIterator Xapian::QueryParser::stoplist_begin() const
Xapian::QueryParser::stoplist_begin";

%feature("docstring")  Xapian::QueryParser::stoplist_end "

End iterator over terms omitted from the query as stopwords.

TermIterator Xapian::QueryParser::stoplist_end() const noexcept
Xapian::QueryParser::stoplist_end";

%feature("docstring")  Xapian::QueryParser::unstem_begin "

Begin iterator over unstemmed forms of the given stemmed query term.

TermIterator Xapian::QueryParser::unstem_begin(std::string_view term)
const Xapian::QueryParser::unstem_begin";

%feature("docstring")  Xapian::QueryParser::unstem_end "

End iterator over unstemmed forms of the given stemmed query term.

TermIterator Xapian::QueryParser::unstem_end(std::string_view) const
noexcept Xapian::QueryParser::unstem_end";

%feature("docstring")  Xapian::QueryParser::add_rangeprocessor "

Register a RangeProcessor.

void Xapian::QueryParser::add_rangeprocessor(Xapian::RangeProcessor
*range_proc, const std::string *grouping=NULL)
Xapian::QueryParser::add_rangeprocessor";

%feature("docstring")  Xapian::QueryParser::get_corrected_query_string
"

Get the spelling-corrected query string.

std::string Xapian::QueryParser::get_corrected_query_string() const
Xapian::QueryParser::get_corrected_query_string This will only be set
if FLAG_SPELLING_CORRECTION is specified when
QueryParser::parse_query() was last called.

If there were no corrections, an empty string is returned. ";

%feature("docstring")  Xapian::QueryParser::get_description "

Return a string describing this object.

std::string Xapian::QueryParser::get_description() const
Xapian::QueryParser::get_description";


// File: classXapian_1_1QueryParserError.xml
%feature("docstring") Xapian::QueryParserError "

Indicates a query string can't be parsed. ";

%feature("docstring")  Xapian::QueryParserError::QueryParserError "

General purpose constructor.

Xapian::QueryParserError::QueryParserError(std::string_view msg_,
std::string_view context_={}, int errno_=0)
Xapian::QueryParserError::QueryParserError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")  Xapian::QueryParserError::QueryParserError "

Construct from message and errno value.

Xapian::QueryParserError::QueryParserError(std::string_view msg_, int
errno_) Xapian::QueryParserError::QueryParserError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1RangeError.xml
%feature("docstring") Xapian::RangeError "

RangeError indicates an attempt to access outside the bounds of a
container. ";

%feature("docstring")  Xapian::RangeError::RangeError "

General purpose constructor.

Xapian::RangeError::RangeError(std::string_view msg_, std::string_view
context_={}, int errno_=0) Xapian::RangeError::RangeError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")  Xapian::RangeError::RangeError "

Construct from message and errno value.

Xapian::RangeError::RangeError(std::string_view msg_, int errno_)
Xapian::RangeError::RangeError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1RangeProcessor.xml
%feature("docstring") Xapian::RangeProcessor "

Base class for range processors. ";

%feature("docstring")  Xapian::RangeProcessor::RangeProcessor "

Default constructor.

Xapian::RangeProcessor::RangeProcessor()
Xapian::RangeProcessor::RangeProcessor";

%feature("docstring")  Xapian::RangeProcessor::RangeProcessor "

Constructor.

Xapian::RangeProcessor::RangeProcessor(Xapian::valueno slot_,
std::string_view str_={}, unsigned flags_=0)
Xapian::RangeProcessor::RangeProcessor

Parameters:
-----------

slot_:  Which value slot to generate ranges over.

str_:  A string to look for to recognise values as belonging to this
range (as a prefix by default, or as a suffix if flags
Xapian::RP_SUFFIX is specified).

flags_:  Zero or more of the following flags, combined with bitwise-or
(| in C++): Xapian::RP_SUFFIX - require str_ as a suffix instead of a
prefix.

Xapian::RP_REPEATED - optionally allow str_ on both ends of the range,
or only on the non-empty end - e.g. $1..$10, ..$10, 5m..50m, or 5m...
By default a prefix is only checked for on the start (e.g.
date:1/1/1980..31/12/1989 or date:..31/12/1989), and a suffix only on
the end (e.g. 2..12kg or 2..kg). ";

%feature("docstring")  Xapian::RangeProcessor::~RangeProcessor "

Destructor.

virtual Xapian::RangeProcessor::~RangeProcessor()
Xapian::RangeProcessor::~RangeProcessor";

%feature("docstring")  Xapian::RangeProcessor::check_range "

Check prefix/suffix on range.

Xapian::Query Xapian::RangeProcessor::check_range(const std::string
&b, const std::string &e) Xapian::RangeProcessor::check_range If they
match, remove the prefix/suffix and then call operator()() to try to
handle the range. ";

%feature("docstring")  Xapian::RangeProcessor::release "

Start reference counting this object.

RangeProcessor * Xapian::RangeProcessor::release()
Xapian::RangeProcessor::release You can transfer ownership of a
dynamically allocated RangeProcessor object to Xapian by calling
release() and then passing the object to a Xapian method. Xapian will
arrange to delete the object once it is no longer required. ";

%feature("docstring")  Xapian::RangeProcessor::release "

Start reference counting this object.

const RangeProcessor * Xapian::RangeProcessor::release() const
Xapian::RangeProcessor::release You can transfer ownership of a
dynamically allocated RangeProcessor object to Xapian by calling
release() and then passing the object to a Xapian method. Xapian will
arrange to delete the object once it is no longer required. ";


// File: classXapian_1_1Registry.xml
%feature("docstring") Xapian::Registry "

Registry for user subclasses.

This class provides a way for the remote server to look up user
subclasses when unserialising. ";

%feature("docstring")  Xapian::Registry::Registry "

Copy constructor.

Xapian::Registry::Registry(const Registry &other)
Xapian::Registry::Registry The internals are reference counted, so
copying is cheap.

Parameters:
-----------

other:  The object to copy. ";

%feature("docstring")  Xapian::Registry::Registry "

Move constructor.

Xapian::Registry::Registry(Registry &&other)
Xapian::Registry::Registry

Parameters:
-----------

other:  The object to move. ";

%feature("docstring")  Xapian::Registry::Registry "

Default constructor.

Xapian::Registry::Registry() Xapian::Registry::Registry The registry
will contain all standard subclasses of user-subclassable classes. ";

%feature("docstring")  Xapian::Registry::~Registry "Xapian::Registry::~Registry() Xapian::Registry::~Registry";

%feature("docstring")  Xapian::Registry::register_weighting_scheme "

Register a weighting scheme.

void Xapian::Registry::register_weighting_scheme(const Xapian::Weight
&wt) Xapian::Registry::register_weighting_scheme

Parameters:
-----------

wt:  The weighting scheme to register. ";

%feature("docstring")  Xapian::Registry::get_weighting_scheme "

Get the weighting scheme given a name.

const Xapian::Weight *
Xapian::Registry::get_weighting_scheme(std::string_view name) const
Xapian::Registry::get_weighting_scheme

Parameters:
-----------

name:  The name of the weighting scheme to find.

An object with the requested name, or NULL if the weighting scheme
could not be found. The returned object is owned by the registry and
so must not be deleted by the caller. ";

%feature("docstring")  Xapian::Registry::register_posting_source "

Register a user-defined posting source class.

void Xapian::Registry::register_posting_source(const
Xapian::PostingSource &source)
Xapian::Registry::register_posting_source

Parameters:
-----------

source:  The posting source to register. ";

%feature("docstring")  Xapian::Registry::get_posting_source "

Get a posting source given a name.

const Xapian::PostingSource *
Xapian::Registry::get_posting_source(std::string_view name) const
Xapian::Registry::get_posting_source

Parameters:
-----------

name:  The name of the posting source to find.

An object with the requested name, or NULL if the posting source could
not be found. The returned object is owned by the registry and so must
not be deleted by the caller. ";

%feature("docstring")  Xapian::Registry::register_match_spy "

Register a user-defined match spy class.

void Xapian::Registry::register_match_spy(const Xapian::MatchSpy &spy)
Xapian::Registry::register_match_spy

Parameters:
-----------

spy:  The match spy to register. ";

%feature("docstring")  Xapian::Registry::get_match_spy "

Get a match spy given a name.

const Xapian::MatchSpy *
Xapian::Registry::get_match_spy(std::string_view name) const
Xapian::Registry::get_match_spy

Parameters:
-----------

name:  The name of the match spy to find.

An object with the requested name, or NULL if the match spy could not
be found. The returned object is owned by the registry and so must not
be deleted by the caller. ";

%feature("docstring")  Xapian::Registry::register_lat_long_metric "

Register a user-defined lat-long metric class.

void Xapian::Registry::register_lat_long_metric(const
Xapian::LatLongMetric &metric)
Xapian::Registry::register_lat_long_metric";

%feature("docstring")  Xapian::Registry::get_lat_long_metric "

Get a lat-long metric given a name.

const Xapian::LatLongMetric *
Xapian::Registry::get_lat_long_metric(std::string_view name) const
Xapian::Registry::get_lat_long_metric The returned metric is owned by
the registry object.

Returns NULL if the metric could not be found. ";

%feature("docstring")  Xapian::Registry::register_key_maker "

Register a user-defined KeyMaker subclass.

void Xapian::Registry::register_key_maker(Xapian::KeyMaker *keymaker)
Xapian::Registry::register_key_maker

Parameters:
-----------

keymaker:  The KeyMaker subclass to register. The clean up of this
object is handled via Xapian's optional reference counting. The
simplest way to do so is to allocate it with new and call release() on
it before passing it to this method to tell Xapian to manage its
lifetime. The alternative approach is for the caller to ensure the
KeyMaker object remains valid for the lifetime of the Registry object.

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Registry::get_key_maker "

Get a KeyMaker given a name.

const Xapian::KeyMaker *
Xapian::Registry::get_key_maker(std::string_view name) const
Xapian::Registry::get_key_maker

Parameters:
-----------

name:  The name of the KeyMaker to find.

An object with the requested name, or NULL if the KeyMaker could not
be found. The returned object must not be deleted by the caller.

Added in Xapian 2.0.0. ";


// File: classXapian_1_1RSet.xml
%feature("docstring") Xapian::RSet "

Class representing a set of documents judged as relevant. ";

%feature("docstring")  Xapian::RSet::RSet "

Copying is allowed.

Xapian::RSet::RSet(const RSet &o) Xapian::RSet::RSet The internals are
reference counted, so copying is cheap. ";

%feature("docstring")  Xapian::RSet::RSet "

Move constructor.

Xapian::RSet::RSet(RSet &&o) Xapian::RSet::RSet";

%feature("docstring")  Xapian::RSet::RSet "

Default constructor.

Xapian::RSet::RSet() Xapian::RSet::RSet Creates an empty RSet. ";

%feature("docstring")  Xapian::RSet::~RSet "

Destructor.

Xapian::RSet::~RSet() Xapian::RSet::~RSet";

%feature("docstring")  Xapian::RSet::size "

Return number of documents in this RSet object.

Xapian::doccount Xapian::RSet::size() const Xapian::RSet::size";

%feature("docstring")  Xapian::RSet::empty "

Return true if this RSet object is empty.

bool Xapian::RSet::empty() const Xapian::RSet::empty";

%feature("docstring")  Xapian::RSet::swap "

Efficiently swap this RSet object with another.

void Xapian::RSet::swap(RSet &o) Xapian::RSet::swap";

%feature("docstring")  Xapian::RSet::add_document "

Mark a document as relevant.

void Xapian::RSet::add_document(Xapian::docid did)
Xapian::RSet::add_document If did is already marked as relevant,
nothing happens. ";

%feature("docstring")  Xapian::RSet::add_document "

Mark a document as relevant.

void Xapian::RSet::add_document(const Xapian::MSetIterator &it)
Xapian::RSet::add_document If did is already marked as relevant,
nothing happens. ";

%feature("docstring")  Xapian::RSet::remove_document "

Unmark a document as relevant.

void Xapian::RSet::remove_document(Xapian::docid did)
Xapian::RSet::remove_document If did is not marked as relevant,
nothing happens. ";

%feature("docstring")  Xapian::RSet::remove_document "

Unmark a document as relevant.

void Xapian::RSet::remove_document(const Xapian::MSetIterator &it)
Xapian::RSet::remove_document If did is not marked as relevant,
nothing happens. ";

%feature("docstring")  Xapian::RSet::contains "

Check if a document is marked as relevant.

bool Xapian::RSet::contains(Xapian::docid did) const
Xapian::RSet::contains";

%feature("docstring")  Xapian::RSet::contains "

Check if a document is marked as relevant.

bool Xapian::RSet::contains(const Xapian::MSetIterator &it) const
Xapian::RSet::contains";

%feature("docstring")  Xapian::RSet::get_description "

Return a string describing this object.

std::string Xapian::RSet::get_description() const
Xapian::RSet::get_description";


// File: classXapian_1_1RuntimeError.xml
%feature("docstring") Xapian::RuntimeError "

The base class for exceptions indicating errors only detectable at
runtime.

A subclass of RuntimeError will be thrown if Xapian detects an error
which is exception derived from RuntimeError is thrown when an error
is caused by problems with the data or environment rather than a
programming mistake. ";


// File: classXapian_1_1SerialisationError.xml
%feature("docstring") Xapian::SerialisationError "

Indicates an error in the std::string serialisation of an object. ";

%feature("docstring")  Xapian::SerialisationError::SerialisationError
"

General purpose constructor.

Xapian::SerialisationError::SerialisationError(std::string_view msg_,
std::string_view context_={}, int errno_=0)
Xapian::SerialisationError::SerialisationError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")  Xapian::SerialisationError::SerialisationError
"

Construct from message and errno value.

Xapian::SerialisationError::SerialisationError(std::string_view msg_,
int errno_) Xapian::SerialisationError::SerialisationError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1Similarity.xml
%feature("docstring") Xapian::Similarity "

Base class for calculating the similarity between documents. ";

%feature("docstring")  Xapian::Similarity::~Similarity "

Destructor.

virtual Xapian::Similarity::~Similarity()
Xapian::Similarity::~Similarity";

%feature("docstring")  Xapian::Similarity::similarity "

Calculates the similarity between the two documents.

virtual double Xapian::Similarity::similarity(const PointType &a,
const PointType &b) const =0 Xapian::Similarity::similarity

Parameters:
-----------

a:  First point object for distance calculation

b:  Second point object for distance calculation ";

%feature("docstring")  Xapian::Similarity::get_description "

Returns a string describing the similarity metric being used.

virtual std::string Xapian::Similarity::get_description() const =0
Xapian::Similarity::get_description";


// File: classXapian_1_1SimpleStopper.xml
%feature("docstring") Xapian::SimpleStopper "

Simple implementation of Stopper class - this will suit most users. ";

%feature("docstring")  Xapian::SimpleStopper::SimpleStopper "

Default constructor.

Xapian::SimpleStopper::SimpleStopper()
Xapian::SimpleStopper::SimpleStopper";

%feature("docstring")  Xapian::SimpleStopper::SimpleStopper "

Initialise from a pair of iterators.

Xapian::SimpleStopper::SimpleStopper(Iterator begin, Iterator end)
Xapian::SimpleStopper::SimpleStopper  Xapian includes stopword list
files for many languages. You can initialise from a file like so:

In bindings for other languages it isn't possible to pass a C++
iterator pair, so instead this constructor is wrapped to allow passing
a filename. ";

%feature("docstring")  Xapian::SimpleStopper::add "

Add a single stop word.

void Xapian::SimpleStopper::add(const std::string &word)
Xapian::SimpleStopper::add";

%feature("docstring")  Xapian::SimpleStopper::get_description "

Return a string describing this object.

virtual std::string Xapian::SimpleStopper::get_description() const
Xapian::SimpleStopper::get_description";


// File: classXapian_1_1Stem.xml
%feature("docstring") Xapian::Stem "

Class representing a stemming algorithm. ";

%feature("docstring")  Xapian::Stem::Stem "

Copy constructor.

Xapian::Stem::Stem(const Stem &o) Xapian::Stem::Stem";

%feature("docstring")  Xapian::Stem::Stem "

Move constructor.

Xapian::Stem::Stem(Stem &&)=default Xapian::Stem::Stem";

%feature("docstring")  Xapian::Stem::Stem "

Construct a Xapian::Stem object which doesn't change terms.

Xapian::Stem::Stem() Xapian::Stem::Stem Equivalent to Stem(\"none\").
";

%feature("docstring")  Xapian::Stem::Stem "

Construct a Xapian::Stem object for a particular language.

Xapian::Stem::Stem(std::string_view language, bool fallback=false)
Xapian::Stem::Stem

Parameters:
-----------

language:  Either the English name for the language or the two letter
ISO639 code.

The following language names are understood (aliases follow the name):

none - don't stem terms

arabic (ar) - Since Xapian 1.3.5

armenian (hy) - Since Xapian 1.3.0

basque (eu) - Since Xapian 1.3.0

catalan (ca) - Since Xapian 1.3.0

danish (da)

dutch (nl, kraaij_pohlmann) - Before Xapian 2.0.0, \"dutch\" was
Martin Porter's Dutch stemmer, and a stemmer which approximately
implemented the Kraaij-Pohlmann Dutch stemmer was available separately
as \"kraaij_pohlmann\".

dutch_porter - This was the \"dutch\" stemmer before Xapian 2.0.0. In
1.4.x for x >= 28, \"dutch_porter\" was an alias for dutch to provide
forward compatibility to Xapian 2.

english (en) - Martin Porter's 2002 revision of his stemmer

earlyenglish - English stemmer with additional rules to improve
handling of Early Modern English (e.g. Shakespeare, Dickens) but these
overstem some words in contemporary English (since Xapian 1.3.2;
originally this was based on \"porter\", since Xapian 2.0.0 this is
based on \"english\").

lovins - Lovin's English stemmer

porter - Porter's English stemmer exactly matching his 1980 paper

esperanto (eo) - Since Xapian 2.0.0

estonian (et) - Since Xapian 2.0.0

finnish (fi)

french (fr)

german (de, german2) - Before Xapian 2.0.0, german2 was a separate
variant of the german stemmer which normalised umlauts (e.g. ä and
ae). The two variants have now been merged into one.

greek (el) - Since Xapian 2.0.0

hindi (hi) - Since Xapian 2.0.0

hungarian (hu)

indonesian (id) - Since Xapian 1.4.6

irish (ga) - Since Xapian 1.4.7

italian (it)

lithuanian (lt) - Since Xapian 1.4.7

nepali (ne) - Since Xapian 1.4.7

norwegian (nb, nn, no)

polish (pl) - Since Xapian 2.0.0

portuguese (pt)

romanian (ro)

russian (ru)

serbian (sr) - Since Xapian 2.0.0

spanish (es)

swedish (sv)

tamil (ta) - Since Xapian 1.4.7

turkish (tr)

yiddish (yi) - Since Xapian 2.0.0

Parameters:
-----------

fallback:  If true then treat unknown language as \"none\", otherwise
an exception is thrown (default: false). Parameter added in Xapian
1.4.14 - older versions always threw an exception.

Parameters:
-----------

Xapian::InvalidArgumentError:  is thrown if language isn't recognised
and fallback is false. ";

%feature("docstring")  Xapian::Stem::Stem "

Construct a Xapian::Stem object with a user-provided stemming
algorithm.

Xapian::Stem::Stem(StemImplementation *p) Xapian::Stem::Stem You can
subclass Xapian::StemImplementation to implement your own stemming
algorithm (or to wrap a third-party algorithm) and then wrap your
implementation in a Xapian::Stem object to pass to the Xapian API.

Parameters:
-----------

p:  The user-subclassed StemImplementation object. This is reference
counted, and so will be automatically deleted by the Xapian::Stem
wrapper when no longer required. ";

%feature("docstring")  Xapian::Stem::~Stem "

Destructor.

Xapian::Stem::~Stem() Xapian::Stem::~Stem";

%feature("docstring")  Xapian::Stem::is_none "

Return true if this is a no-op stemmer.

bool Xapian::Stem::is_none() const Xapian::Stem::is_none";

%feature("docstring")  Xapian::Stem::get_description "

Return a string describing this object.

std::string Xapian::Stem::get_description() const
Xapian::Stem::get_description";


// File: classXapian_1_1StemImplementation.xml
%feature("docstring") Xapian::StemImplementation "

Class representing a stemming algorithm implementation. ";

%feature("docstring")  Xapian::StemImplementation::StemImplementation
"

Default constructor.

Xapian::StemImplementation::StemImplementation()
Xapian::StemImplementation::StemImplementation";

%feature("docstring")  Xapian::StemImplementation::~StemImplementation
"

Virtual destructor.

virtual Xapian::StemImplementation::~StemImplementation()
Xapian::StemImplementation::~StemImplementation";

%feature("docstring")
Xapian::StemImplementation::use_proper_noun_heuristic "

Should QueryParser suppress stemming for capitalised words?

virtual bool Xapian::StemImplementation::use_proper_noun_heuristic()
const Xapian::StemImplementation::use_proper_noun_heuristic See
QueryParser::feature_flag value FLAG_NO_PROPER_NOUN_HEURISTIC for
details.

The default implementation of this method returns false.

Xapian 2.0.0. ";

%feature("docstring")  Xapian::StemImplementation::get_description "

Return a string describing this object.

virtual std::string Xapian::StemImplementation::get_description()
const =0 Xapian::StemImplementation::get_description";


// File: classXapian_1_1StemStopper.xml
%feature("docstring") Xapian::StemStopper "

Stopper subclass which checks for both stemmed and unstemmed
stopwords.

This is intended for use with Xapian::Cluster. ";

%feature("docstring")  Xapian::StemStopper::StemStopper "

Constructor.

Xapian::StemStopper::StemStopper(const Xapian::Stem &stemmer,
stem_strategy strategy=STEM_SOME) Xapian::StemStopper::StemStopper

Parameters:
-----------

stemmer:  The Xapian::Stem object to set.

strategy:  The stemming strategy to be used. ";

%feature("docstring")  Xapian::StemStopper::get_description "

Return a string describing this object.

std::string Xapian::StemStopper::get_description() const override
Xapian::StemStopper::get_description";

%feature("docstring")  Xapian::StemStopper::add "

Add a single stop word and its stemmed equivalent.

void Xapian::StemStopper::add(std::string_view term)
Xapian::StemStopper::add";


// File: classXapian_1_1Stopper.xml
%feature("docstring") Xapian::Stopper "

Abstract base class for stop-word decision functor.

If you just want to use an existing stopword list, see
Xapian::SimpleStopper. ";

%feature("docstring")  Xapian::Stopper::Stopper "

Default constructor.

Xapian::Stopper::Stopper() Xapian::Stopper::Stopper";

%feature("docstring")  Xapian::Stopper::~Stopper "

Class has virtual methods, so provide a virtual destructor.

virtual Xapian::Stopper::~Stopper() Xapian::Stopper::~Stopper";

%feature("docstring")  Xapian::Stopper::get_description "

Return a string describing this object.

virtual std::string Xapian::Stopper::get_description() const
Xapian::Stopper::get_description";

%feature("docstring")  Xapian::Stopper::release "

Start reference counting this object.

Stopper * Xapian::Stopper::release() Xapian::Stopper::release You can
transfer ownership of a dynamically allocated Stopper object to Xapian
by calling release() and then passing the object to a Xapian method.
Xapian will arrange to delete the object once it is no longer
required. ";

%feature("docstring")  Xapian::Stopper::release "

Start reference counting this object.

const Stopper * Xapian::Stopper::release() const
Xapian::Stopper::release You can transfer ownership of a dynamically
allocated Stopper object to Xapian by calling release() and then
passing the object to a Xapian method. Xapian will arrange to delete
the object once it is no longer required. ";


// File: classXapian_1_1TermGenerator.xml
%feature("docstring") Xapian::TermGenerator "

Parses a piece of text and generate terms.

This module takes a piece of text and parses it to produce words which
are then used to generate suitable terms for indexing. The terms
generated are suitable for use with Query objects produced by the
QueryParser class. ";

%feature("docstring")  Xapian::TermGenerator::TermGenerator "

Copy constructor.

Xapian::TermGenerator::TermGenerator(const TermGenerator &o)
Xapian::TermGenerator::TermGenerator";

%feature("docstring")  Xapian::TermGenerator::TermGenerator "

Move constructor.

Xapian::TermGenerator::TermGenerator(TermGenerator &&o)
Xapian::TermGenerator::TermGenerator";

%feature("docstring")  Xapian::TermGenerator::TermGenerator "

Default constructor.

Xapian::TermGenerator::TermGenerator()
Xapian::TermGenerator::TermGenerator";

%feature("docstring")  Xapian::TermGenerator::~TermGenerator "

Destructor.

Xapian::TermGenerator::~TermGenerator()
Xapian::TermGenerator::~TermGenerator";

%feature("docstring")  Xapian::TermGenerator::set_stemmer "

Set the Xapian::Stem object to be used for generating stemmed terms.

void Xapian::TermGenerator::set_stemmer(const Xapian::Stem &stemmer)
Xapian::TermGenerator::set_stemmer";

%feature("docstring")  Xapian::TermGenerator::set_stopper "

Set the Xapian::Stopper object to be used for identifying stopwords.

void Xapian::TermGenerator::set_stopper(const Xapian::Stopper
*stop=NULL) Xapian::TermGenerator::set_stopper Stemmed forms of
stopwords aren't indexed, but unstemmed forms still are so that
searches for phrases including stop words still work.

Parameters:
-----------

stop:  The Stopper object to set (default NULL, which means no
stopwords). ";

%feature("docstring")  Xapian::TermGenerator::set_document "

Set the current document.

void Xapian::TermGenerator::set_document(const Xapian::Document &doc)
Xapian::TermGenerator::set_document";

%feature("docstring")  Xapian::TermGenerator::get_document "

Get the current document.

const Xapian::Document & Xapian::TermGenerator::get_document() const
Xapian::TermGenerator::get_document";

%feature("docstring")  Xapian::TermGenerator::set_database "

Set the database to index spelling data to.

void Xapian::TermGenerator::set_database(const
Xapian::WritableDatabase &db) Xapian::TermGenerator::set_database";

%feature("docstring")  Xapian::TermGenerator::set_flags "

Set flags.

flags Xapian::TermGenerator::set_flags(flags toggle, flags
mask=flags(0)) Xapian::TermGenerator::set_flags The new value of flags
is: (flags & mask) ^ toggle

To just set the flags, pass the new flags in toggle and the default
value for mask.

Parameters:
-----------

toggle:  Flags to XOR.

mask:  Flags to AND with first.

The old flags setting. ";

%feature("docstring")  Xapian::TermGenerator::set_stemming_strategy "

Set the stemming strategy.

void Xapian::TermGenerator::set_stemming_strategy(stem_strategy
strategy) Xapian::TermGenerator::set_stemming_strategy This method
controls how the stemming algorithm is applied.

Parameters:
-----------

strategy:  The strategy to use - possible values are: STEM_NONE: Don't
perform any stemming - only unstemmed terms are generated.

STEM_SOME: Generate both stemmed (with a \"Z\" prefix) and unstemmed
terms. No positional information is stored for unstemmed terms. This
is the default strategy.

STEM_SOME_FULL_POS: Like STEM_SOME but positional information is
stored for both stemmed and unstemmed terms. Added in Xapian 1.4.8.

STEM_ALL: Generate only stemmed terms (but without a \"Z\" prefix).

STEM_ALL_Z: Generate only stemmed terms (with a \"Z\" prefix).

Added in Xapian 1.3.1. ";

%feature("docstring")  Xapian::TermGenerator::set_stopper_strategy "

Set the stopper strategy.

void Xapian::TermGenerator::set_stopper_strategy(stop_strategy
strategy) Xapian::TermGenerator::set_stopper_strategy The method
controls how the stopper is used.

You need to also call  set_stopper() for this to have any effect.

Parameters:
-----------

strategy:  The strategy to use - possible values are: STOP_NONE: Don't
use the stopper.

STOP_ALL: If a word is identified as a stop word, skip it completely.

STOP_STEMMED: If a word is identified as a stop word, index its
unstemmed form but skip the stem. Unstemmed forms are indexed with
positional information by default, so this allows searches for phrases
containing stopwords to be supported. (This is the default mode).

Added in Xapian 1.4.1. ";

%feature("docstring")  Xapian::TermGenerator::set_max_word_length "

Set the maximum length word to index.

void Xapian::TermGenerator::set_max_word_length(unsigned
max_word_length) Xapian::TermGenerator::set_max_word_length The limit
is on the length of a word prior to stemming and prior to adding any
term prefix.

The backends mostly impose a limit on the length of terms (often of
about 240 bytes), but it's generally useful to have a lower limit to
help prevent the index being bloated by useless junk terms from trying
to indexing things like binary data, uuencoded data, ASCII art, etc.

Parameters:
-----------

max_word_length:  The maximum length word to index, in bytes in UTF-8
representation. Default is 64.

Added in Xapian 1.3.1. ";

%feature("docstring")  Xapian::TermGenerator::index_text "

Index some text.

void Xapian::TermGenerator::index_text(const Xapian::Utf8Iterator
&itor, Xapian::termcount wdf_inc=1, std::string_view prefix={})
Xapian::TermGenerator::index_text

Parameters:
-----------

itor:   Utf8Iterator pointing to the text to index.

wdf_inc:  The wdf increment (default 1).

prefix:  The term prefix to use (default is no prefix). ";

%feature("docstring")  Xapian::TermGenerator::index_text "

Index some text.

void Xapian::TermGenerator::index_text(std::string_view text,
Xapian::termcount wdf_inc=1, std::string_view prefix={})
Xapian::TermGenerator::index_text

Parameters:
-----------

text:  The text to index.

wdf_inc:  The wdf increment (default 1).

prefix:  The term prefix to use (default is no prefix). ";

%feature("docstring")
Xapian::TermGenerator::index_text_without_positions "

Index some text without positional information.

void Xapian::TermGenerator::index_text_without_positions(const
Xapian::Utf8Iterator &itor, Xapian::termcount wdf_inc=1,
std::string_view prefix={})
Xapian::TermGenerator::index_text_without_positions Just like
index_text, but no positional information is generated. This means
that the database will be significantly smaller, but that phrase
searching and NEAR won't be supported.

Parameters:
-----------

itor:   Utf8Iterator pointing to the text to index.

wdf_inc:  The wdf increment (default 1).

prefix:  The term prefix to use (default is no prefix). ";

%feature("docstring")
Xapian::TermGenerator::index_text_without_positions "

Index some text without positional information.

void
Xapian::TermGenerator::index_text_without_positions(std::string_view
text, Xapian::termcount wdf_inc=1, std::string_view prefix={})
Xapian::TermGenerator::index_text_without_positions Just like
index_text, but no positional information is generated. This means
that the database will be significantly smaller, but that phrase
searching and NEAR won't be supported.

Parameters:
-----------

text:  The text to index.

wdf_inc:  The wdf increment (default 1).

prefix:  The term prefix to use (default is no prefix). ";

%feature("docstring")  Xapian::TermGenerator::increase_termpos "

Increase the term position used by index_text.

void Xapian::TermGenerator::increase_termpos(Xapian::termpos
delta=100) Xapian::TermGenerator::increase_termpos This can be used
between indexing text from different fields or other places to prevent
phrase searches from spanning between them (e.g. between the title and
body text, or between two chapters in a book).

Parameters:
-----------

delta:  Amount to increase the term position by (default: 100). ";

%feature("docstring")  Xapian::TermGenerator::get_termpos "

Get the current term position.

Xapian::termpos Xapian::TermGenerator::get_termpos() const
Xapian::TermGenerator::get_termpos";

%feature("docstring")  Xapian::TermGenerator::set_termpos "

Set the current term position.

void Xapian::TermGenerator::set_termpos(Xapian::termpos termpos)
Xapian::TermGenerator::set_termpos

Parameters:
-----------

termpos:  The new term position to set. ";

%feature("docstring")  Xapian::TermGenerator::set_termpos_limit "

Set the term position limit.

void Xapian::TermGenerator::set_termpos_limit(Xapian::termpos
termpos_limit) Xapian::TermGenerator::set_termpos_limit

Parameters:
-----------

termpos_limit:  Upper bound on term positions that can be added.

By default the only limit is the maximum value of the Xapian::termpos
type.

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::TermGenerator::get_description "

Return a string describing this object.

std::string Xapian::TermGenerator::get_description() const
Xapian::TermGenerator::get_description";


// File: classXapian_1_1TermIterator.xml
%feature("docstring") Xapian::TermIterator "

Class for iterating over a list of terms. ";

%feature("docstring")  Xapian::TermIterator::TermIterator "

Copy constructor.

Xapian::TermIterator::TermIterator(const TermIterator &o)
Xapian::TermIterator::TermIterator";

%feature("docstring")  Xapian::TermIterator::TermIterator "

Move constructor.

Xapian::TermIterator::TermIterator(TermIterator &&o)
Xapian::TermIterator::TermIterator";

%feature("docstring")  Xapian::TermIterator::TermIterator "

Default constructor.

Xapian::TermIterator::TermIterator() noexcept
Xapian::TermIterator::TermIterator Creates an uninitialised iterator,
which can't be used before being assigned to, but is sometimes
syntactically convenient. ";

%feature("docstring")  Xapian::TermIterator::~TermIterator "

Destructor.

Xapian::TermIterator::~TermIterator()
Xapian::TermIterator::~TermIterator";

%feature("docstring")  Xapian::TermIterator::get_wdf "

Return the wdf for the term at the current position.

Xapian::termcount Xapian::TermIterator::get_wdf() const
Xapian::TermIterator::get_wdf";

%feature("docstring")  Xapian::TermIterator::get_termfreq "

Return the term frequency for the term at the current position.

Xapian::doccount Xapian::TermIterator::get_termfreq() const
Xapian::TermIterator::get_termfreq Note that for a TermIterator
returned by calling termlist_begin() on a Document object obtained
from a sharded database, this method will return the term frequency
from the shard that the document is in rather than for the combined
database. ";

%feature("docstring")  Xapian::TermIterator::positionlist_count "

Return the length of the position list for the current position.

Xapian::termcount Xapian::TermIterator::positionlist_count() const
Xapian::TermIterator::positionlist_count";

%feature("docstring")  Xapian::TermIterator::positionlist_begin "

Return a PositionIterator for the current term.

PositionIterator Xapian::TermIterator::positionlist_begin() const
Xapian::TermIterator::positionlist_begin";

%feature("docstring")  Xapian::TermIterator::positionlist_end "

Return an end PositionIterator for the current term.

PositionIterator Xapian::TermIterator::positionlist_end() const
noexcept Xapian::TermIterator::positionlist_end";

%feature("docstring")  Xapian::TermIterator::skip_to "

Advance the iterator to term term.

void Xapian::TermIterator::skip_to(std::string_view term)
Xapian::TermIterator::skip_to If the iteration is over an unsorted
list of terms, then this method will throw
Xapian::InvalidOperationError.

Parameters:
-----------

term:  The term to advance to. If this term isn't in the stream being
iterated, then the iterator is moved to the next term after it which
is. ";

%feature("docstring")  Xapian::TermIterator::get_description "

Return a string describing this object.

std::string Xapian::TermIterator::get_description() const
Xapian::TermIterator::get_description";


// File: classXapian_1_1TermListGroup.xml
%feature("docstring") Xapian::TermListGroup "

A class for construction of termlists which store the terms for a
document along with the number of documents it indexes i.e.

term frequency ";

%feature("docstring")  Xapian::TermListGroup::TermListGroup "

Constructor.

Xapian::TermListGroup::TermListGroup(const MSet &docs, const Stopper
*stopper=NULL) Xapian::TermListGroup::TermListGroup

Parameters:
-----------

docs:   MSet object used to construct the TermListGroup

stopper:   Xapian::Stopper object to identify stopwords ";

%feature("docstring")  Xapian::TermListGroup::get_termfreq "

Return the number of documents that the term 'tname' exists in.

doccount Xapian::TermListGroup::get_termfreq(const std::string &tname)
const override Xapian::TermListGroup::get_termfreq

Parameters:
-----------

tname:  The term for which to return the term frequency ";

%feature("docstring")  Xapian::TermListGroup::get_doccount "

Return the number of documents within the MSet.

doccount Xapian::TermListGroup::get_doccount() const override
Xapian::TermListGroup::get_doccount";


// File: classXapian_1_1TfIdfWeight.xml
%feature("docstring") Xapian::TfIdfWeight "

Xapian::Weight subclass implementing the tf-idf weighting scheme. ";

%feature("docstring")  Xapian::TfIdfWeight::TfIdfWeight "

Construct a TfIdfWeight.

Xapian::TfIdfWeight::TfIdfWeight(const std::string &normalizations)
Xapian::TfIdfWeight::TfIdfWeight

Parameters:
-----------

normalizations:  A three character string indicating the
normalizations to be used for the tf(wdf), idf and document weight.
(default: \"ntn\")

The normalizations string works like so:

The first character specifies the normalization for the wdf. The
following normalizations are currently supported:

'n': None. wdfn=wdf

'b': Boolean wdfn=1 if term in document else wdfn=0

's': Square wdfn=wdf*wdf

'l': Logarithmic wdfn=1+loge(wdf)

'P': Pivoted
wdfn=(1+log(1+log(wdf)))*(1/(1-slope+(slope*doclen/avg_len)))+delta

'L': Log average wdfn=(1+log(wdf))/(1+log(doclen/unique_terms))

'm': Max-wdf wdfn=wdf/wdfdocmax

'a': Augmented max-wdf wdfn=0.5+0.5*wdf/wdfdocmax

Support for 'P', 'm' and 'a' was added in Xapian 2.0.0.

The second character indicates the normalization for the idf. The
following normalizations are currently supported:

'n': None idfn=1

't': TfIdf idfn=log(N/Termfreq) where N is the number of documents in
collection and Termfreq is the number of documents which are indexed
by the term t.

'p': Prob idfn=log((N-Termfreq)/Termfreq)

'f': Freq idfn=1/Termfreq

's': Squared idfn=(log(N/Termfreq))²

'P': Pivoted idfn=log((N+1)/Termfreq)

Support for 'P' was added in Xapian 2.0.0.

The third and the final character indicates the normalization for the
document weight. The following normalizations are currently supported:

'n': None wtn=tfn*idfn  Implementing support for more normalizations
of each type would require extending the backend to track more
statistics. ";

%feature("docstring")  Xapian::TfIdfWeight::TfIdfWeight "

Construct a TfIdfWeight.

Xapian::TfIdfWeight::TfIdfWeight(const std::string &normalizations,
double slope, double delta) Xapian::TfIdfWeight::TfIdfWeight

Parameters:
-----------

normalizations:  A three character string indicating the
normalizations to be used for the tf(wdf), idf and document weight.
(default: \"ntn\")

slope:  Extra parameter for \"Pivoted\" tf normalization. (default:
0.2)

delta:  Extra parameter for \"Pivoted\" tf normalization. (default:
1.0)

The normalizations string works like so:

The first character specifies the normalization for the wdf. The
following normalizations are currently supported:

'n': None. wdfn=wdf

'b': Boolean wdfn=1 if term in document else wdfn=0

's': Square wdfn=wdf*wdf

'l': Logarithmic wdfn=1+loge(wdf)

'P': Pivoted
wdfn=(1+log(1+log(wdf)))*(1/(1-slope+(slope*doclen/avg_len)))+delta

'm': Max-wdf wdfn=wdf/wdfdocmax

'a': Augmented max-wdf wdfn=0.5+0.5*wdf/wdfdocmax

Support for 'P', 'm' and 'a' was added in Xapian 2.0.0.

The second character indicates the normalization for the idf. The
following normalizations are currently supported:

'n': None idfn=1

't': TfIdf idfn=log(N/Termfreq) where N is the number of documents in
collection and Termfreq is the number of documents which are indexed
by the term t.

'p': Prob idfn=log((N-Termfreq)/Termfreq)

'f': Freq idfn=1/Termfreq

's': Squared idfn=(log(N/Termfreq))²

'P': Pivoted idfn=log((N+1)/Termfreq)

Support for 'P' was added in Xapian 2.0.0.

The third and the final character indicates the normalization for the
document weight. The following normalizations are currently supported:

'n': None wtn=tfn*idfn  Implementing support for more normalizations
of each type would require extending the backend to track more
statistics. ";

%feature("docstring")  Xapian::TfIdfWeight::TfIdfWeight "

Construct a TfIdfWeight.

Xapian::TfIdfWeight::TfIdfWeight(wdf_norm wdf_normalization, idf_norm
idf_normalization, wt_norm wt_normalization)
Xapian::TfIdfWeight::TfIdfWeight

Parameters:
-----------

wdf_norm_:  The normalization for the wdf.

idf_norm_:  The normalization for the idf.

wt_norm_:  The normalization for the document weight.

Implementing support for more normalizations of each type would
require extending the backend to track more statistics.

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::TfIdfWeight::TfIdfWeight "

Construct a TfIdfWeight.

Xapian::TfIdfWeight::TfIdfWeight(wdf_norm wdf_norm_, idf_norm
idf_norm_, wt_norm wt_norm_, double slope, double delta)
Xapian::TfIdfWeight::TfIdfWeight

Parameters:
-----------

wdf_norm_:  The normalization for the wdf.

idf_norm_:  The normalization for the idf.

wt_norm_:  The normalization for the document weight.

slope:  Extra parameter for \"Pivoted\" tf normalization. (default:
0.2)

delta:  Extra parameter for \"Pivoted\" tf normalization. (default:
1.0)

Implementing support for more normalizations of each type would
require extending the backend to track more statistics.

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::TfIdfWeight::TfIdfWeight "

Construct a TfIdfWeight using the default normalizations (\"ntn\").

Xapian::TfIdfWeight::TfIdfWeight() Xapian::TfIdfWeight::TfIdfWeight";

%feature("docstring")  Xapian::TfIdfWeight::name "

Return the name of this weighting scheme, e.g.

std::string Xapian::TfIdfWeight::name() const
Xapian::TfIdfWeight::name \"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::TfIdfWeight::serialise "

Return this object's parameters serialised as a single string.

std::string Xapian::TfIdfWeight::serialise() const
Xapian::TfIdfWeight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::TfIdfWeight::unserialise "

Unserialise parameters.

TfIdfWeight * Xapian::TfIdfWeight::unserialise(const std::string
&serialised) const Xapian::TfIdfWeight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::TfIdfWeight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

double Xapian::TfIdfWeight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterm,
Xapian::termcount wdfdocmax) const Xapian::TfIdfWeight::get_sumpart
The parameters give information about the document which may be used
in the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::TfIdfWeight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

double Xapian::TfIdfWeight::get_maxpart() const
Xapian::TfIdfWeight::get_maxpart This information is used by the
matcher to perform various optimisations, so strive to make the bound
as tight as possible. ";

%feature("docstring")  Xapian::TfIdfWeight::create_from_parameters "

Create from a human-readable parameter string.

TfIdfWeight * Xapian::TfIdfWeight::create_from_parameters(const char
*params) const Xapian::TfIdfWeight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1TradWeight.xml
%feature("docstring") Xapian::TradWeight "

Xapian::Weight subclass implementing the traditional probabilistic
formula.

This class implements the \"traditional\" Probabilistic Weighting
scheme, as described by the early papers on Probabilistic Retrieval.
BM25 generally gives better results.

TradWeight(k) is equivalent to BM25Weight(k, 0, 0, 1, 0), and since
Xapian 2.0.0 TradWeight is actually implemented as a subclass of
BM25Weight. In earlier versions is was a separate class which was
equivalent except it returned weights (k+1) times smaller.

Deprecated Use BM25Weight(k, 0, 0, 1, 0) instead. ";

%feature("docstring")  Xapian::TradWeight::TradWeight "

Construct a TradWeight.

Xapian::TradWeight::TradWeight(double k=1.0)
Xapian::TradWeight::TradWeight

Parameters:
-----------

k:  A non-negative parameter controlling how influential within-
document- frequency (wdf) and document length are. k=0 means that wdf
and document length don't affect the weights. The larger k is, the
more they do. (default 1) ";


// File: classXapian_1_1UnimplementedError.xml
%feature("docstring") Xapian::UnimplementedError "

UnimplementedError indicates an attempt to use an unimplemented
feature. ";

%feature("docstring")  Xapian::UnimplementedError::UnimplementedError
"

General purpose constructor.

Xapian::UnimplementedError::UnimplementedError(std::string_view msg_,
std::string_view context_={}, int errno_=0)
Xapian::UnimplementedError::UnimplementedError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")  Xapian::UnimplementedError::UnimplementedError
"

Construct from message and errno value.

Xapian::UnimplementedError::UnimplementedError(std::string_view msg_,
int errno_) Xapian::UnimplementedError::UnimplementedError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1UnitRangeProcessor.xml
%feature("docstring") Xapian::UnitRangeProcessor "

Handle a byte unit range.

This class must be used on values which have been encoded using
Xapian::sortable_serialise() which turns numbers into strings which
will sort in the same order as the numbers (the same values can be
used to implement a numeric sort).

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::UnitRangeProcessor::UnitRangeProcessor
"

Constructor.

Xapian::UnitRangeProcessor::UnitRangeProcessor(Xapian::valueno slot_,
std::string_view str_={})
Xapian::UnitRangeProcessor::UnitRangeProcessor

Parameters:
-----------

slot_:  The value slot number to query.

str_:  A string to look for to recognise values as belonging to this
numeric range.

The string supplied in str_ is the prefix plus \":\" that defines the
field upon which the range query is performed.

For example, if str_ is \"size:\", and the range processor has been
added to the queryparser, the queryparser will accept \"size:3K..10K\"
as a valid range. ";


// File: classXapian_1_1Utf8Iterator.xml
%feature("docstring") Xapian::Utf8Iterator "

An iterator which returns Unicode character values from a UTF-8
encoded string. ";

%feature("docstring")  Xapian::Utf8Iterator::raw "

Return the raw const char* pointer for the current position.

const char * Xapian::Utf8Iterator::raw() const
Xapian::Utf8Iterator::raw";

%feature("docstring")  Xapian::Utf8Iterator::left "

Return the number of bytes left in the iterator's buffer.

size_t Xapian::Utf8Iterator::left() const Xapian::Utf8Iterator::left";

%feature("docstring")  Xapian::Utf8Iterator::assign "

Assign a new string to the iterator.

void Xapian::Utf8Iterator::assign(const char *p_, size_t len)
Xapian::Utf8Iterator::assign The iterator will forget the string it
was iterating through, and return characters from the start of the new
string when next called. The string is not copied into the iterator,
so it must remain valid while the iteration is in progress.

Parameters:
-----------

p_:  A pointer to the start of the string to read.

len:  The length of the string to read. ";

%feature("docstring")  Xapian::Utf8Iterator::assign "

Assign a new string to the iterator.

void Xapian::Utf8Iterator::assign(std::string_view s)
Xapian::Utf8Iterator::assign The iterator will forget the string it
was iterating through, and return characters from the start of the new
string when next called. The string is not copied into the iterator,
so it must remain valid while the iteration is in progress.

Parameters:
-----------

s:  The string to read. Must not be modified while the iteration is in
progress. ";

%feature("docstring")  Xapian::Utf8Iterator::Utf8Iterator "

Create an iterator given a pointer and a length.

Xapian::Utf8Iterator::Utf8Iterator(const char *p_, size_t len)
Xapian::Utf8Iterator::Utf8Iterator The iterator will return characters
from the start of the string when next called. The string is not
copied into the iterator, so it must remain valid while the iteration
is in progress.

Parameters:
-----------

p_:  A pointer to the start of the string to read.

len:  The length of the string to read. ";

%feature("docstring")  Xapian::Utf8Iterator::Utf8Iterator "

Create an iterator given a string.

Xapian::Utf8Iterator::Utf8Iterator(std::string_view s)
Xapian::Utf8Iterator::Utf8Iterator The iterator will return characters
from the start of the string when next called. The string is not
copied into the iterator, so it must remain valid while the iteration
is in progress.

Parameters:
-----------

s:  The string to read. Must not be modified while the iteration is in
progress.

This parameter is of type std::string_view, so you can pass in types
which automatically convert to that such as std::string, or a const
char* pointing to a nul-terminated string. ";

%feature("docstring")  Xapian::Utf8Iterator::Utf8Iterator "

Create an iterator which is at the end of its iteration.

Xapian::Utf8Iterator::Utf8Iterator() noexcept
Xapian::Utf8Iterator::Utf8Iterator This can be compared to another
iterator to check if the other iterator has reached its end. ";


// File: classXapian_1_1ValueCountMatchSpy.xml
%feature("docstring") Xapian::ValueCountMatchSpy "

Class for counting the frequencies of values in the matching
documents. ";

%feature("docstring")  Xapian::ValueCountMatchSpy::ValueCountMatchSpy
"

Construct an empty ValueCountMatchSpy.

Xapian::ValueCountMatchSpy::ValueCountMatchSpy()
Xapian::ValueCountMatchSpy::ValueCountMatchSpy";

%feature("docstring")  Xapian::ValueCountMatchSpy::ValueCountMatchSpy
"

Construct a MatchSpy which counts the values in a particular slot.

Xapian::ValueCountMatchSpy::ValueCountMatchSpy(Xapian::valueno slot_)
Xapian::ValueCountMatchSpy::ValueCountMatchSpy";

%feature("docstring")  Xapian::ValueCountMatchSpy::get_total "

Return the total number of documents tallied.

size_t Xapian::ValueCountMatchSpy::get_total() const noexcept
Xapian::ValueCountMatchSpy::get_total";

%feature("docstring")  Xapian::ValueCountMatchSpy::values_begin "

Get an iterator over the values seen in the slot.

TermIterator Xapian::ValueCountMatchSpy::values_begin() const
Xapian::ValueCountMatchSpy::values_begin Items will be returned in
ascending alphabetical order.

During the iteration, the frequency of the current value can be
obtained with the get_termfreq() method on the iterator. ";

%feature("docstring")  Xapian::ValueCountMatchSpy::values_end "

End iterator corresponding to values_begin().

TermIterator Xapian::ValueCountMatchSpy::values_end() const noexcept
Xapian::ValueCountMatchSpy::values_end";

%feature("docstring")  Xapian::ValueCountMatchSpy::top_values_begin "

Get an iterator over the most frequent values seen in the slot.

TermIterator Xapian::ValueCountMatchSpy::top_values_begin(size_t
maxvalues) const Xapian::ValueCountMatchSpy::top_values_begin Items
will be returned in descending order of frequency. Values with the
same frequency will be returned in ascending alphabetical order.

During the iteration, the frequency of the current value can be
obtained with the get_termfreq() method on the iterator.

Parameters:
-----------

maxvalues:  The maximum number of values to return. ";

%feature("docstring")  Xapian::ValueCountMatchSpy::top_values_end "

End iterator corresponding to top_values_begin().

TermIterator Xapian::ValueCountMatchSpy::top_values_end(size_t) const
noexcept Xapian::ValueCountMatchSpy::top_values_end";

%feature("docstring")  Xapian::ValueCountMatchSpy::clone "

Clone the match spy.

virtual MatchSpy * Xapian::ValueCountMatchSpy::clone() const
Xapian::ValueCountMatchSpy::clone The clone should inherit the
configuration of the parent, but need not inherit the state. ie, the
clone does not need to be passed information about the results seen by
the parent.

If you don't want to support the remote backend in your match spy, you
can use the default implementation which simply throws
Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1 ";

%feature("docstring")  Xapian::ValueCountMatchSpy::name "

Return the name of this match spy.

virtual std::string Xapian::ValueCountMatchSpy::name() const
Xapian::ValueCountMatchSpy::name This name is used by the remote
backend. It is passed with the serialised parameters to the remote
server so that it knows which class to create.

Return the full namespace-qualified name of your class here - if your
class is called MyApp::FooMatchSpy, return \"MyApp::FooMatchSpy\" from
this method.

If you don't want to support the remote backend in your match spy, you
can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::ValueCountMatchSpy::serialise "

Return this object's parameters serialised as a single string.

virtual std::string Xapian::ValueCountMatchSpy::serialise() const
Xapian::ValueCountMatchSpy::serialise If you don't want to support the
remote backend in your match spy, you can use the default
implementation which simply throws Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::ValueCountMatchSpy::unserialise "

Unserialise parameters.

virtual MatchSpy * Xapian::ValueCountMatchSpy::unserialise(const
std::string &serialised, const Registry &context) const
Xapian::ValueCountMatchSpy::unserialise This method unserialises
parameters serialised by the  serialise() method and allocates and
returns a new object initialised with them.

If you don't want to support the remote backend in your match spy, you
can use the default implementation which simply throws
Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised results.

context:   Registry object to use for unserialisation to permit
MatchSpy subclasses with sub-MatchSpy objects to be implemented. ";

%feature("docstring")  Xapian::ValueCountMatchSpy::serialise_results "

Serialise the results of this match spy.

virtual std::string Xapian::ValueCountMatchSpy::serialise_results()
const Xapian::ValueCountMatchSpy::serialise_results If you don't want
to support the remote backend in your match spy, you can use the
default implementation which simply throws Xapian::UnimplementedError.
";

%feature("docstring")  Xapian::ValueCountMatchSpy::merge_results "

Unserialise some results, and merge them into this matchspy.

virtual void Xapian::ValueCountMatchSpy::merge_results(const
std::string &serialised) Xapian::ValueCountMatchSpy::merge_results The
order in which results are merged should not be significant, since
this order is not specified (and will vary depending on the speed of
the search in each sub-database).

If you don't want to support the remote backend in your match spy, you
can use the default implementation which simply throws
Xapian::UnimplementedError.

Parameters:
-----------

serialised:  A string containing the serialised results. ";

%feature("docstring")  Xapian::ValueCountMatchSpy::get_description "

Return a string describing this object.

virtual std::string Xapian::ValueCountMatchSpy::get_description()
const Xapian::ValueCountMatchSpy::get_description This default
implementation returns a generic answer, to avoid forcing those
deriving their own MatchSpy subclasses from having to implement this
(they may not care what get_description() gives for their subclass).
";


// File: classXapian_1_1ValueIterator.xml
%feature("docstring") Xapian::ValueIterator "

Class for iterating over document values. ";

%feature("docstring")  Xapian::ValueIterator::ValueIterator "

Copy constructor.

Xapian::ValueIterator::ValueIterator(const ValueIterator &o)
Xapian::ValueIterator::ValueIterator";

%feature("docstring")  Xapian::ValueIterator::ValueIterator "

Move constructor.

Xapian::ValueIterator::ValueIterator(ValueIterator &&o)
Xapian::ValueIterator::ValueIterator";

%feature("docstring")  Xapian::ValueIterator::ValueIterator "

Default constructor.

Xapian::ValueIterator::ValueIterator() noexcept
Xapian::ValueIterator::ValueIterator Creates an uninitialised
iterator, which can't be used before being assigned to, but is
sometimes syntactically convenient. ";

%feature("docstring")  Xapian::ValueIterator::~ValueIterator "

Destructor.

Xapian::ValueIterator::~ValueIterator()
Xapian::ValueIterator::~ValueIterator";

%feature("docstring")  Xapian::ValueIterator::get_docid "

Return the docid at the current position.

Xapian::docid Xapian::ValueIterator::get_docid() const
Xapian::ValueIterator::get_docid If we're iterating over values of a
document, this method will throw Xapian::InvalidOperationError. ";

%feature("docstring")  Xapian::ValueIterator::get_valueno "

Return the value slot number for the current position.

Xapian::valueno Xapian::ValueIterator::get_valueno() const
Xapian::ValueIterator::get_valueno If the iterator is over all values
in a slot, this returns that slot's number. If the iterator is over
the values in a particular document, it returns the number of each
slot in turn. ";

%feature("docstring")  Xapian::ValueIterator::skip_to "

Advance the iterator to document id or value slot docid_or_slot.

void Xapian::ValueIterator::skip_to(Xapian::docid docid_or_slot)
Xapian::ValueIterator::skip_to If this iterator is over values in a
document, then this method advances the iterator to value slot
docid_or_slot, or the first slot after it if there is no value in slot
slot.

If this iterator is over values in a particular slot, then this method
advances the iterator to document id docid_or_slot, or the first
document id after it if there is no value in the slot we're iterating
over for document docid_or_slot.

Note: The \"two-faced\" nature of this method is due to how C++
overloading works. Xapian::docid and Xapian::valueno are both typedefs
for the same unsigned integer type, so overloading can't distinguish
them.

Parameters:
-----------

docid_or_slot:  The docid/slot to advance to. ";

%feature("docstring")  Xapian::ValueIterator::check "

Check if the specified docid occurs.

bool Xapian::ValueIterator::check(Xapian::docid docid)
Xapian::ValueIterator::check The caller is required to ensure that the
specified document id did actually exists in the database.

This method acts like skip_to() if that can be done at little extra
cost, in which case it then returns true. This is how glass databases
behave because they store values in streams which allow for an
efficient implementation of skip_to().

Otherwise it simply checks if a particular docid is present. If it is,
it returns true. If it isn't, it returns false, and leaves the
position unspecified (and hence the result of calling methods which
depend on the current position, such as get_docid(), are also
unspecified). In this state, next() will advance to the first matching
position after document did, and skip_to() will act as it would if the
position was the first matching position after document did.

Currently the inmemory and remote backends behave in the latter way
because they don't support streamed values and so skip_to() must check
each document it skips over which is significantly slower.

Parameters:
-----------

docid:  The document id to check. ";

%feature("docstring")  Xapian::ValueIterator::get_description "

Return a string describing this object.

std::string Xapian::ValueIterator::get_description() const
Xapian::ValueIterator::get_description";


// File: classXapian_1_1ValueMapPostingSource.xml
%feature("docstring") Xapian::ValueMapPostingSource "

A posting source which looks up weights in a map using values as the
key.

This allows will return entries for all documents in the given
database which have a value in the slot specified. The values will be
mapped to the corresponding weight in the weight map. If there is no
mapping for a particular value, the default weight will be returned
(which itself defaults to 0.0). ";

%feature("docstring")
Xapian::ValueMapPostingSource::ValueMapPostingSource "

Construct a ValueMapPostingSource.

Xapian::ValueMapPostingSource::ValueMapPostingSource(Xapian::valueno
slot_) Xapian::ValueMapPostingSource::ValueMapPostingSource

Parameters:
-----------

slot_:  The value slot to read values from. ";

%feature("docstring")  Xapian::ValueMapPostingSource::add_mapping "

Add a mapping.

void Xapian::ValueMapPostingSource::add_mapping(const std::string
&key, double wt) Xapian::ValueMapPostingSource::add_mapping

Parameters:
-----------

key:  The key looked up from the value slot.

wt:  The weight to give this key. ";

%feature("docstring")  Xapian::ValueMapPostingSource::clear_mappings "

Clear all mappings.

void Xapian::ValueMapPostingSource::clear_mappings()
Xapian::ValueMapPostingSource::clear_mappings";

%feature("docstring")
Xapian::ValueMapPostingSource::set_default_weight "

Set a default weight for document values not in the map.

void Xapian::ValueMapPostingSource::set_default_weight(double wt)
Xapian::ValueMapPostingSource::set_default_weight

Parameters:
-----------

wt:  The weight to set as the default. ";

%feature("docstring")  Xapian::ValueMapPostingSource::get_weight "

Return the weight contribution for the current document.

double Xapian::ValueMapPostingSource::get_weight() const override
Xapian::ValueMapPostingSource::get_weight This default implementation
always returns 0, for convenience when implementing \"weight-less\"
PostingSource subclasses.

This method may assume that it will only be called when there is a
\"current document\". In detail: Xapian will always call reset() on a
PostingSource before calling this for the first time. It will also
only call this if the PostingSource reports that it is pointing to a
valid document (ie, it will not call it before calling at least one of
next(), skip_to() or check(), and will ensure that the PostingSource
is not at the end by calling at_end()). ";

%feature("docstring")  Xapian::ValueMapPostingSource::clone "

Clone the posting source.

ValueMapPostingSource * Xapian::ValueMapPostingSource::clone() const
override Xapian::ValueMapPostingSource::clone The clone should inherit
the configuration of the parent, but need not inherit the state. ie,
the clone does not need to be in the same iteration position as the
original: the matcher will always call reset() on the clone before
attempting to move the iterator, or read the information about the
current position of the iterator.

This may return NULL to indicate that cloning is not supported. In
this case, the PostingSource may only be used with a single-database
search.

The default implementation returns NULL.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1 ";

%feature("docstring")  Xapian::ValueMapPostingSource::name "

Name of the posting source class.

std::string Xapian::ValueMapPostingSource::name() const override
Xapian::ValueMapPostingSource::name This is used when serialising and
unserialising posting sources; for example, for performing remote
searches.

If the subclass is in a C++ namespace, the namespace should be
included in the name, using \"::\" as a separator. For example, for a
PostingSource subclass called \"FooPostingSource\" in the \"Xapian\"
namespace the result of this call should be
\"Xapian::FooPostingSource\".

This should only be implemented if serialise() and unserialise() are
also implemented. The default implementation returns an empty string.

If this returns an empty string, Xapian will assume that serialise()
and unserialise() are not implemented. ";

%feature("docstring")  Xapian::ValueMapPostingSource::serialise "

Serialise object parameters into a string.

std::string Xapian::ValueMapPostingSource::serialise() const override
Xapian::ValueMapPostingSource::serialise The serialised parameters
should represent the configuration of the posting source, but need not
(indeed, should not) represent the current iteration state.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.
";

%feature("docstring")  Xapian::ValueMapPostingSource::unserialise "

Create object given string serialisation returned by serialise().

ValueMapPostingSource *
Xapian::ValueMapPostingSource::unserialise(const std::string
&serialised) const override Xapian::ValueMapPostingSource::unserialise
Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Parameters:
-----------

serialised:  A serialised instance of this PostingSource subclass. ";

%feature("docstring")  Xapian::ValueMapPostingSource::reset "

Set this PostingSource to the start of the list of postings.

void Xapian::ValueMapPostingSource::reset(const Database &db_,
Xapian::doccount shard_index) override
Xapian::ValueMapPostingSource::reset This is called automatically by
the matcher prior to each query being processed.

If a PostingSource is used for multiple searches,  reset() will
therefore be called multiple times, and must handle this by using the
database passed in the most recent call.

Parameters:
-----------

db:  The database which the PostingSource should iterate through.

shard_index:  The 0-based index indicating which shard in a multi-
database db is. This can be useful if you have an external source of
postings corresponding to each shard.

Note: in the case of a multi-database search, a separate PostingSource
will be used for each database (the separate PostingSources will be
obtained using  clone()), and each PostingSource will be passed one of
the sub-databases as the db parameter here. The db parameter will
therefore always refer to a single database. All docids passed to, or
returned from, the PostingSource refer to docids in that single
database, rather than in the multi- database.

A default implementation is provided which calls the older init()
method to allow existing subclasses to continue to work, but the
default implementation of init() throws Xapian::InvalidOperationError
so you must override either this method or init(). In new code,
override this method in preference.

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::ValueMapPostingSource::get_description
"

Return a string describing this object.

std::string Xapian::ValueMapPostingSource::get_description() const
override Xapian::ValueMapPostingSource::get_description This default
implementation returns a generic answer. This default it provided to
avoid forcing those deriving their own PostingSource subclass from
having to implement this (they may not care what get_description()
gives for their subclass). ";


// File: classXapian_1_1ValuePostingSource.xml
%feature("docstring") Xapian::ValuePostingSource "

A posting source which generates weights from a value slot.

This is a base class for classes which generate weights using values
stored in the specified slot. For example, ValueWeightPostingSource
uses sortable_unserialise to convert values directly to weights.

The upper bound on the weight returned is set to DBL_MAX. Subclasses
should call set_maxweight() in their init() methods after calling
ValuePostingSource::init() if they know a tighter bound on the weight.
";

%feature("docstring")  Xapian::ValuePostingSource::ValuePostingSource
"

Construct a ValuePostingSource.

Xapian::ValuePostingSource::ValuePostingSource(Xapian::valueno slot_)
noexcept Xapian::ValuePostingSource::ValuePostingSource

Parameters:
-----------

slot_:  The value slot to read values from. ";

%feature("docstring")  Xapian::ValuePostingSource::get_termfreq_min "

A lower bound on the number of documents this object can return.

Xapian::doccount Xapian::ValuePostingSource::get_termfreq_min() const
Xapian::ValuePostingSource::get_termfreq_min  Xapian will always call
reset() on a PostingSource before calling this for the first time. ";

%feature("docstring")  Xapian::ValuePostingSource::get_termfreq_est "

An estimate of the number of documents this object can return.

Xapian::doccount Xapian::ValuePostingSource::get_termfreq_est() const
Xapian::ValuePostingSource::get_termfreq_est It must always be true
that:

get_termfreq_min() <= get_termfreq_est() <= get_termfreq_max()

Xapian will always call reset() on a PostingSource before calling this
for the first time. ";

%feature("docstring")  Xapian::ValuePostingSource::get_termfreq_max "

An upper bound on the number of documents this object can return.

Xapian::doccount Xapian::ValuePostingSource::get_termfreq_max() const
Xapian::ValuePostingSource::get_termfreq_max  Xapian will always call
reset() on a PostingSource before calling this for the first time. ";

%feature("docstring")  Xapian::ValuePostingSource::next "

Advance the current position to the next matching document.

void Xapian::ValuePostingSource::next(double min_wt)
Xapian::ValuePostingSource::next The PostingSource starts before the
first entry in the list, so next(), skip_to() or check() must be
called before any methods which need the context of the current
position.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Parameters:
-----------

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")  Xapian::ValuePostingSource::skip_to "

Advance to the specified docid.

void Xapian::ValuePostingSource::skip_to(Xapian::docid min_docid,
double min_wt) Xapian::ValuePostingSource::skip_to If the specified
docid isn't in the list, position ourselves on the first document
after it (or at_end() if no greater docids are present).

If the current position is already the specified docid, this method
will leave the position unmodified.

If the specified docid is earlier than the current position, the
behaviour is unspecified. A sensible behaviour would be to leave the
current position unmodified, but it is also reasonable to move to the
specified docid.

The default implementation calls next() repeatedly, which works but
skip_to() can often be implemented much more efficiently.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Note: in the case of a multi-database search, the docid specified is
the docid in the single subdatabase relevant to this posting source.
See the  reset() method for details.

Parameters:
-----------

did:  The document id to advance to.

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")  Xapian::ValuePostingSource::check "

Check if the specified docid occurs.

bool Xapian::ValuePostingSource::check(Xapian::docid min_docid, double
min_wt) Xapian::ValuePostingSource::check The caller is required to
ensure that the specified document id did actually exists in the
database. If it does, it must move to that document id, and return
true. If it does not, it may either:

return true, having moved to a definite position (including
\"at_end\"), which must be the same position as skip_to() would have
moved to.

or

return false, having moved to an \"indeterminate\" position, such that
a subsequent call to next() or skip_to() will move to the next
matching position after did.

Generally, this method should act like skip_to() and return true if
that can be done at little extra cost.

Otherwise it should simply check if a particular docid is present,
returning true if it is, and false if it isn't.

The default implementation calls skip_to() and always returns true.

Xapian will always call reset() on a PostingSource before calling this
for the first time.

Note: in the case of a multi-database search, the docid specified is
the docid in the single subdatabase relevant to this posting source.
See the  reset() method for details.

Parameters:
-----------

did:  The document id to check.

min_wt:  The minimum weight contribution that is needed (this is just
a hint which subclasses may ignore). ";

%feature("docstring")  Xapian::ValuePostingSource::at_end "

Return true if the current position is past the last entry in this
list.

bool Xapian::ValuePostingSource::at_end() const
Xapian::ValuePostingSource::at_end At least one of  next(),  skip_to()
or  check() will be called before this method is first called. ";

%feature("docstring")  Xapian::ValuePostingSource::get_docid "

Return the current docid.

Xapian::docid Xapian::ValuePostingSource::get_docid() const
Xapian::ValuePostingSource::get_docid This method may assume that it
will only be called when there is a \"current document\". See
get_weight() for details.

Note: in the case of a multi-database search, the returned docid
should be in the single subdatabase relevant to this posting source.
See the  reset() method for details. ";

%feature("docstring")  Xapian::ValuePostingSource::reset "

Set this PostingSource to the start of the list of postings.

void Xapian::ValuePostingSource::reset(const Database &db_,
Xapian::doccount shard_index) Xapian::ValuePostingSource::reset This
is called automatically by the matcher prior to each query being
processed.

If a PostingSource is used for multiple searches,  reset() will
therefore be called multiple times, and must handle this by using the
database passed in the most recent call.

Parameters:
-----------

db:  The database which the PostingSource should iterate through.

shard_index:  The 0-based index indicating which shard in a multi-
database db is. This can be useful if you have an external source of
postings corresponding to each shard.

Note: in the case of a multi-database search, a separate PostingSource
will be used for each database (the separate PostingSources will be
obtained using  clone()), and each PostingSource will be passed one of
the sub-databases as the db parameter here. The db parameter will
therefore always refer to a single database. All docids passed to, or
returned from, the PostingSource refer to docids in that single
database, rather than in the multi- database.

A default implementation is provided which calls the older init()
method to allow existing subclasses to continue to work, but the
default implementation of init() throws Xapian::InvalidOperationError
so you must override either this method or init(). In new code,
override this method in preference.

Added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::ValuePostingSource::get_database "

The database we're reading values from.

Xapian::Database Xapian::ValuePostingSource::get_database() const
Xapian::ValuePostingSource::get_database

Added in 1.2.23 and 1.3.5. ";

%feature("docstring")  Xapian::ValuePostingSource::get_slot "

The slot we're reading values from.

Xapian::valueno Xapian::ValuePostingSource::get_slot() const
Xapian::ValuePostingSource::get_slot

Added in 1.2.23 and 1.3.5. ";

%feature("docstring")  Xapian::ValuePostingSource::get_value "

Read current value.

std::string Xapian::ValuePostingSource::get_value() const
Xapian::ValuePostingSource::get_value

Added in 1.2.23 and 1.3.5. ";

%feature("docstring")  Xapian::ValuePostingSource::done "

End the iteration.

void Xapian::ValuePostingSource::done()
Xapian::ValuePostingSource::done Calls to at_end() will return true
after calling this method.

Added in 1.2.23 and 1.3.5. ";

%feature("docstring")  Xapian::ValuePostingSource::get_started "

Flag indicating if we've started (true if we have).

bool Xapian::ValuePostingSource::get_started() const
Xapian::ValuePostingSource::get_started

Added in 1.2.23 and 1.3.5. ";

%feature("docstring")  Xapian::ValuePostingSource::set_termfreq_min "

Set a lower bound on the term frequency.

void Xapian::ValuePostingSource::set_termfreq_min(Xapian::doccount
termfreq_min_) Xapian::ValuePostingSource::set_termfreq_min Subclasses
should set this if they are overriding the next(), skip_to() or
check() methods to return fewer documents.

Added in 1.2.23 and 1.3.5. ";

%feature("docstring")  Xapian::ValuePostingSource::set_termfreq_est "

An estimate of the term frequency.

void Xapian::ValuePostingSource::set_termfreq_est(Xapian::doccount
termfreq_est_) Xapian::ValuePostingSource::set_termfreq_est Subclasses
should set this if they are overriding the next(), skip_to() or
check() methods.

Added in 1.2.23 and 1.3.5. ";

%feature("docstring")  Xapian::ValuePostingSource::set_termfreq_max "

An upper bound on the term frequency.

void Xapian::ValuePostingSource::set_termfreq_max(Xapian::doccount
termfreq_max_) Xapian::ValuePostingSource::set_termfreq_max Subclasses
should set this if they are overriding the next(), skip_to() or
check() methods.

Added in 1.2.23 and 1.3.5. ";

%feature("docstring")  Xapian::ValuePostingSource::get_description "

Return a string describing this object.

std::string Xapian::ValuePostingSource::get_description() const
Xapian::ValuePostingSource::get_description This default
implementation returns a generic answer. This default it provided to
avoid forcing those deriving their own PostingSource subclass from
having to implement this (they may not care what get_description()
gives for their subclass). ";


// File: classXapian_1_1ValueSetMatchDecider.xml
%feature("docstring") Xapian::ValueSetMatchDecider "

MatchDecider filtering results based on whether document values are in
a user- defined set. ";

%feature("docstring")
Xapian::ValueSetMatchDecider::ValueSetMatchDecider "

Construct a ValueSetMatchDecider.

Xapian::ValueSetMatchDecider::ValueSetMatchDecider(Xapian::valueno
slot, bool inclusive_)
Xapian::ValueSetMatchDecider::ValueSetMatchDecider

Parameters:
-----------

slot:  The value slot number to look in.

inclusive_:  If true, match decider accepts documents which have a
value in the specified slot which is a member of the test set; if
false, match decider accepts documents which do not have a value in
the specified slot. ";

%feature("docstring")  Xapian::ValueSetMatchDecider::add_value "

Add a value to the test set.

void Xapian::ValueSetMatchDecider::add_value(const std::string &value)
Xapian::ValueSetMatchDecider::add_value

Parameters:
-----------

value:  The value to add to the test set. ";

%feature("docstring")  Xapian::ValueSetMatchDecider::remove_value "

Remove a value from the test set.

void Xapian::ValueSetMatchDecider::remove_value(const std::string
&value) Xapian::ValueSetMatchDecider::remove_value

Parameters:
-----------

value:  The value to remove from the test set. ";


// File: classXapian_1_1ValueWeightPostingSource.xml
%feature("docstring") Xapian::ValueWeightPostingSource "

A posting source which reads weights from a value slot.

This returns entries for all documents in the given database which
have a non empty values in the specified slot. It returns a weight
calculated by applying sortable_unserialise to the value stored in the
slot (so the values stored should probably have been calculated by
applying sortable_serialise to a floating point number at index time).

The upper bound on the weight returned is set using the upper bound on
the values in the specified slot, or DBL_MAX if value bounds aren't
supported by the current backend.

For efficiency, this posting source doesn't check that the stored
values are valid in any way, so it will never raise an exception due
to invalid stored values. In particular, it doesn't ensure that the
unserialised values are positive, which is a requirement for weights.
The behaviour if the slot contains values which unserialise to
negative values is undefined. ";

%feature("docstring")
Xapian::ValueWeightPostingSource::ValueWeightPostingSource "

Construct a ValueWeightPostingSource.

Xapian::ValueWeightPostingSource::ValueWeightPostingSource(Xapian::valueno
slot_) Xapian::ValueWeightPostingSource::ValueWeightPostingSource

Parameters:
-----------

slot_:  The value slot to read values from. ";

%feature("docstring")  Xapian::ValueWeightPostingSource::get_weight "

Return the weight contribution for the current document.

double Xapian::ValueWeightPostingSource::get_weight() const
Xapian::ValueWeightPostingSource::get_weight This default
implementation always returns 0, for convenience when implementing
\"weight-less\" PostingSource subclasses.

This method may assume that it will only be called when there is a
\"current document\". In detail: Xapian will always call reset() on a
PostingSource before calling this for the first time. It will also
only call this if the PostingSource reports that it is pointing to a
valid document (ie, it will not call it before calling at least one of
next(), skip_to() or check(), and will ensure that the PostingSource
is not at the end by calling at_end()). ";

%feature("docstring")  Xapian::ValueWeightPostingSource::clone "

Clone the posting source.

ValueWeightPostingSource * Xapian::ValueWeightPostingSource::clone()
const Xapian::ValueWeightPostingSource::clone The clone should inherit
the configuration of the parent, but need not inherit the state. ie,
the clone does not need to be in the same iteration position as the
original: the matcher will always call reset() on the clone before
attempting to move the iterator, or read the information about the
current position of the iterator.

This may return NULL to indicate that cloning is not supported. In
this case, the PostingSource may only be used with a single-database
search.

The default implementation returns NULL.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1 ";

%feature("docstring")  Xapian::ValueWeightPostingSource::name "

Name of the posting source class.

std::string Xapian::ValueWeightPostingSource::name() const
Xapian::ValueWeightPostingSource::name This is used when serialising
and unserialising posting sources; for example, for performing remote
searches.

If the subclass is in a C++ namespace, the namespace should be
included in the name, using \"::\" as a separator. For example, for a
PostingSource subclass called \"FooPostingSource\" in the \"Xapian\"
namespace the result of this call should be
\"Xapian::FooPostingSource\".

This should only be implemented if serialise() and unserialise() are
also implemented. The default implementation returns an empty string.

If this returns an empty string, Xapian will assume that serialise()
and unserialise() are not implemented. ";

%feature("docstring")  Xapian::ValueWeightPostingSource::serialise "

Serialise object parameters into a string.

std::string Xapian::ValueWeightPostingSource::serialise() const
Xapian::ValueWeightPostingSource::serialise The serialised parameters
should represent the configuration of the posting source, but need not
(indeed, should not) represent the current iteration state.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.
";

%feature("docstring")  Xapian::ValueWeightPostingSource::unserialise "

Create object given string serialisation returned by serialise().

ValueWeightPostingSource *
Xapian::ValueWeightPostingSource::unserialise(const std::string
&serialised) const Xapian::ValueWeightPostingSource::unserialise Note
that the returned object will be deallocated by Xapian after use with
\"delete\". If you want to handle the deletion in a special way (for
example when wrapping the Xapian API for use from another language)
then you can define a static operator delete method in your subclass
as shown here:https://trac.xapian.org/ticket/554#comment:1

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Parameters:
-----------

serialised:  A serialised instance of this PostingSource subclass. ";

%feature("docstring")  Xapian::ValueWeightPostingSource::reset "

Set this PostingSource to the start of the list of postings.

void Xapian::ValueWeightPostingSource::reset(const Database &db_,
Xapian::doccount shard_index) Xapian::ValueWeightPostingSource::reset
This is called automatically by the matcher prior to each query being
processed.

If a PostingSource is used for multiple searches,  reset() will
therefore be called multiple times, and must handle this by using the
database passed in the most recent call.

Parameters:
-----------

db:  The database which the PostingSource should iterate through.

shard_index:  The 0-based index indicating which shard in a multi-
database db is. This can be useful if you have an external source of
postings corresponding to each shard.

Note: in the case of a multi-database search, a separate PostingSource
will be used for each database (the separate PostingSources will be
obtained using  clone()), and each PostingSource will be passed one of
the sub-databases as the db parameter here. The db parameter will
therefore always refer to a single database. All docids passed to, or
returned from, the PostingSource refer to docids in that single
database, rather than in the multi- database.

A default implementation is provided which calls the older init()
method to allow existing subclasses to continue to work, but the
default implementation of init() throws Xapian::InvalidOperationError
so you must override either this method or init(). In new code,
override this method in preference.

Added in Xapian 2.0.0. ";

%feature("docstring")
Xapian::ValueWeightPostingSource::get_description "

Return a string describing this object.

std::string Xapian::ValueWeightPostingSource::get_description() const
Xapian::ValueWeightPostingSource::get_description This default
implementation returns a generic answer. This default it provided to
avoid forcing those deriving their own PostingSource subclass from
having to implement this (they may not care what get_description()
gives for their subclass). ";


// File: classXapian_1_1Weight.xml
%feature("docstring") Xapian::Weight "

Abstract base class for weighting schemes. ";

%feature("docstring")  Xapian::Weight::Weight "

Default constructor, needed by subclass constructors.

Xapian::Weight::Weight() Xapian::Weight::Weight";

%feature("docstring")  Xapian::Weight::~Weight "

Virtual destructor, because we have virtual methods.

virtual Xapian::Weight::~Weight() Xapian::Weight::~Weight";

%feature("docstring")  Xapian::Weight::clone "

Clone this object.

virtual Weight * Xapian::Weight::clone() const =0
Xapian::Weight::clone This method allocates and returns a copy of the
object it is called on.

If your subclass is called FooWeight and has parameters a and b, then
you would implement FooWeight::clone() like so:

FooWeight * FooWeight::clone() const { return new FooWeight(a, b); }

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1 ";

%feature("docstring")  Xapian::Weight::name "

Return the name of this weighting scheme, e.g.

virtual std::string Xapian::Weight::name() const Xapian::Weight::name
\"bm25+\".

This is the name that the weighting scheme gets registered under when
passed to Xapian:Registry::register_weighting_scheme().

As a result:

this is the name that needs to be used in Weight::create() to create a
Weight object from a human-readable string description.

it is also used by the remote backend where it is sent (along with the
serialised parameters) to the remote server so that it knows which
class to create.

For 1.4.x and earlier we recommended returning the full namespace-
qualified name of your class here, but now we recommend returning a
just the name in lower case, e.g. \"foo\" instead of \"FooWeight\",
\"bm25+\" instead of \"Xapian::BM25PlusWeight\".

If you don't want to support creation via Weight::create() or the
remote backend, you can use the default implementation which simply
returns an empty string. ";

%feature("docstring")  Xapian::Weight::serialise "

Return this object's parameters serialised as a single string.

virtual std::string Xapian::Weight::serialise() const
Xapian::Weight::serialise If you don't want to support the remote
backend, you can use the default implementation which simply throws
Xapian::UnimplementedError. ";

%feature("docstring")  Xapian::Weight::unserialise "

Unserialise parameters.

virtual Weight * Xapian::Weight::unserialise(const std::string
&serialised) const Xapian::Weight::unserialise This method
unserialises parameters serialised by the  serialise() method and
allocates and returns a new object initialised with them.

If you don't want to support the remote backend, you can use the
default implementation which simply throws Xapian::UnimplementedError.

Note that the returned object will be deallocated by Xapian after use
with \"delete\". If you want to handle the deletion in a special way
(for example when wrapping the Xapian API for use from another
language) then you can define a static operator delete method in your
subclass as shown here:https://trac.xapian.org/ticket/554#comment:1

Parameters:
-----------

serialised:  A string containing the serialised parameters. ";

%feature("docstring")  Xapian::Weight::get_sumpart "

Calculate the weight contribution for this object's term to a
document.

virtual double Xapian::Weight::get_sumpart(Xapian::termcount wdf,
Xapian::termcount doclen, Xapian::termcount uniqterms,
Xapian::termcount wdfdocmax) const =0 Xapian::Weight::get_sumpart The
parameters give information about the document which may be used in
the calculations:

Parameters:
-----------

wdf:  The within document frequency of the term in the document. You
need to call need_stat(WDF) if you use this value.

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

You can rely of wdf <= doclen if you call both need_stat(WDF) and
need_stat(DOC_LENGTH) - this is trivially true for terms, but Xapian
also ensure it's true for OP_SYNONYM, where the wdf is approximated.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Weight::get_maxpart "

Return an upper bound on what get_sumpart() can return for any
document.

virtual double Xapian::Weight::get_maxpart() const =0
Xapian::Weight::get_maxpart This information is used by the matcher to
perform various optimisations, so strive to make the bound as tight as
possible. ";

%feature("docstring")  Xapian::Weight::get_sumextra "

Calculate the term-independent weight component for a document.

virtual double Xapian::Weight::get_sumextra(Xapian::termcount doclen,
Xapian::termcount uniqterms, Xapian::termcount wdfdocmax) const
Xapian::Weight::get_sumextra The default implementation always returns
0 (in Xapian < 2.0.0 this was a pure virtual method).

The parameter gives information about the document which may be used
in the calculations:

Parameters:
-----------

doclen:  The document's length (unnormalised). You need to call
need_stat(DOC_LENGTH) if you use this value.

uniqterms:  Number of unique terms in the document. You need to call
need_stat(UNIQUE_TERMS) if you use this value.

wdfdocmax:  Maximum wdf value in the document. You need to call
need_stat(WDF_DOC_MAX) if you use this value.

The wdfdocmax parameter was added in Xapian 2.0.0. ";

%feature("docstring")  Xapian::Weight::get_maxextra "

Return an upper bound on what get_sumextra() can return for any
document.

virtual double Xapian::Weight::get_maxextra() const
Xapian::Weight::get_maxextra The default implementation always returns
0 (in Xapian < 2.0.0 this was a pure virtual method).

This information is used by the matcher to perform various
optimisations, so strive to make the bound as tight as possible. ";

%feature("docstring")  Xapian::Weight::create_from_parameters "

Create from a human-readable parameter string.

virtual Weight * Xapian::Weight::create_from_parameters(const char
*params) const Xapian::Weight::create_from_parameters

Parameters:
-----------

params:  string containing weighting scheme parameter values.

2.0.0 ";


// File: classXapian_1_1WildcardError.xml
%feature("docstring") Xapian::WildcardError "

WildcardError indicates an error expanding a wildcarded query. ";

%feature("docstring")  Xapian::WildcardError::WildcardError "

General purpose constructor.

Xapian::WildcardError::WildcardError(std::string_view msg_,
std::string_view context_={}, int errno_=0)
Xapian::WildcardError::WildcardError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

context_:  Optional context information for this error.

errno_:  Optional errno value associated with this error. ";

%feature("docstring")  Xapian::WildcardError::WildcardError "

Construct from message and errno value.

Xapian::WildcardError::WildcardError(std::string_view msg_, int
errno_) Xapian::WildcardError::WildcardError

Parameters:
-----------

msg_:  Message giving details of the error, intended for human
consumption.

errno_:  Optional errno value associated with this error. ";


// File: classXapian_1_1WritableDatabase.xml
%feature("docstring") Xapian::WritableDatabase "

This class provides read/write access to a database.

A WritableDatabase object contains zero or more shards, and operations
are performed across these shards. Documents added by add_document()
are stored to the shards in a round-robin fashion.

2.0.0 This class is a reference counted handle like many other Xapian
API classes. In earlier versions, it worked like a typedef to
std::vector<database_shard>. The key difference is that previously
copying or assigning a Xapian::Database made a deep copy, whereas now
it makes a shallow copy.  Most methods can throw:

Parameters:
-----------

Xapian::DatabaseCorruptError:  if database corruption is detected

Xapian::DatabaseError:  in various situation (for example, calling
methods after  close() has been called)

Xapian::NetworkError:  when remote databases are in use ";

%feature("docstring")  Xapian::WritableDatabase::WritableDatabase "

Create a WritableDatabase with no subdatabases.

Xapian::WritableDatabase::WritableDatabase()
Xapian::WritableDatabase::WritableDatabase The created object isn't
very useful in this state - it's intended as a placeholder value. ";

%feature("docstring")  Xapian::WritableDatabase::add_database "

Add shards from another WritableDatabase.

void Xapian::WritableDatabase::add_database(const WritableDatabase
&other) Xapian::WritableDatabase::add_database Any shards in other are
added to the list of shards in this object. The shards are reference
counted and also remain in other.

Parameters:
-----------

other:  Another WritableDatabase to add shards from

Parameters:
-----------

Xapian::InvalidArgumentError:  if other is the same object as this. ";

%feature("docstring")  Xapian::WritableDatabase::WritableDatabase "

Create or open a Xapian database for both reading and writing.

Xapian::WritableDatabase::WritableDatabase(std::string_view path, int
flags=0, int block_size=0) Xapian::WritableDatabase::WritableDatabase

Parameters:
-----------

path:  Filing system path for the database. If creating a new database
with a backend which uses a directory of files (such as glass does by
default) then Xapian will create a directory for path if necessary
(but the parent directory must already exist).

flags:  A bitwise-or (| in C++) combination of:

at most one of the following constants indicating how to handle the
database already existing or not (the default action is
Xapian::DB_CREATE_OR_OPEN):

Constant

DB exists

DB doesn't exist

Xapian::DB_CREATE_OR_OPEN

open

create

Xapian::DB_CREATE

fail

create

Xapian::DB_CREATE_OR_OVERWRITE

overwrite

create

Xapian::DB_OPEN

open

fail

at most one of the follow constants indicating which backend to use
when creating a new database, ignored when opening or overwriting an
existing database (default: currently Xapian::DB_BACKEND_GLASS):

Constant

Meaning

Xapian::DB_BACKEND_GLASS

Create a glass database

Xapian::DB_BACKEND_INMEMORY

Create inmemory DB (ignores path)

any number of the following flags:  Xapian::DB_NO_SYNC don't call
fsync() or similar

Xapian::DB_FULL_SYNC try harder to ensure data is safe

Xapian::DB_DANGEROUS don't be crash-safe, no concurrent readers

Xapian::DB_NO_TERMLIST don't use a termlist table

Xapian::DB_RETRY_LOCK to wait to get a write lock

Parameters:
-----------

block_size:  The block size in bytes to use when creating a new
database. This is ignored when opening an existing database, and by
backends which don't have the concept of a block size. The glass
backend allows block sizes which are a power of 2 between 2048 and
65536 (inclusive) and its default (also used instead of an invalid
value) is 8192 bytes.

Parameters:
-----------

Xapian::DatabaseLockError:  is thrown if the database's write lock
could not be acquired.

Xapian::DatabaseOpeningError:  if the specified database cannot be
opened

Xapian::DatabaseVersionError:  if the specified database has a format
too old or too new to be supported. ";

%feature("docstring")  Xapian::WritableDatabase::WritableDatabase "

Copy constructor.

Xapian::WritableDatabase::WritableDatabase(const WritableDatabase &o)
Xapian::WritableDatabase::WritableDatabase The internals are reference
counted, so copying is cheap. ";

%feature("docstring")  Xapian::WritableDatabase::WritableDatabase "

Move constructor.

Xapian::WritableDatabase::WritableDatabase(WritableDatabase &&o)
Xapian::WritableDatabase::WritableDatabase";

%feature("docstring")  Xapian::WritableDatabase::commit "

Commit pending modifications.

void Xapian::WritableDatabase::commit()
Xapian::WritableDatabase::commit Updates to a Xapian database are more
efficient when applied in bulk, so by default Xapian stores
modifications in memory until a threshold is exceeded and then they
are committed to disk.

When the database is closed (by an explicit call to close() or its
destructor being called) then commit() is implicitly called unless a
transaction is active.

You can force any such pending modifications to be committed by
calling this method, but bear in mind that the batching happens for a
reason and calling commit() a lot is likely to slow down indexing.

If the commit operation succeeds then the changes are reliably written
to disk and available to readers. If the commit operation fails, then
any pending modifications are discarded.

However, note that if called on a sharded database, atomicity isn't
guaranteed between shards - it's possible for the changes to one shard
to be committed but changes to another shard to fail.

It's not valid to call commit() within a transaction - see
begin_transaction() for more details of how transactions work in
Xapian.

Currently batched modifications are automatically committed every
10000 documents added, deleted, or modified. This value is rather
conservative, and if you have a machine with plenty of memory, you can
improve indexing throughput dramatically by setting
XAPIAN_FLUSH_THRESHOLD in the environment to a larger value.

This method was new in Xapian 1.1.0 - in earlier versions it was
called flush(). ";

%feature("docstring")  Xapian::WritableDatabase::begin_transaction "

Begin a transaction.

void Xapian::WritableDatabase::begin_transaction(bool flushed=true)
Xapian::WritableDatabase::begin_transaction A Xapian transaction is a
set of consecutive modifications to be committed as an atomic unit -
in any committed revision of the database either none are present or
they all are.

However, note that if called on a sharded database, atomicity isn't
guaranteed between shards. Within each shard, the transaction will
still act atomically.

A transaction is started with begin_transaction() and can either be
completed by calling commit_transaction() or aborted by calling
cancel_transaction().

Closing the database (by an explicit call to close() or by its
destructor being called) when a transaction is active will implicitly
call cancel_transaction() to abort the transaction and discard the
changes in it.

By default, commit() is implicitly called by begin_transaction() and
commit_transaction() so that the changes in the transaction are
committed or not independent of changes before or after it.

The downside of these implicit calls to commit() is that small
transactions can harm indexing performance in the same way that
explicitly calling commit() frequently can.

If you're applying atomic groups of changes and only wish to ensure
that each group is either applied or not applied, then you can prevent
the automatic commit() before and after the transaction by starting
the transaction with begin_transaction(false). However, if
cancel_transaction() is called (or if commit_transaction() isn't
called before the WritableDatabase object is destroyed) then any
changes which were pending before the transaction began will also be
discarded.

Parameters:
-----------

flushed:  Is this a flushed transaction? By default transactions are
\"flushed\", which means that committing a transaction will ensure
those changes are permanently written to the database. By contrast,
unflushed transactions only ensure that changes within the transaction
are either all applied or all aren't.

Parameters:
-----------

Xapian::UnimplementedError:  is thrown if this is an InMemory
database, which don't currently support transactions.

Xapian::InvalidOperationError:  will be thrown if a transaction is
already active. ";

%feature("docstring")  Xapian::WritableDatabase::commit_transaction "

Complete the transaction currently in progress.

void Xapian::WritableDatabase::commit_transaction()
Xapian::WritableDatabase::commit_transaction If the transaction was
begun as a flushed transaction then the changes in it have been
committed to the database upon successful completion of this method.

If an exception is thrown, then the changes in the transaction will be
discarded (if the transaction was not begun as a flushed transaction,
any changes made but not committed before begin_transaction() will
also be discarded).

In all cases the transaction will no longer be in progress.

Note that if called on a sharded database, atomicity isn't guaranteed
between shards. Within each shard, the transaction will still act
atomically.

Parameters:
-----------

Xapian::UnimplementedError:  is thrown if this is an InMemory
database, which don't currently support transactions.

Xapian::InvalidOperationError:  is thrown if no transaction was
active. ";

%feature("docstring")  Xapian::WritableDatabase::cancel_transaction "

Abort the transaction currently in progress.

void Xapian::WritableDatabase::cancel_transaction()
Xapian::WritableDatabase::cancel_transaction Changes made within the
current transaction will be discarded (if the transaction was not
begun as a flushed transaction, any changes made but not committed
before begin_transaction() will also be discarded).

Parameters:
-----------

Xapian::UnimplementedError:  is thrown if this is an InMemory
database, which don't currently support transactions.

Xapian::InvalidOperationError:  is thrown if no transaction was
active. ";

%feature("docstring")  Xapian::WritableDatabase::add_document "

Add a document to the database.

Xapian::docid Xapian::WritableDatabase::add_document(const
Xapian::Document &doc) Xapian::WritableDatabase::add_document The
document is allocated document ID ( get_lastdocid() + 1) - the next
highest document ID which has never previously been used by this
database (so docids from deleted documents won't be reused).

If you want to specify the document ID to be used, you should call
replace_document() instead.

If a transaction is active, the document addition is added to the
transaction; otherwise it is added to the current batch of changes.
Either way, it won't be visible to readers right away (unless we're
not in a transaction and the addition triggers an automatic commit).

Parameters:
-----------

doc:  The Document object to be added.

The document ID allocated to the document. ";

%feature("docstring")  Xapian::WritableDatabase::delete_document "

Delete a document from the database.

void Xapian::WritableDatabase::delete_document(Xapian::docid did)
Xapian::WritableDatabase::delete_document This method removes the
document with the specified document ID from the database.

If a transaction is active, the document removal is added to the
transaction; otherwise it is added to the current batch of changes.
Either way, it won't be visible to readers right away (unless we're
not in a transaction and the addition triggers an automatic commit).

Parameters:
-----------

did:  The document ID of the document to be removed. ";

%feature("docstring")  Xapian::WritableDatabase::delete_document "

Delete any documents indexed by a term from the database.

void Xapian::WritableDatabase::delete_document(std::string_view
unique_term) Xapian::WritableDatabase::delete_document This method
removes any documents indexed by the specified term from the database.

A major use is for convenience when UIDs from another system are
mapped to terms in Xapian, although this method has other uses (for
example, you could add a \"deletion date\" term to documents at index
time and use this method to delete all documents due for deletion on a
particular date).

Parameters:
-----------

unique_term:  The term to remove references to.

2.0.0 The changes made by this method are made atomically. Previously
automatic commits could happen during the batch. ";

%feature("docstring")  Xapian::WritableDatabase::replace_document "

Replace a document in the database.

void Xapian::WritableDatabase::replace_document(Xapian::docid did,
const Xapian::Document &document)
Xapian::WritableDatabase::replace_document This method replaces the
document with the specified document ID. If document ID did isn't
currently used, the document will be added with document ID did.

The monotonic counter used for automatically allocating document IDs
is increased so that the next automatically allocated document ID will
be did + 1. Be aware that if you use this method to specify a high
document ID for a new document, and also use
WritableDatabase::add_document(), Xapian may get to a state where this
counter wraps around and will be unable to automatically allocate
document IDs!

Note that changes to the database won't be immediately committed to
disk; see commit() for more details.

Parameters:
-----------

did:  The document ID of the document to be replaced.

document:  The new document. ";

%feature("docstring")  Xapian::WritableDatabase::replace_document "

Replace any documents matching a term.

Xapian::docid
Xapian::WritableDatabase::replace_document(std::string_view
unique_term, const Xapian::Document &document)
Xapian::WritableDatabase::replace_document This method replaces any
documents indexed by the specified term with the specified document.
If any documents are indexed by the term, the lowest document ID will
be used for the document, otherwise a new document ID will be
generated as for add_document.

One common use is to allow UIDs from another system to easily be
mapped to terms in Xapian. Note that this method doesn't automatically
add unique_term as a term, so you'll need to call
document.add_term(unique_term) first when using replace_document() in
this way.

Note that changes to the database won't be immediately committed to
disk; see commit() for more details.

Parameters:
-----------

unique_term:  The \"unique\" term.

document:  The new document.

The document ID used by the new document. If term existed in the
database, this will be the first document ID that was indexed by that
term; otherwise the database allocates ( get_lastdocid() + 1) as it
does for add_document().

2.0.0 The changes made by this method are made atomically. Previously
automatic commits could happen during the batch. ";

%feature("docstring")  Xapian::WritableDatabase::add_spelling "

Add a word to the spelling dictionary.

void Xapian::WritableDatabase::add_spelling(std::string_view word,
Xapian::termcount freqinc=1) const
Xapian::WritableDatabase::add_spelling If the word is already present,
its frequency is increased.

Parameters:
-----------

word:  The word to add.

freqinc:  How much to increase its frequency by (default 1). ";

%feature("docstring")  Xapian::WritableDatabase::remove_spelling "

Remove a word from the spelling dictionary.

termcount Xapian::WritableDatabase::remove_spelling(std::string_view
word, termcount freqdec=1) const
Xapian::WritableDatabase::remove_spelling The word's frequency is
decreased, and if would become zero or less then the word is removed
completely.

Parameters:
-----------

word:  The word to remove.

freqdec:  How much to decrease its frequency by (default 1).

Any \"unused\" freqdec (if the word's frequency was less than freqdec
then the difference is returned, else 0 is returned). Prior to 2.0.0
this method had void return type. ";

%feature("docstring")  Xapian::WritableDatabase::add_synonym "

Add a synonym for a term.

void Xapian::WritableDatabase::add_synonym(std::string_view term,
std::string_view synonym) const Xapian::WritableDatabase::add_synonym

Parameters:
-----------

term:  The term to add a synonym for.

synonym:  The synonym to add. If this is already a synonym for term,
then no action is taken. ";

%feature("docstring")  Xapian::WritableDatabase::remove_synonym "

Remove a synonym for a term.

void Xapian::WritableDatabase::remove_synonym(std::string_view term,
std::string_view synonym) const
Xapian::WritableDatabase::remove_synonym

Parameters:
-----------

term:  The term to remove a synonym for.

synonym:  The synonym to remove. If this isn't currently a synonym for
term, then no action is taken. ";

%feature("docstring")  Xapian::WritableDatabase::clear_synonyms "

Remove all synonyms for a term.

void Xapian::WritableDatabase::clear_synonyms(std::string_view term)
const Xapian::WritableDatabase::clear_synonyms

Parameters:
-----------

term:  The term to remove all synonyms for. If the term has no
synonyms, no action is taken. ";

%feature("docstring")  Xapian::WritableDatabase::set_metadata "

Set the user-specified metadata associated with a given key.

void Xapian::WritableDatabase::set_metadata(std::string_view key,
std::string_view metadata) Xapian::WritableDatabase::set_metadata This
method sets the metadata value associated with a given key. If there
is already a metadata value stored in the database with the same key,
the old value is replaced. If you want to delete an existing item of
metadata, just set its value to the empty string.

User-specified metadata allows you to store arbitrary information in
the form of (key, value) pairs.

There's no hard limit on the number of metadata items, or the size of
the metadata values. Metadata keys have a limited length, which depend
on the backend. We recommend limiting them to 200 bytes. Empty keys
are not valid, and specifying one will cause an exception.

Metadata modifications are committed to disk in the same way as
modifications to the documents in the database are: i.e.,
modifications are atomic, and won't be committed to disk immediately
(see commit() for more details). This allows metadata to be used to
link databases with versioned external resources by storing the
appropriate version number in a metadata item.

You can also use the metadata to store arbitrary extra information
associated with terms, documents, or postings by encoding the termname
and/or document id into the metadata key.

Parameters:
-----------

key:  The key of the metadata item to set.

metadata:  The value of the metadata item to set.

Parameters:
-----------

Xapian::DatabaseError:  will be thrown if a problem occurs while
writing to the database.

Xapian::DatabaseCorruptError:  will be thrown if the database is in a
corrupt state.

Xapian::InvalidArgumentError:  will be thrown if the key supplied is
empty.

Xapian::UnimplementedError:  will be thrown if the database backend in
use doesn't support user- specified metadata. ";

%feature("docstring")  Xapian::WritableDatabase::get_description "

Return a string describing this object.

std::string Xapian::WritableDatabase::get_description() const
Xapian::WritableDatabase::get_description";


// File: namespacestd.xml


// File: namespaceXapian.xml
%feature("docstring")  Xapian::Internal::version_string "

Report the version string of the library which the program is linked
with.

const char * Xapian::version_string() Xapian::version_string This may
be different to the version compiled against (given by XAPIAN_VERSION)
if shared libraries are being used. ";

%feature("docstring")  Xapian::Internal::major_version "

Report the major version of the library which the program is linked
with.

int Xapian::major_version() Xapian::major_version This may be
different to the version compiled against (given by
XAPIAN_MAJOR_VERSION) if shared libraries are being used. ";

%feature("docstring")  Xapian::Internal::minor_version "

Report the minor version of the library which the program is linked
with.

int Xapian::minor_version() Xapian::minor_version This may be
different to the version compiled against (given by
XAPIAN_MINOR_VERSION) if shared libraries are being used. ";

%feature("docstring")  Xapian::Internal::revision "

Report the revision of the library which the program is linked with.

int Xapian::revision() Xapian::revision This may be different to the
version compiled against (given by XAPIAN_REVISION) if shared
libraries are being used. ";

%feature("docstring")  Xapian::Internal::miles_to_metres "

Convert from miles to metres.

double Xapian::miles_to_metres(double miles) noexcept
Xapian::miles_to_metres Experimental -
seehttps://xapian.org/docs/deprecation#experimental-features ";

%feature("docstring")  Xapian::Internal::metres_to_miles "

Convert from metres to miles.

double Xapian::metres_to_miles(double metres) noexcept
Xapian::metres_to_miles Experimental -
seehttps://xapian.org/docs/deprecation#experimental-features ";

%feature("docstring")  Xapian::Internal::iterator_valid "bool
Xapian::iterator_valid(const Xapian::ESetIterator &it)
Xapian::iterator_valid";

%feature("docstring")  Xapian::Internal::iterator_valid "bool
Xapian::iterator_valid(const Xapian::MSetIterator &it)
Xapian::iterator_valid";

%feature("docstring")  Xapian::Internal::iterator_rewind "void
Xapian::iterator_rewind(Xapian::ESetIterator &it)
Xapian::iterator_rewind";

%feature("docstring")  Xapian::Internal::iterator_rewind "void
Xapian::iterator_rewind(Xapian::MSetIterator &it)
Xapian::iterator_rewind";

%feature("docstring")  Xapian::Internal::iterator_rewound "bool
Xapian::iterator_rewound(Xapian::ESetIterator &it)
Xapian::iterator_rewound";

%feature("docstring")  Xapian::Internal::iterator_rewound "bool
Xapian::iterator_rewound(Xapian::MSetIterator &it)
Xapian::iterator_rewound";

%feature("docstring")  Xapian::Internal::iterator_valid "bool
Xapian::iterator_valid(const Xapian::PositionIterator &it)
Xapian::iterator_valid";

%feature("docstring")  Xapian::Internal::iterator_valid "bool
Xapian::iterator_valid(const Xapian::PostingIterator &it)
Xapian::iterator_valid";

%feature("docstring")  Xapian::Internal::iterator_valid "bool
Xapian::iterator_valid(const Xapian::TermIterator &it)
Xapian::iterator_valid";

%feature("docstring")  Xapian::Internal::iterator_valid "bool
Xapian::iterator_valid(const Xapian::ValueIterator &it)
Xapian::iterator_valid";

%feature("docstring")  Xapian::Internal::iterator_valid "bool
Xapian::iterator_valid(const Xapian::Utf8Iterator &it)
Xapian::iterator_valid";

%feature("docstring")  Xapian::Internal::sortable_serialise "

Convert a floating point number to a string, preserving sort order.

std::string Xapian::sortable_serialise(double value)
Xapian::sortable_serialise This method converts a floating point
number to a string, suitable for using as a value for numeric range
restriction, or for use as a sort key.

The conversion is platform independent.

The conversion attempts to ensure that, for any pair of values
supplied to the conversion algorithm, the result of comparing the
original values (with a numeric comparison operator) will be the same
as the result of comparing the resulting values (with a string
comparison operator). On platforms which represent doubles with the
precisions specified by IEEE_754, this will be the case: if the
representation of doubles is more precise, it is possible that two
very close doubles will be mapped to the same string, so will compare
equal.

Note also that both zero and -zero will be converted to the same
representation: since these compare equal, this satisfies the
comparison constraint, but it's worth knowing this if you wish to use
the encoding in some situation where this distinction matters.

Handling of NaN isn't (currently) guaranteed to be sensible.

Parameters:
-----------

value:  The number to serialise. ";

%feature("docstring")  Xapian::Internal::sortable_unserialise "

Convert a string encoded using sortable_serialise back to a floating
point number.

double Xapian::sortable_unserialise(std::string_view serialised)
noexcept Xapian::sortable_unserialise This expects the input to be a
string produced by  sortable_serialise(). If the input is not such a
string, the value returned is undefined (but no error will be thrown).

The result of the conversion will be exactly the value which was
supplied to  sortable_serialise() when making the string on platforms
which represent doubles with the precisions specified by IEEE_754, but
may be a different (nearby) value on other platforms.

Parameters:
-----------

serialised:  The serialised string to decode. ";


// File: namespaceXapian_1_1Internal.xml


// File: namespaceXapian_1_1Remote.xml
%feature("docstring")  Xapian::Remote::open "

Construct a Database object for read-only access to a remote database
accessed via a TCP connection.

Database Xapian::Remote::open(std::string_view host, unsigned int
port, unsigned timeout=10000, unsigned connect_timeout=10000)
Xapian::Remote::open Access to the remote database is via a TCP
connection to the specified host and port.

Parameters:
-----------

host:  hostname to connect to.

port:  port number to connect to.

timeout:  timeout in milliseconds. If this timeout is exceeded for any
individual operation on the remote database then
Xapian::NetworkTimeoutError is thrown. A timeout of 0 means don't
timeout. (Default is 10000ms, which is 10 seconds).

connect_timeout:  timeout to use when connecting to the server. If
this timeout is exceeded then Xapian::NetworkTimeoutError is thrown. A
timeout of 0 means don't timeout. (Default is 10000ms, which is 10
seconds). ";

%feature("docstring")  Xapian::Remote::open_writable "

Construct a WritableDatabase object for update access to a remote
database accessed via a TCP connection.

WritableDatabase Xapian::Remote::open_writable(std::string_view host,
unsigned int port, unsigned timeout=0, unsigned connect_timeout=10000,
int flags=0) Xapian::Remote::open_writable Access to the remote
database is via a TCP connection to the specified host and port.

Parameters:
-----------

host:  hostname to connect to.

port:  port number to connect to.

timeout:  timeout in milliseconds. If this timeout is exceeded for any
individual operation on the remote database then
Xapian::NetworkTimeoutError is thrown. (Default is 0, which means
don't timeout).

connect_timeout:  timeout to use when connecting to the server. If
this timeout is exceeded then Xapian::NetworkTimeoutError is thrown. A
timeout of 0 means don't timeout. (Default is 10000ms, which is 10
seconds).

flags:   Xapian::DB_RETRY_LOCK or 0. ";

%feature("docstring")  Xapian::Remote::open "

Construct a Database object for read-only access to a remote database
accessed via a program.

Database Xapian::Remote::open(std::string_view program,
std::string_view args, unsigned timeout=10000) Xapian::Remote::open
Access to the remote database is done by running an external program
and communicating with it on stdin/stdout.

Parameters:
-----------

program:  the external program to run.

args:  space-separated list of arguments to pass to program.

timeout:  timeout in milliseconds. If this timeout is exceeded for any
individual operation on the remote database then
Xapian::NetworkTimeoutError is thrown. A timeout of 0 means don't
timeout. (Default is 10000ms, which is 10 seconds). ";

%feature("docstring")  Xapian::Remote::open_writable "

Construct a WritableDatabase object for update access to a remote
database accessed via a program.

WritableDatabase Xapian::Remote::open_writable(std::string_view
program, std::string_view args, unsigned timeout=0, int flags=0)
Xapian::Remote::open_writable Access to the remote database is done by
running an external program and communicating with it on stdin/stdout.

Parameters:
-----------

program:  the external program to run.

args:  space-separated list of arguments to pass to program.

timeout:  timeout in milliseconds. If this timeout is exceeded for any
individual operation on the remote database then
Xapian::NetworkTimeoutError is thrown. (Default is 0, which means
don't timeout).

flags:   Xapian::DB_RETRY_LOCK or 0. ";


// File: namespaceXapian_1_1Unicode.xml
%feature("docstring")  Xapian::Unicode::Internal::nonascii_to_utf8 "

Convert a single non-ASCII Unicode character to UTF-8.

unsigned Xapian::Unicode::nonascii_to_utf8(unsigned ch, char *buf)
Xapian::Unicode::nonascii_to_utf8 This is intended mainly as a helper
method for to_utf8().

Parameters:
-----------

ch:  The character (which must be > 128) to write to buf.

buf:  The buffer to write the character to - it must have space for
(at least) 4 bytes.

The length of the resultant UTF-8 character in bytes. ";

%feature("docstring")  Xapian::Unicode::Internal::to_utf8 "

Convert a single Unicode character to UTF-8.

unsigned Xapian::Unicode::to_utf8(unsigned ch, char *buf)
Xapian::Unicode::to_utf8

Parameters:
-----------

ch:  The character to write to buf.

buf:  The buffer to write the character to - it must have space for
(at least) 4 bytes.

The length of the resultant UTF-8 character in bytes. ";

%feature("docstring")  Xapian::Unicode::Internal::append_utf8 "

Append the UTF-8 representation of a single Unicode character to a
std::string.

void Xapian::Unicode::append_utf8(std::string &s, unsigned ch)
Xapian::Unicode::append_utf8";

%feature("docstring")  Xapian::Unicode::Internal::get_category "

Return the category which a given Unicode character falls into.

category Xapian::Unicode::get_category(unsigned ch)
Xapian::Unicode::get_category";

%feature("docstring")  Xapian::Unicode::Internal::is_wordchar "

Test if a given Unicode character is \"word character\".

bool Xapian::Unicode::is_wordchar(unsigned ch)
Xapian::Unicode::is_wordchar";

%feature("docstring")  Xapian::Unicode::Internal::is_whitespace "

Test if a given Unicode character is a whitespace character.

bool Xapian::Unicode::is_whitespace(unsigned ch)
Xapian::Unicode::is_whitespace";

%feature("docstring")  Xapian::Unicode::Internal::is_currency "

Test if a given Unicode character is a currency symbol.

bool Xapian::Unicode::is_currency(unsigned ch)
Xapian::Unicode::is_currency";

%feature("docstring")  Xapian::Unicode::Internal::tolower "

Convert a Unicode character to lowercase.

unsigned Xapian::Unicode::tolower(unsigned ch)
Xapian::Unicode::tolower";

%feature("docstring")  Xapian::Unicode::Internal::toupper "

Convert a Unicode character to uppercase.

unsigned Xapian::Unicode::toupper(unsigned ch)
Xapian::Unicode::toupper";

%feature("docstring")  Xapian::Unicode::Internal::tolower "

Convert a UTF-8 string to lowercase.

std::string Xapian::Unicode::tolower(std::string_view term)
Xapian::Unicode::tolower";

%feature("docstring")  Xapian::Unicode::Internal::toupper "

Convert a UTF-8 string to uppercase.

std::string Xapian::Unicode::toupper(std::string_view term)
Xapian::Unicode::toupper";


// File: namespaceXapian_1_1Unicode_1_1Internal.xml


// File: xapian_8h.xml


// File: attributes_8h.xml


// File: cluster_8h.xml


// File: compactor_8h.xml


// File: constants_8h.xml


// File: constinfo_8h.xml


// File: database_8h.xml


// File: dbfactory_8h.xml


// File: document_8h.xml


// File: enquire_8h.xml


// File: error_8h.xml


// File: eset_8h.xml


// File: expanddecider_8h.xml


// File: geospatial_8h.xml


// File: iterator_8h.xml


// File: keymaker_8h.xml


// File: matchdecider_8h.xml


// File: matchspy_8h.xml


// File: mset_8h.xml


// File: positioniterator_8h.xml


// File: postingiterator_8h.xml


// File: postingsource_8h.xml


// File: query_8h.xml


// File: queryparser_8h.xml


// File: registry_8h.xml


// File: rset_8h.xml


// File: stem_8h.xml


// File: termgenerator_8h.xml


// File: termiterator_8h.xml


// File: types_8h.xml


// File: unicode_8h.xml


// File: valueiterator_8h.xml


// File: valuesetmatchdecider_8h.xml


// File: version_8h.xml


// File: weight_8h.xml


// File: deprecated.xml


// File: dir_f63502d618711192f85ccb772536c6ae.xml

