/** @file
 * @brief date filtering using value ranges
 */
/* Copyright (C) 2015 Olly Betts
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 */

#ifndef OMEGA_INCLUDED_DATEVALUE_H
#define OMEGA_INCLUDED_DATEVALUE_H

#include <xapian.h>

#include <string>

Xapian::Query date_value_range(bool as_time_t,
			       Xapian::valueno slot,
			       const std::string & start,
			       const std::string & end,
			       const std::string & span);

#endif
